package br.edu.ifba.inf008.contabil.model;
import br.edu.ifba.inf008.contabil.util.Ordenavel;
import br.edu.inf008.contabil.exceptions.SaldoInsuficienteException;

public abstract  class Conta implements Comparable<Conta>{
    private String id;
    private String nome;
    protected double saldo;
    
    public Conta(String id, String nome){
        this.setId(id);
        this.setNome(nome);
        this.saldo = 0;
    } 
    
    private void setId(String id){
        this.id = id;
    }
    
    public String getId(){
        return this.id;
    }    
    
    public double valor(){
        return this.saldo;
    }
    
    public void setSaldo(double saldo){
    	this.saldo = saldo;
    }
        
    
    private void setNome(String nome){
        this.nome = nome;
    }    
    
    public String getNome(){
        return this.nome;
    }
    
    public abstract void creditar(double valor) throws SaldoInsuficienteException;
    
    public abstract void debitar(double valor) throws SaldoInsuficienteException;
    
    public abstract String tipo();
    
    
    public boolean canDo(double valor){
    	return(valor <= this.saldo);
    }
    
    
    public String toString(){
        return "[" + this.getId() + "/" + this.tipo() + "]" + this.nome + "\t.........\t" + this.saldo; 
    } 
    
    public int compareTo(Conta outra){
      return this.id.compareToIgnoreCase(((Conta)outra).id);
    }

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Conta other = (Conta) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}  
    
    
    
}    
