package br.edu.ifba.inf008.contabil.dao.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import br.edu.ifba.inf008.contabil.dao.ContaDAOIF;
import br.edu.ifba.inf008.contabil.model.Ativo;
import br.edu.ifba.inf008.contabil.model.Conta;
import br.edu.ifba.inf008.contabil.model.Passivo;
import br.edu.ifba.inf008.contabil.model.PatrimonioLiquido;
import br.edu.inf008.contabil.exceptions.ContaNaoExistenteException;

public class ContaDAOSQL extends AbstractDAOSQL implements ContaDAOIF{

	
	private static final int ATIVO = 1;
	private static final int PASSIVO = 2;
	private static final int PATRIMONIO_LIQUIDO = 3;    
	
	
	private static final String SELECT_BY_NAME = "SELECT id, nome, saldo, tipo FROM CONTA WHERE nome = ?";
	private static final String UPDATE = "UPDATE CONTA SET nome = ?, " +
														   "saldo = ?, " +
														   "tipo = ? " +
										  "WHERE id = ?";
	

	@Override
	public Conta buscarPeloNome(String nomeConta) throws ContaNaoExistenteException{
		Conta conta = null;
		PreparedStatement stmt;
		try {
			stmt = this.getConnection().prepareStatement(SELECT_BY_NAME);
			stmt.setString(1, nomeConta);
			ResultSet rSet = stmt.executeQuery();
			if(rSet.next()){
				String id = rSet.getString("id");
				String nome = rSet.getString("nome");
				double saldo = rSet.getDouble("saldo");
				int tipo = rSet.getInt("tipo");
				conta = createConta(id, nome, saldo, tipo);
			}else{
				throw new ContaNaoExistenteException(nomeConta);
			}
		} catch (SQLException e) {
			throw new ContaNaoExistenteException(e, nomeConta);
		}
		return conta;
	}

	private Conta createConta(String id, String nome, double saldo, int tipo) {
		Conta conta = null;
		if(tipo == ContaDAOSQL.ATIVO)
			conta = new Ativo(id, nome);
		else if(tipo == ContaDAOSQL.PASSIVO)
			conta = new Passivo(id, nome);
		else if(tipo == ContaDAOSQL.PATRIMONIO_LIQUIDO)
			conta = new PatrimonioLiquido(id, nome);
		conta.setSaldo(saldo);
		return conta;
	}
	
	private int getTipo(Conta conta) {
		if(conta.getClass() == Ativo.class)
			return ContaDAOSQL.ATIVO;
		else if(conta.getClass() == Passivo.class)
			return ContaDAOSQL.PASSIVO;
		else if(conta.getClass() ==  PatrimonioLiquido.class)
			return ContaDAOSQL.PATRIMONIO_LIQUIDO;
		return -1;
	}	

	@Override
	public void salvar(Conta conta) throws Exception {
		PreparedStatement stmt = this.getConnection().prepareStatement(ContaDAOSQL.UPDATE);
		stmt.setString(1, conta.getNome());
		stmt.setDouble(2, conta.valor());
		stmt.setInt(3, this.getTipo(conta));
		stmt.setString(4, conta.getId());
		stmt.executeUpdate();
	}

}
