package br.edu.ifba.inf008.contabil.model;

import br.edu.inf008.contabil.exceptions.ContaNaoExistenteException;
import br.edu.inf008.contabil.exceptions.SaldoInsuficienteException;

public class RegistroContabil{
    
    public static final int ATIVO = 1;
    public static final int PASSIVO = 2;
    public static final int PATRIMONIO_LIQUIDO = 3;    
    
    private String nomeEmpresa;
    private String cnpjEmpresa; 
    private BalancoContabil balanco;
    private LivroContabil livro;
    
    public RegistroContabil(String nomeEmpresa, String cnpjEmpresa){
        this.setNomeEmpresa(nomeEmpresa);
        this.setCNPJEmpresa(cnpjEmpresa);
        this.balanco = new BalancoContabil();
        this.livro = new LivroContabil();
    }  
    
    private void setNomeEmpresa(String nomeEmpresa){
        this.nomeEmpresa = nomeEmpresa;
    }    
    
    private void setCNPJEmpresa(String cnpjEmpresa){
        this.cnpjEmpresa = cnpjEmpresa;
    }    
    
    
    public void registrarFatoContabil(long timestamp,
                                      String descricao, 
                                      String nomeContaCredito, 
                                      String nomeContaDebito, 
                                      double valor){
      Conta credito = null;
      Conta debito = null;
      try{
    	  credito = this.balanco.buscarPeloNome(nomeContaCredito);                                    
    	  debito = this.balanco.buscarPeloNome(nomeContaDebito);      
	      this.balanco.ajustar(nomeContaCredito, nomeContaDebito, valor);
	      Lancamento lancamento = new Lancamento(timestamp, descricao, credito, debito, valor);
	      this.livro.registrar(lancamento);
      }catch(ContaNaoExistenteException ex){
    	  System.out.println("Lancamento no efetuado.");
    	  System.out.println("Causa: Conta Inexistente - " + ex.getNomeConta());
      } catch (SaldoInsuficienteException e) {
    	  System.out.println("Lancamento no efetuado: " + descricao);
    	  System.out.println("Causa: Saldo Insuficiente - " + e.getNomeConta());
    	  System.out.println("Valor Disponivel - " + e.getSaldoDisponivel());
    	  System.out.println("Valor Necessario - " + e.getSaldoNecessario());
      }
    } 
    
    public void registrarNovaConta(int tipo, String id, String nome){
        Conta conta = null;
        if(tipo == RegistroContabil.ATIVO)
          conta = new Ativo(id, nome);
        else if(tipo == RegistroContabil.PASSIVO)
          conta = new Passivo(id, nome);
        else if(tipo == RegistroContabil.PATRIMONIO_LIQUIDO)
          conta = new PatrimonioLiquido(id, nome);
        this.balanco.adicionar(conta);  
  
    }   
    
    public String toString(){
        String rep = this.nomeEmpresa + "---" + this.cnpjEmpresa + "\n";
        rep += "Lancamentos\n";
        rep += this.livro;
        rep += "\nBalanco\n";        
        return rep + this.balanco;
    }    
    
}
