package br.edu.ifba.inf008.contabil.model;

import br.edu.inf008.contabil.exceptions.ContaNaoExistenteException;
import br.edu.inf008.contabil.exceptions.SaldoInsuficienteException;

public class RegistroContabil{
    
    
    private String nomeEmpresa;
    private String cnpjEmpresa; 
    private BalancoContabil balanco;
    private LivroContabil livro;
    
    public RegistroContabil(String nomeEmpresa, String cnpjEmpresa){
        this.setNomeEmpresa(nomeEmpresa);
        this.setCNPJEmpresa(cnpjEmpresa);
        this.balanco = new BalancoContabil();
        this.livro = new LivroContabil();
    }  
    
    private void setNomeEmpresa(String nomeEmpresa){
        this.nomeEmpresa = nomeEmpresa;
    }    
    
    private void setCNPJEmpresa(String cnpjEmpresa){
        this.cnpjEmpresa = cnpjEmpresa;
    }    
    
    
    public void registrarNovaConta(int tipo, String id, String nome){
    	Conta conta = null;
    	if(tipo == RegistroContabil.ATIVO)
    	conta = new Ativo(id, nome);
    	else if(tipo == RegistroContabil.PASSIVO)
    	conta = new Passivo(id, nome);
    	else if(tipo == RegistroContabil.PATRIMONIO_LIQUIDO)
    	conta = new PatrimonioLiquido(id, nome);
    	this.balanco.adicionar(conta);  

    	}   
    
    public String toString(){
        String rep = this.nomeEmpresa + "---" + this.cnpjEmpresa + "\n";
        rep += "Lancamentos\n";
        rep += this.livro;
        rep += "\nBalanco\n";        
        return rep + this.balanco;
    }    
    
}
