package br.edu.ifba.ads.mediaCenter;

import br.edu.ifba.ads.mediaCenter.exceptions.ArquivoNaoArmazenadoException;
import br.edu.ifba.ads.mediaCenter.exceptions.BuscavelNaoEncontradoException;
import br.edu.ifba.ads.mediaCenter.exceptions.FragmentoNaoArmazenadoException;

public class App{
    
    public void run(){
        MediaCenter media = new MediaCenter();
        
        ServidorReplicado anubis = new ServidorReplicado("anubis");
        ServidorReplicado thot = new ServidorReplicado("thot");        
        
        thot.addServidor(new ServidorBasico("osiris", 512, 0.25, 0.25));
        thot.addServidor(new ServidorBasico("isis", 256, 0.1, 0.1));        
        
        anubis.addServidor(thot);
        anubis.addServidor(new ServidorBasico("bast", 512, 0.05, 0.05));
        
        media.addServidor(new ServidorBasico("horus", 1024, 0.5, 0.8));
        media.addServidor(new ServidorBasico("ra", 1024, 0.4, 1.0));        
        media.addServidor(anubis); 
        

        Arquivo a1 = new Arquivo("S1");
        
        a1.addFragmento(new Fragmento("S1.1", 100));
        a1.addFragmento(new Fragmento("S1.2", 100));
        a1.addFragmento(new Fragmento("S1.3", 100));        
        
        Arquivo a2 = new Arquivo("S2");
        a2.addFragmento(new Fragmento("S2.1", 200));
        a2.addFragmento(new Fragmento("S2.2", 200));
        a2.addFragmento(new Fragmento("S2.3", 100));          
        a2.addFragmento(new Fragmento("S2.4", 100));          

        Arquivo a3 = new Arquivo("S3");
        a3.addFragmento(new Fragmento("S3.1", 1024));
        a3.addFragmento(new Fragmento("S3.2", 324));
        a3.addFragmento(new Fragmento("S3.3", 50));          
        a3.addFragmento(new Fragmento("S3.4", 50));         
        
        System.out.println(media);        
        
        
        
        try {
			System.out.println("Tempo de armazenamento de " + a1 + ": " + media.getTempoArmazenamento(a1) + "\n");
//	        System.out.println(media); 
	        System.out.println("A1 armazenado...");
			System.out.println("Tempo de armazenamento de " + a2 + ": " + media.getTempoArmazenamento(a2) + "\n");
//	        System.out.println(media);
	        System.out.println("A2 armazenado...");	        
			System.out.println("Tempo de armazenamento de " + a3 + ": " + media.getTempoArmazenamento(a3) + "\n");
	        System.out.println("A3 armazenado...");			
//	        System.out.println(media);        
		} catch (ArquivoNaoArmazenadoException e) {
			System.out.println("Arquivo no Armazenado: " + e.getId() + "\n");
		}
        
        System.out.println(media);        

        try{
	        System.out.println("Tempo de Recuperacao de " + a1 + ": " + media.getTempoLeitura("S1") + "\n");
	        System.out.println("Tempo de Recuperacao de " + a2 + ": " + media.getTempoLeitura("S2") + "\n");        
	        System.out.println("Tempo de Recuperacao de " + a3 + ": " + media.getTempoLeitura("S3") + "\n");	        
        }catch(ArquivoNaoArmazenadoException deupau){
        	System.out.println("Arquivo no existe: " + deupau.getId());
        }catch(FragmentoNaoArmazenadoException deupau){
        	System.out.println("Arquivo no armazenado: " + deupau.getId());
        }	
        
        
	    System.out.println("Finalizando......\n");
	        
    }

    
    public void run2(){
        MediaCenter media = new MediaCenter();
        
        media.addServidor(new ServidorBasico("horus", 1024, 0.5, 0.8));

        System.out.println(media);        
        
        
        Arquivo a1 = new Arquivo("A1");
        
        a1.addFragmento(new Fragmento("S1.1", 900));
        a1.addFragmento(new Fragmento("S1.2", 100));
        a1.addFragmento(new Fragmento("S1.3", 300));  

        try {
			System.out.println("Tempo de armazenamento de " + a1 + ": " + media.getTempoArmazenamento(a1) + "\n");
		} catch (ArquivoNaoArmazenadoException ex) {
			System.out.println("ERRO ARMAZENANDO ARQUIVO");
			ex.printStackTrace();
		}        
        
        System.out.println(media);        
        
    }
    
    public static void main(String[] args){
    		(new App()).run();
	}
    
    
}
