package br.edu.ifba.ads.mediaCenter;

import br.edu.ifba.ads.mediaCenter.util.Buscavel;

public abstract class Servidor implements Buscavel{
    public String id;
    
    public Servidor(String id){
        this.id = id;
    }   
    
    public String getId(){
        return this.id;
    }    
    
    public boolean temCapacidade(Fragmento f){
        return this.getCapacidade() >= f.getTamanho();
    }    
    
    public abstract double getLatenciaEscrita();
    
    public abstract double getLatenciaLeitura();    
    
    public double gravar(Fragmento f){
      f.setServidor(this);  
      this.ocupar(f.getTamanho());
      return f.getTamanho() * this.getLatenciaEscrita();
    };
    
	public void liberar(Fragmento f) {
		f.setServidor(null);
		this.desocupar(f.getTamanho());
	}     
    
	public abstract void desocupar(long tamanho);
	
    public abstract void ocupar(long tamanho); 
    
    public abstract long getCapacidade();
    
    public boolean ehChave(Object id){
        return this.getId().equals(id);
    }    
    
    public String toString(){
        return "Servidor [" + this.id + 
                         " / R: " + this.getLatenciaLeitura() +  
                         " / W: " + this.getLatenciaEscrita() + "]" +
                         " / Size: " + getCapacidade();
    }

   
    
    
}

