package br.edu.ifba.ads.mediaCenter;


import br.edu.ifba.ads.mediaCenter.exceptions.FragmentoNaoArmazenadoException;
import br.edu.ifba.ads.mediaCenter.util.Buscavel;

public class Arquivo implements Buscavel{
    
    private String id;
    private Fragmento[] fragmentos;
    private java.util.Date horario = new java.util.Date();
    private java.sql.Date data = new java.sql.Date(0);
    
    public java.util.Date getHorario(){
    	return this.horario;
    }	

    
    public Arquivo(String id){
        this.id = id;
        this.fragmentos = new Fragmento[0];
    } 
    
    public String getId(){
        return this.id;
    }    
    
    
    public double getTempoRecuperacao() throws FragmentoNaoArmazenadoException{
        double tempoRecuperacao = 0;
        for(Fragmento f : this.fragmentos)
            tempoRecuperacao += f.getTempoRecuperacao();  
        return tempoRecuperacao;
    }    
    
    
    public long getTamanho(){
        long tamanho = 0;
        for(Fragmento f : this.fragmentos)
          tamanho += f.getTamanho();
        return tamanho;  
    }    
    
    
    public void addFragmento(Fragmento fragmento){
        Fragmento[] novo = new Fragmento[this.fragmentos.length + 1];
        for(int iCont = 0; iCont < this.fragmentos.length; iCont++)
          novo[iCont] = this.fragmentos[iCont];
        novo[novo.length - 1] = fragmento;
        this.fragmentos = novo;
    }      
    
    public Fragmento[] getOrdenadoPorTamanho(){
        for(int iCont = 0; iCont < this.fragmentos.length; iCont++)
            for(int jCont = iCont + 1; jCont < this.fragmentos.length; jCont++)
              if(this.fragmentos[iCont].getTamanho() < this.fragmentos[jCont].getTamanho()){
                  Fragmento aux = this.fragmentos[iCont];
                  this.fragmentos[iCont] = this.fragmentos[jCont];
                  this.fragmentos[jCont] = aux;
              }    
        return this.fragmentos;
    }  
    
    public String toString(){
        return this.id + "[" + this.getTamanho() + "]";
    } 
    
    public String getDescritor(){
        String rep = this.toString() + "\n";
        for(Fragmento f : this.fragmentos)
          rep = rep + "\t" + f + "\n";
        return rep;  
    } 
    
    public boolean ehChave(Object id){
        return this.getId().equals(id);
    }    
    
    
}
