package br.edu.ifba.ads.mediaCenter;

import br.edu.ifba.ads.mediaCenter.exceptions.FragmentoNaoArmazenadoException;

public class Fragmento{
    private String id;
    private long tamanho;
    private Servidor servidor;
    
    public Fragmento(String id, long tamanho){
        this.id = id;
        this.tamanho = tamanho;
    }  
    
    public String getId(){
    	return this.id;
    }
    
    public double getTempoRecuperacao() throws FragmentoNaoArmazenadoException{
    	if(this.servidor == null)
    		throw new FragmentoNaoArmazenadoException(id);
        return this.servidor.getLatenciaLeitura() * this.tamanho;
    }    
    
    public long getTamanho(){
        return this.tamanho;
    }    
    
    public void setServidor(Servidor servidor){
        this.servidor = servidor;
    }; 
    
    public Servidor getServidor(){
    	return this.servidor;
    };
    
    public String toString(){
        return this.id + "[" + this.getTamanho() + "] @ " + this.servidor.getId();
    }    
    
}
