public class MediaCenter{
    private Servidor[] servidores;
    private Arquivo[] arquivos;    
    
    
    public MediaCenter(){
        this.servidores = new Servidor[0];
        this.arquivos = new Arquivo[0];        
    }    

    public double getTempoArmazenamento(Arquivo arquivo){
        double tempo = 0;
        Fragmento[] fragmentos = arquivo.getOrdenadoPorTamanho();
        for(Fragmento f : fragmentos){
          Servidor destino = null;  
          for(Servidor s : this.servidores)
            if(s.temCapacidade(f) && 
              ((destino== null)|| (destino != null && destino.getLatenciaEscrita() > s.getLatenciaEscrita())))
               destino = s;
          tempo += destino.gravar(f); 
        }
        this.addArquivo(arquivo);
        return tempo;
    }  

    
    public Arquivo buscarArquivoPeloId(String id){
        for(Arquivo a : this.arquivos)
          if(a.getId().equals(id))
            return a;
        return null;    
    }    
    
    
    public double getTempoLeitura(String id){
        Arquivo a = this.buscarArquivoPeloId(id);
        return a.getTempoRecuperacao();
    }      
    
    private void addArquivo(Arquivo arquivo){
        Arquivo[] novo = new Arquivo[this.arquivos.length + 1];
        for(int iCont = 0; iCont < this.arquivos.length; iCont++)
          novo[iCont] = this.arquivos[iCont];
        novo[novo.length - 1] = arquivo;
        this.arquivos = novo;
    }  
    
    public void addServidor(Servidor servidor){
        Servidor[] novo = new Servidor[this.servidores.length + 1];
        for(int iCont = 0; iCont < this.servidores.length; iCont++)
          novo[iCont] = this.servidores[iCont];
        novo[novo.length - 1] = servidor;
        this.servidores = novo;
    }  
    
    public String toString(){
        String str = "Servidores\n";
        for(Servidor s : this.servidores)
          str += s.toString() + "\n";
        str += "Arquivos\n";
        for(Arquivo a : this.arquivos)
          str += a.getDescritor() + "\n";
        
        return str + "\n"; 
        
    }    
    
}
