public class Banco{
    
    private Conta[] contas;
    
    public Banco(){
        this.contas = new Conta[0];
    }    
    
    public void addConta(Conta conta){
        Conta[] novo = new Conta[this.contas.length + 1];
        for(int iCont = 0; iCont < this.contas.length; iCont++)
            novo[iCont] = this.contas[iCont];
        novo[novo.length - 1] = conta;
        this.contas = novo;
    }  
    
    public void depositar(String id, double valor){
        this.buscarPeloId(id).depositar(valor);
    }    
    
    public void sacar(String id, double valor){
        this.buscarPeloId(id).sacar(valor);
    }    
    
    public void transferir(String idOrigem, String idDestino, double valor){
        this.sacar(idOrigem, valor);
        this.depositar(idDestino, valor);
    }    
    
    
    private Conta buscarPeloId(String id){
        for(Conta conta : this.contas)
          if(conta.getId().equals(id))
            return conta;
        return null;    
    }    
    
    public String toString(){
        String rep = "**********\n";
        for(Conta conta : this.contas)
          rep += "\t" + conta + "\n";
        return rep;  
    }    
    
    
}
