package inf008;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

import inf008.contabil.ContabilSessao;
import inf008.contabil.RegistroContabil;
import inf008.persistencia.ContaDAO;
import inf008.persistencia.LancamentoDAO;
import inf008.persistencia.memory.LancamentoDAOMemory;
import inf008.persistencia.sql.ContaDAOSQL;
import inf008.persistencia.sql.LancamentoDAOSQL;
import inf008.ui.ContaUI;
import inf008.ui.console.ContaConsoleUI;
import inf008.ui.jfc.JFatoContabil;

public class Factory {
	
	private String contaDAOName;
	private String lancamentoDAOName;
	private String logicaName;	
	private String UIName;
	
	public Factory(String confFileName) throws FileNotFoundException, IOException{
		this.load(confFileName);
	}
	
	
	public ContaDAO getContaDAO() throws InstantiationException, IllegalAccessException, ClassNotFoundException{
		return (ContaDAO) Class.forName(this.contaDAOName).newInstance();
	}	
	
	public LancamentoDAO getLancamentoDAO() throws InstantiationException, IllegalAccessException, ClassNotFoundException{
		return (LancamentoDAO) Class.forName(this.lancamentoDAOName).newInstance();
	}
	
	public ContabilSessao getContabilSessao() throws InstantiationException, IllegalAccessException, ClassNotFoundException{
		return (ContabilSessao) Class.forName(this.logicaName).newInstance();
	}
	
	public ContaUI getUI() throws InstantiationException, IllegalAccessException, ClassNotFoundException{
		return (ContaUI) Class.forName(this.UIName).newInstance();
	}
	
	
	public void load(String fileName) throws FileNotFoundException, IOException{
		Properties props = new Properties();
		props.load(new FileReader(new File(fileName)));
		
		this.UIName = props.getProperty("UI");
		this.logicaName = props.getProperty("LOGICA");
		this.contaDAOName = props.getProperty("CONTADAO");
		this.lancamentoDAOName = props.getProperty("LANCAMENTODAO");
		
	}
	
}
