package inf008.ui;

import java.util.List;

import javax.swing.table.DefaultTableModel;

import inf008.contabil.ContabilSessao;
import inf008.ui.vo.LancamentoVO;

public class LancamentoModel extends DefaultTableModel{

	private ContabilSessao logica;
	private List<LancamentoVO> lancamentos;
	
	private String[] titulos = {"Ordem",
            "Descrio",
            "Conta Dbito",
            "Conta Crdito",
            "Valor"};
	
	
	public LancamentoModel(ContabilSessao logica) throws Exception{
		this.logica = logica;
		this.updateData();
	}
	
	public void updateData() throws Exception{
		this.lancamentos = this.logica.gerarLivro();
		this.fireTableChanged(null);
	}
	
	
	@Override
	public int getColumnCount() {
		return this.titulos.length;
	}
	
	@Override
	public int getRowCount() {
		if(this.lancamentos != null)
			return this.lancamentos.size();
		return 0;
	}

	@Override
	public Object getValueAt(int arg0, int arg1) {
		String value = "";
		LancamentoVO lancamento = this.lancamentos.get(arg0);
		switch(arg1){
			case 0: value = Integer.toString(lancamento.getOrdem()); break;
			case 1: value = lancamento.getDescricao(); break;
			case 2: value = lancamento.getNomeCredito(); break;			
			case 3: value = lancamento.getNomeDebito(); break;			
			case 4: value = Double.toString(lancamento.getValor()); break;			
		}
		return value;
	}
	
	public boolean isCellEditable(int row, int col){
		return false; 
	}	
	
	public String getColumnName(int columnIndex){
		return this.titulos[columnIndex];
	}

}
