package inf008.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import inf008.contabil.ContabilSessao;
import inf008.contabil.RegistroContabil;

public class ContaConsoleUI {
	
	private ContabilSessao logica;
	private BufferedReader reader;
	
	public ContaConsoleUI(){
		this.reader = new BufferedReader(
	            	  new InputStreamReader(
	            			  System.in));
		this.logica = new RegistroContabil("ABC","0000");
	}
	
	
	public void showMenu() throws Exception{
		int option;
		System.out.println("Operacoes");
		System.out.println("[1] - Registrar Fato Contabil");
		System.out.println("[2] - Exibir Livro");
		System.out.println("[3] - Exibir Balanco");
		option = Integer.parseInt(this.reader.readLine());
		switch(option){
			case 1 : this.registrarFato(); break; 
			case 2 : this.exibirLivro(); break;
			case 3 : this.exibirBalanco(); break;
		}
	}

	private void exibirBalanco() throws Exception {
		System.out.println("Livro Contabil");
		System.out.println(this.logica.gerarBalanco());
		System.out.println("***************");	}


	private void exibirLivro() throws Exception {
		System.out.println("Livro Contabil");
		System.out.println(this.logica.gerarLivro());
		System.out.println("***************");
	}


	private void registrarFato() throws Exception {
		int id;
		String descricao;
        String nomeContaCredito;
        String nomeContaDebito;
        double valor;
		System.out.println("Id do fato : ");
		id = Integer.parseInt(this.reader.readLine());
		System.out.println("Descricao : ");		
		descricao = this.reader.readLine();		
		System.out.println("Conta Credito : ");		
		nomeContaCredito = this.reader.readLine();		
		System.out.println("Conta Debito : ");		
		nomeContaDebito = this.reader.readLine();		
		System.out.println("Valor : ");		
		valor = Double.parseDouble(this.reader.readLine());	
		this.logica.registrarFatoContabil(id, descricao, nomeContaCredito, nomeContaDebito, valor);
		System.out.println("Fato Registrado");		
	}
	
	public void run() throws Exception{
		while(true){
			this.showMenu();
		}
	}
	
	public static void main(String[] args) throws Exception {
		(new ContaConsoleUI()).run();
	}
	

}
