package inf008.contabil;


import inf008.util.json.JSonnable;
import inf008.util.json.CampoJSon;

public class Lancamento implements Comparable<Lancamento>, JSonnable{
    private int ordem;
    private String descricao;
    private double valor;
    private Conta credito;
    private Conta debito;  
    
    
    public Lancamento(int ordem, String descricao, Conta credito, Conta debito, double valor){
        this.ordem = ordem;
        this.descricao = descricao;
        this.credito = credito;
        this.debito = debito; 
        this.valor = valor; 
    }   
    
    public int getOrdem() {
		return ordem;
	}

	public String getDescricao() {
		return descricao;
	}





	public double getValor() {
		return valor;
	}

	public Conta getCredito() {
		return credito;
	}

	public Conta getDebito() {
		return debito;
	}

   
    public String toString(){
        return "[" + this.ordem + "] - Descricao " + this.descricao + "\n" +
               "Valor R$" + this.valor + "\n" + 
               "Credito " + this.credito.getNome() + "\n" +
               "Debito " + this.debito.getNome();
    }
    
    
    public CampoJSon[] getCampos(){
        CampoJSon[] campos = new CampoJSon[5];

        campos[0] = new CampoJSon("ordem", this.ordem);
        campos[1] = new CampoJSon("descricao", this.descricao);        
        campos[2] = new CampoJSon("valor", this.valor);
        campos[3] = new CampoJSon("credito", this.credito.getNome());        
        campos[4] = new CampoJSon("debito", this.debito.getNome());         
        
        return campos;
        
        
    }

	@Override
	public int compareTo(Lancamento arg0) {
        return this.ordem - arg0.ordem;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ordem;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Lancamento other = (Lancamento) obj;
		if (ordem != other.ordem)
			return false;
		return true;
	} 
	
	
    
   
    
}
