package inf008.persistencia.memory;


import inf008.contabil.Conta;
import inf008.exception.ContaNaoEncontradaException;
import inf008.persistencia.ContaDAO;
import inf008.util.ordenacao.Ordenador;

public class BalancoContabil implements ContaDAO{
    private Conta[] contas = new Conta[0];
    
    public void save(Conta conta){
        Conta[] novo = new Conta[this.contas.length + 1];
        for(int i = 0; i < this.contas.length; i++)
          novo[i] = contas[i];
        
        novo[novo.length - 1] =  conta;
        
        this.contas = novo;
        
    }    
    
    
    public Conta findByName(String nome) throws ContaNaoEncontradaException{
        for(Conta atual : this.contas)
          if (atual.getNome().equals(nome))
            return atual;
        throw new ContaNaoEncontradaException(nome);  
    }    
    
    public String toString(){
        Ordenador ordenador = new Ordenador();
        ordenador.ordenar(this.contas);
        String rep = "";
        for(Conta atual : this.contas)
          rep += atual + "\n";
        return rep;  
    }    
    
    
}
