public class ElementoQuimico implements JSonnable{
    
    private int numeroAtomico;
    private int numeroMassa;
    private String nome;
    
    public ElementoQuimico(int numeroAtomico,
                           int numeroMassa,
                           String nome){
      this.setNumeroAtomico(numeroAtomico);                         
      this.setNumeroMassa(numeroMassa);   
      this.setNome(nome);
    }  
    
    public void setNumeroAtomico(int numeroAtomico){
        this.numeroAtomico = numeroAtomico;                                 
    }
    
    public void setNumeroMassa(int numeroMassa){
        this.numeroMassa = numeroMassa;                                 
    }
    
    public void setNome(String nome){
        this.nome = nome;                                 
    }    
    
    public int getNumeroAtomico(){
        return this.numeroAtomico; 
    }    
    
    public boolean equals(ElementoQuimico eq){
        return this.getNumeroAtomico() == eq.getNumeroAtomico();
    }    
    
   public String getNome(){
        return this.nome;  
    }      
    
    public String toString(){
        return "[" + this.getNumeroAtomico() + "] - " + this.getNome();
    }  
    
    
    public String[] getNomeAtributos(){
        String[] nomes = {"numeroAtomico", "numeroMassa", "nome"};
        return nomes;
    };
    
    public String[] getValoresAtributos(){
        String[] valores = new String[3];
        valores[0] = Integer.toString(this.getNumeroAtomico());
        valores[1] = Integer.toString(this.numeroMassa);
        valores[2] = this.getNome();
        return valores;
    };    
    
    public int[] getTiposAtributos(){
        int[] tipos = {JSonnable.INT, JSonnable.INT, JSonnable.STRING};
        return tipos;
        
    };      
    
}
