/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package visitor;

import java.util.ArrayList;

/**
 *
 * @author aluno
 */
public class Visitor {

    public static void realizarVisitacoes() {
        for(IElement element: agregado)
            for(IVisitor visitor: visitors)
                element.accept(visitor);
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        // Constroi o agregado
        agregado.add(new Aluno(8.0, 2.0));
        agregado.add(new Aluno(5.0, 1.7));
        agregado.add(new Professor(1.8, 2));
        agregado.add(new Aluno(10.0, 1.4));
        agregado.add(new Professor(1.5, 20));
        
        // Criar as visitors
        visitors.add(new VisitorAlturaMedia());
        visitors.add(new VisitorScoreMedio());
        
        realizarVisitacoes();
        
        System.out.println("Altura media: " + ((VisitorAlturaMedia)visitors.get(0)).getAlturaMedia());
        System.out.println("Score medio: " + ((VisitorScoreMedio)visitors.get(1)).getScoreMedio());
    }
    
    private static ArrayList<IElement> agregado = new ArrayList<IElement>();
    private static ArrayList<IVisitor> visitors = new ArrayList<IVisitor>();
    
}
