/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

public class ContactID {
    public final Features features;

    public boolean isEqual(ContactID cid) {
        return cid.features.isEqual(this.features);
    }

    public ContactID() {
        this.features = new Features();
    }

    public ContactID(ContactID c) {
        this.features = new Features(c.features);
    }

    public void set(ContactID c) {
        this.features.set(c.features);
    }

    public void zero() {
        this.features.flip = 0;
        this.features.incidentEdge = 0;
        this.features.incidentVertex = 0;
        this.features.referenceEdge = 0;
    }

    public static class Features {
        public int referenceEdge;
        public int incidentEdge;
        public int incidentVertex;
        public int flip;

        public Features() {
            this.flip = 0;
            this.incidentVertex = 0;
            this.incidentEdge = 0;
            this.referenceEdge = 0;
        }

        private Features(Features f) {
            this.referenceEdge = f.referenceEdge;
            this.incidentEdge = f.incidentEdge;
            this.incidentVertex = f.incidentVertex;
            this.flip = f.flip;
        }

        private void set(Features f) {
            this.referenceEdge = f.referenceEdge;
            this.incidentEdge = f.incidentEdge;
            this.incidentVertex = f.incidentVertex;
            this.flip = f.flip;
        }

        private boolean isEqual(Features f) {
            return this.referenceEdge == f.referenceEdge && this.incidentEdge == f.incidentEdge && this.incidentVertex == f.incidentVertex && this.flip == f.flip;
        }

        public String toString() {
            String s = "Features: (" + this.flip + " ," + this.incidentEdge + " ," + this.incidentVertex + " ," + this.referenceEdge + ")";
            return s;
        }
    }
}

