/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import org.jbox2d.collision.broadphase.BroadPhase;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Sweep;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactEdge;
import org.jbox2d.dynamics.joints.JointEdge;

public class Body {
    public static final int e_islandFlag = 1;
    public static final int e_awakeFlag = 2;
    public static final int e_autoSleepFlag = 4;
    public static final int e_bulletFlag = 8;
    public static final int e_fixedRotationFlag = 16;
    public static final int e_activeFlag = 32;
    public static final int e_toiFlag = 64;
    public BodyType m_type;
    public int m_flags;
    public int m_islandIndex;
    public final Transform m_xf = new Transform();
    public final Sweep m_sweep = new Sweep();
    public final Vec2 m_linearVelocity = new Vec2();
    public float m_angularVelocity = 0.0f;
    public final Vec2 m_force = new Vec2();
    public float m_torque = 0.0f;
    public World m_world;
    public Body m_prev;
    public Body m_next;
    public Fixture m_fixtureList;
    public int m_fixtureCount;
    public JointEdge m_jointList;
    public ContactEdge m_contactList;
    public float m_mass;
    public float m_invMass;
    public float m_I;
    public float m_invI;
    public float m_linearDamping;
    public float m_angularDamping;
    public float m_sleepTime;
    public Object m_userData;
    private final FixtureDef fixDef = new FixtureDef();
    private final MassData pmd = new MassData();
    private final Transform pxf = new Transform();

    public Body(BodyDef bd, World world) {
        assert (bd.position.isValid());
        assert (bd.linearVelocity.isValid());
        assert (bd.inertiaScale >= 0.0f);
        assert (bd.angularDamping >= 0.0f);
        assert (bd.linearDamping >= 0.0f);
        this.m_flags = 0;
        if (bd.bullet) {
            this.m_flags |= 8;
        }
        if (bd.fixedRotation) {
            this.m_flags |= 0x10;
        }
        if (bd.allowSleep) {
            this.m_flags |= 4;
        }
        if (bd.awake) {
            this.m_flags |= 2;
        }
        if (bd.active) {
            this.m_flags |= 0x20;
        }
        this.m_world = world;
        this.m_xf.position.set(bd.position);
        this.m_xf.R.set(bd.angle);
        this.m_sweep.localCenter.setZero();
        this.m_sweep.a0 = this.m_sweep.a = bd.angle;
        Transform.mulToOut(this.m_xf, this.m_sweep.localCenter, this.m_sweep.c0);
        this.m_sweep.c.set(this.m_sweep.c0);
        this.m_jointList = null;
        this.m_contactList = null;
        this.m_prev = null;
        this.m_next = null;
        this.m_linearVelocity.set(bd.linearVelocity);
        this.m_angularVelocity = bd.angularVelocity;
        this.m_linearDamping = bd.linearDamping;
        this.m_angularDamping = bd.angularDamping;
        this.m_force.setZero();
        this.m_torque = 0.0f;
        this.m_sleepTime = 0.0f;
        this.m_type = bd.type;
        if (this.m_type == BodyType.DYNAMIC) {
            this.m_mass = 1.0f;
            this.m_invMass = 1.0f;
        } else {
            this.m_mass = 0.0f;
            this.m_invMass = 0.0f;
        }
        this.m_I = 0.0f;
        this.m_invI = 0.0f;
        this.m_userData = bd.userData;
        this.m_fixtureList = null;
        this.m_fixtureCount = 0;
    }

    public final Fixture createFixture(FixtureDef def) {
        assert (!this.m_world.isLocked());
        if (this.m_world.isLocked()) {
            return null;
        }
        Fixture fixture = new Fixture();
        fixture.create(this, def);
        if ((this.m_flags & 0x20) == 32) {
            BroadPhase broadPhase = this.m_world.m_contactManager.m_broadPhase;
            fixture.createProxy(broadPhase, this.m_xf);
        }
        fixture.m_next = this.m_fixtureList;
        this.m_fixtureList = fixture;
        ++this.m_fixtureCount;
        fixture.m_body = this;
        if (fixture.m_density > 0.0f) {
            this.resetMassData();
        }
        this.m_world.m_flags |= 1;
        return fixture;
    }

    public final Fixture createFixture(Shape shape, float density) {
        this.fixDef.shape = shape;
        this.fixDef.density = density;
        return this.createFixture(this.fixDef);
    }

    public final void destroyFixture(Fixture fixture) {
        assert (!this.m_world.isLocked());
        if (this.m_world.isLocked()) {
            return;
        }
        assert (fixture.m_body == this);
        assert (this.m_fixtureCount > 0);
        Fixture node = this.m_fixtureList;
        Fixture last = null;
        boolean found = false;
        while (node != null) {
            if (node == fixture) {
                node = fixture.m_next;
                found = true;
                break;
            }
            last = node;
            node = node.m_next;
        }
        assert (found);
        if (last == null) {
            this.m_fixtureList = fixture.m_next;
        } else {
            last.m_next = fixture.m_next;
        }
        ContactEdge edge = this.m_contactList;
        while (edge != null) {
            Contact c = edge.contact;
            edge = edge.next;
            Fixture fixtureA = c.getFixtureA();
            Fixture fixtureB = c.getFixtureB();
            if (fixture != fixtureA && fixture != fixtureB) continue;
            this.m_world.m_contactManager.destroy(c);
        }
        if ((this.m_flags & 0x20) == 32) {
            assert (fixture.m_proxy != null);
            BroadPhase broadPhase = this.m_world.m_contactManager.m_broadPhase;
            fixture.destroyProxy(broadPhase);
        } else assert (fixture.m_proxy == null);
        fixture.destroy();
        fixture.m_body = null;
        fixture.m_next = null;
        fixture = null;
        --this.m_fixtureCount;
        this.resetMassData();
    }

    public final void setTransform(Vec2 position, float angle) {
        assert (!this.m_world.isLocked());
        if (this.m_world.isLocked()) {
            return;
        }
        this.m_xf.R.set(angle);
        this.m_xf.position.set(position);
        Transform.mulToOut(this.m_xf, this.m_sweep.localCenter, this.m_sweep.c0);
        this.m_sweep.c.set(this.m_sweep.c0);
        this.m_sweep.a0 = this.m_sweep.a = angle;
        BroadPhase broadPhase = this.m_world.m_contactManager.m_broadPhase;
        Fixture f = this.m_fixtureList;
        while (f != null) {
            f.synchronize(broadPhase, this.m_xf, this.m_xf);
            f = f.m_next;
        }
        this.m_world.m_contactManager.findNewContacts();
    }

    public final Transform getTransform() {
        return this.m_xf;
    }

    public final Vec2 getPosition() {
        return this.m_xf.position;
    }

    public final float getAngle() {
        return this.m_sweep.a;
    }

    public final Vec2 getWorldCenter() {
        return this.m_sweep.c;
    }

    public final Vec2 getLocalCenter() {
        return this.m_sweep.localCenter;
    }

    public final void setLinearVelocity(Vec2 v) {
        if (this.m_type == BodyType.STATIC) {
            return;
        }
        if (Vec2.dot(v, v) > 0.0f) {
            this.setAwake(true);
        }
        this.m_linearVelocity.set(v);
    }

    public final Vec2 getLinearVelocity() {
        return this.m_linearVelocity;
    }

    public final void setAngularVelocity(float w) {
        if (this.m_type == BodyType.STATIC) {
            return;
        }
        if (w * w > 0.0f) {
            this.setAwake(true);
        }
        this.m_angularVelocity = w;
    }

    public final float getAngularVelocity() {
        return this.m_angularVelocity;
    }

    public final void applyForce(Vec2 force, Vec2 point) {
        if (this.m_type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        this.m_force.x += force.x;
        this.m_force.y += force.y;
        this.m_torque += (point.x - this.m_sweep.c.x) * force.y - (point.y - this.m_sweep.c.y) * force.x;
    }

    public final void applyTorque(float torque) {
        if (this.m_type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        this.m_torque += torque;
    }

    public final void applyLinearImpulse(Vec2 impulse, Vec2 point) {
        if (this.m_type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        this.m_linearVelocity.x += impulse.x * this.m_invMass;
        this.m_linearVelocity.y += impulse.y * this.m_invMass;
        this.m_angularVelocity += this.m_invI * ((point.x - this.m_sweep.c.x) * impulse.y - (point.y - this.m_sweep.c.y) * impulse.x);
    }

    public void applyAngularImpulse(float impulse) {
        if (this.m_type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        this.m_angularVelocity += this.m_invI * impulse;
    }

    public final float getMass() {
        return this.m_mass;
    }

    public final float getInertia() {
        return this.m_I + this.m_mass * (this.m_sweep.localCenter.x * this.m_sweep.localCenter.x + this.m_sweep.localCenter.y * this.m_sweep.localCenter.y);
    }

    public final void getMassData(MassData data) {
        data.mass = this.m_mass;
        data.I = this.m_I + this.m_mass * (this.m_sweep.localCenter.x * this.m_sweep.localCenter.x + this.m_sweep.localCenter.y * this.m_sweep.localCenter.y);
        data.center.x = this.m_sweep.localCenter.x;
        data.center.y = this.m_sweep.localCenter.y;
    }

    public final void setMassData(MassData massData) {
        assert (!this.m_world.isLocked());
        if (this.m_world.isLocked()) {
            return;
        }
        if (this.m_type != BodyType.DYNAMIC) {
            return;
        }
        this.m_invMass = 0.0f;
        this.m_I = 0.0f;
        this.m_invI = 0.0f;
        this.m_mass = massData.mass;
        if (this.m_mass <= 0.0f) {
            this.m_mass = 1.0f;
        }
        this.m_invMass = 1.0f / this.m_mass;
        if (massData.I > 0.0f && (this.m_flags & 0x10) == 0) {
            this.m_I = massData.I - this.m_mass * Vec2.dot(massData.center, massData.center);
            assert (this.m_I > 0.0f);
            this.m_invI = 1.0f / this.m_I;
        }
        Vec2 oldCenter = this.m_world.getPool().popVec2();
        oldCenter.set(this.m_sweep.c);
        this.m_sweep.localCenter.set(massData.center);
        Transform.mulToOut(this.m_xf, this.m_sweep.localCenter, this.m_sweep.c0);
        this.m_sweep.c.set(this.m_sweep.c0);
        Vec2 temp = this.m_world.getPool().popVec2();
        temp.set(this.m_sweep.c).subLocal(oldCenter);
        Vec2.crossToOut(this.m_angularVelocity, temp, temp);
        this.m_linearVelocity.addLocal(temp);
        this.m_world.getPool().pushVec2(2);
    }

    public final void resetMassData() {
        this.m_mass = 0.0f;
        this.m_invMass = 0.0f;
        this.m_I = 0.0f;
        this.m_invI = 0.0f;
        this.m_sweep.localCenter.setZero();
        if (this.m_type == BodyType.STATIC || this.m_type == BodyType.KINEMATIC) {
            this.m_sweep.c.set(this.m_xf.position);
            this.m_sweep.c0.set(this.m_xf.position);
            return;
        }
        assert (this.m_type == BodyType.DYNAMIC);
        Vec2 center = this.m_world.getPool().popVec2();
        center.setZero();
        Vec2 temp = this.m_world.getPool().popVec2();
        MassData massData = this.pmd;
        Fixture f = this.m_fixtureList;
        while (f != null) {
            if (f.m_density != 0.0f) {
                f.getMassData(massData);
                this.m_mass += massData.mass;
                temp.set(massData.center).mulLocal(massData.mass);
                center.addLocal(temp);
                this.m_I += massData.I;
            }
            f = f.m_next;
        }
        if (this.m_mass > 0.0f) {
            this.m_invMass = 1.0f / this.m_mass;
            center.mulLocal(this.m_invMass);
        } else {
            this.m_mass = 1.0f;
            this.m_invMass = 1.0f;
        }
        if (this.m_I > 0.0f && (this.m_flags & 0x10) == 0) {
            this.m_I -= this.m_mass * Vec2.dot(center, center);
            assert (this.m_I > 0.0f);
            this.m_invI = 1.0f / this.m_I;
        } else {
            this.m_I = 0.0f;
            this.m_invI = 0.0f;
        }
        Vec2 oldCenter = this.m_world.getPool().popVec2();
        oldCenter.set(this.m_sweep.c);
        this.m_sweep.localCenter.set(center);
        Transform.mulToOut(this.m_xf, this.m_sweep.localCenter, this.m_sweep.c0);
        this.m_sweep.c.set(this.m_sweep.c0);
        temp.set(this.m_sweep.c).subLocal(oldCenter);
        Vec2.crossToOut(this.m_angularVelocity, temp, temp);
        this.m_linearVelocity.addLocal(temp);
        this.m_world.getPool().pushVec2(3);
    }

    public final Vec2 getWorldPoint(Vec2 localPoint) {
        Vec2 v = new Vec2();
        this.getWorldPointToOut(localPoint, v);
        return v;
    }

    public final void getWorldPointToOut(Vec2 localPoint, Vec2 out) {
        Transform.mulToOut(this.m_xf, localPoint, out);
    }

    public final Vec2 getWorldVector(Vec2 localVector) {
        Vec2 out = new Vec2();
        this.getWorldVectorToOut(localVector, out);
        return out;
    }

    public final void getWorldVectorToOut(Vec2 localVector, Vec2 out) {
        Mat22.mulToOut(this.m_xf.R, localVector, out);
    }

    public final Vec2 getLocalPoint(Vec2 worldPoint) {
        Vec2 out = new Vec2();
        this.getLocalPointToOut(worldPoint, out);
        return out;
    }

    public final void getLocalPointToOut(Vec2 worldPoint, Vec2 out) {
        Transform.mulTransToOut(this.m_xf, worldPoint, out);
    }

    public final Vec2 getLocalVector(Vec2 worldVector) {
        Vec2 out = new Vec2();
        this.getLocalVectorToOut(worldVector, out);
        return out;
    }

    public final void getLocalVectorToOut(Vec2 worldVector, Vec2 out) {
        Mat22.mulTransToOut(this.m_xf.R, worldVector, out);
    }

    public final Vec2 getLinearVelocityFromWorldPoint(Vec2 worldPoint) {
        Vec2 out = new Vec2();
        this.getLinearVelocityFromWorldPointToOut(worldPoint, out);
        return out;
    }

    public final void getLinearVelocityFromWorldPointToOut(Vec2 worldPoint, Vec2 out) {
        out.set(worldPoint).subLocal(this.m_sweep.c);
        Vec2.crossToOut(this.m_angularVelocity, out, out);
        out.addLocal(this.m_linearVelocity);
    }

    public final Vec2 getLinearVelocityFromLocalPoint(Vec2 localPoint) {
        Vec2 out = new Vec2();
        this.getLinearVelocityFromLocalPointToOut(localPoint, out);
        return out;
    }

    public final void getLinearVelocityFromLocalPointToOut(Vec2 localPoint, Vec2 out) {
        this.getWorldPointToOut(localPoint, out);
        this.getLinearVelocityFromWorldPointToOut(out, out);
    }

    public final float getLinearDamping() {
        return this.m_linearDamping;
    }

    public final void setLinearDamping(float linearDamping) {
        this.m_linearDamping = linearDamping;
    }

    public final float getAngularDamping() {
        return this.m_angularDamping;
    }

    public final void setAngularDamping(float angularDamping) {
        this.m_angularDamping = angularDamping;
    }

    public BodyType getType() {
        return this.m_type;
    }

    public void setType(BodyType type) {
        if (this.m_type == type) {
            return;
        }
        this.m_type = type;
        this.resetMassData();
        if (this.m_type == BodyType.STATIC) {
            this.m_linearVelocity.setZero();
            this.m_angularVelocity = 0.0f;
        }
        this.setAwake(true);
        this.m_force.setZero();
        this.m_torque = 0.0f;
        ContactEdge ce = this.m_contactList;
        while (ce != null) {
            ce.contact.flagForFiltering();
            ce = ce.next;
        }
    }

    public final boolean isBullet() {
        return (this.m_flags & 8) == 8;
    }

    public final void setBullet(boolean flag) {
        this.m_flags = flag ? (this.m_flags |= 8) : (this.m_flags &= 0xFFFFFFF7);
    }

    public void setSleepingAllowed(boolean flag) {
        if (flag) {
            this.m_flags |= 4;
        } else {
            this.m_flags &= 0xFFFFFFFB;
            this.setAwake(true);
        }
    }

    public boolean isSleepingAllowed() {
        return (this.m_flags & 4) == 4;
    }

    public void setAwake(boolean flag) {
        if (flag) {
            if ((this.m_flags & 2) == 0) {
                this.m_flags |= 2;
                this.m_sleepTime = 0.0f;
            }
        } else {
            this.m_flags &= 0xFFFFFFFD;
            this.m_sleepTime = 0.0f;
            this.m_linearVelocity.setZero();
            this.m_angularVelocity = 0.0f;
            this.m_force.setZero();
            this.m_torque = 0.0f;
        }
    }

    public boolean isAwake() {
        return (this.m_flags & 2) == 2;
    }

    public void setActive(boolean flag) {
        if (flag == this.isActive()) {
            return;
        }
        if (flag) {
            this.m_flags |= 0x20;
            BroadPhase broadPhase = this.m_world.m_contactManager.m_broadPhase;
            Fixture f = this.m_fixtureList;
            while (f != null) {
                f.createProxy(broadPhase, this.m_xf);
                f = f.m_next;
            }
        } else {
            this.m_flags &= 0xFFFFFFDF;
            BroadPhase broadPhase = this.m_world.m_contactManager.m_broadPhase;
            Fixture f = this.m_fixtureList;
            while (f != null) {
                f.destroyProxy(broadPhase);
                f = f.m_next;
            }
            ContactEdge ce = this.m_contactList;
            while (ce != null) {
                ContactEdge ce0 = ce;
                ce = ce.next;
                this.m_world.m_contactManager.destroy(ce0.contact);
            }
            this.m_contactList = null;
        }
    }

    public boolean isActive() {
        return (this.m_flags & 0x20) == 32;
    }

    public void setFixedRotation(boolean flag) {
        this.m_flags = flag ? (this.m_flags |= 0x10) : (this.m_flags &= 0xFFFFFFEF);
        this.resetMassData();
    }

    public boolean isFixedRotation() {
        return (this.m_flags & 0x10) == 16;
    }

    public final Fixture getFixtureList() {
        return this.m_fixtureList;
    }

    public final JointEdge getJointList() {
        return this.m_jointList;
    }

    public final ContactEdge getContactList() {
        return this.m_contactList;
    }

    public final Body getNext() {
        return this.m_next;
    }

    public final Object getUserData() {
        return this.m_userData;
    }

    public final void setUserData(Object data) {
        this.m_userData = data;
    }

    public final World getWorld() {
        return this.m_world;
    }

    protected final void synchronizeFixtures() {
        Transform xf1 = this.pxf;
        float angle = this.m_sweep.a0;
        float c = MathUtils.cos(angle);
        float s = MathUtils.sin(angle);
        xf1.R.col1.x = c;
        xf1.R.col2.x = -s;
        xf1.R.col1.y = s;
        xf1.R.col2.y = c;
        Mat22 R = xf1.R;
        Vec2 v1 = this.m_sweep.localCenter;
        Vec2 v = this.m_sweep.c0;
        xf1.position.x = v.x - R.col1.x * v1.x - R.col2.x * v1.y;
        xf1.position.y = v.y - R.col1.y * v1.x - R.col2.y * v1.y;
        BroadPhase broadPhase = this.m_world.m_contactManager.m_broadPhase;
        Fixture f = this.m_fixtureList;
        while (f != null) {
            f.synchronize(broadPhase, xf1, this.m_xf);
            f = f.m_next;
        }
    }

    public final void synchronizeTransform() {
        float c = MathUtils.cos(this.m_sweep.a);
        float s = MathUtils.sin(this.m_sweep.a);
        this.m_xf.R.col1.x = c;
        this.m_xf.R.col2.x = -s;
        this.m_xf.R.col1.y = s;
        this.m_xf.R.col2.y = c;
        Vec2 localCenter = this.m_sweep.localCenter;
        this.m_xf.position.x = this.m_sweep.c.x - this.m_xf.R.col1.x * localCenter.x - this.m_xf.R.col2.x * localCenter.y;
        this.m_xf.position.y = this.m_sweep.c.y - this.m_xf.R.col1.y * localCenter.x - this.m_xf.R.col2.y * localCenter.y;
    }

    public boolean shouldCollide(Body other) {
        if (this.m_type != BodyType.DYNAMIC && other.m_type != BodyType.DYNAMIC) {
            return false;
        }
        JointEdge jn = this.m_jointList;
        while (jn != null) {
            if (jn.other == other && !jn.joint.m_collideConnected) {
                return false;
            }
            jn = jn.next;
        }
        return true;
    }

    protected final void advance(float t) {
        this.m_sweep.advance(t);
        this.m_sweep.c.set(this.m_sweep.c0);
        this.m_sweep.a = this.m_sweep.a0;
        this.synchronizeTransform();
    }
}

