/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.PulleyJointDef;
import org.jbox2d.pooling.IWorldPool;

public class PulleyJoint
extends Joint {
    public static final float MIN_PULLEY_LENGTH = 2.0f;
    public final Vec2 m_groundAnchor1 = new Vec2();
    public final Vec2 m_groundAnchor2 = new Vec2();
    public final Vec2 m_localAnchor1 = new Vec2();
    public final Vec2 m_localAnchor2 = new Vec2();
    private final Vec2 m_u1 = new Vec2();
    private final Vec2 m_u2 = new Vec2();
    private float m_constant;
    private float m_ratio;
    private float m_maxLength1;
    private float m_maxLength2;
    private float m_pulleyMass;
    private float m_limitMass1;
    private float m_limitMass2;
    private float m_impulse;
    private float m_limitImpulse1;
    private float m_limitImpulse2;
    private LimitState m_state;
    private LimitState m_limitState1;
    private LimitState m_limitState2;
    private float origLength1;
    private float origLength2;

    public PulleyJoint(IWorldPool argWorldPool, PulleyJointDef def) {
        super(argWorldPool, def);
        this.m_groundAnchor1.set(def.groundAnchorA);
        this.m_groundAnchor2.set(def.groundAnchorB);
        this.m_localAnchor1.set(def.localAnchorA);
        this.m_localAnchor2.set(def.localAnchorB);
        assert (def.ratio != 0.0f);
        this.m_ratio = def.ratio;
        this.origLength1 = def.lengthA;
        this.origLength2 = def.lengthB;
        this.m_constant = def.lengthA + this.m_ratio * def.lengthB;
        this.m_maxLength1 = MathUtils.min(def.maxLengthA, this.m_constant - this.m_ratio * 2.0f);
        this.m_maxLength2 = MathUtils.min(def.maxLengthB, (this.m_constant - 2.0f) / this.m_ratio);
        this.m_impulse = 0.0f;
        this.m_limitImpulse1 = 0.0f;
        this.m_limitImpulse2 = 0.0f;
    }

    public float getOrigLength1() {
        return this.origLength1;
    }

    public float getOrigLength2() {
        return this.origLength2;
    }

    public float getMaxLength1() {
        return this.m_maxLength1;
    }

    public float getMaxLength2() {
        return this.m_maxLength2;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchor1, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchor2, argOut);
    }

    @Override
    public void getReactionForce(float inv_dt, Vec2 argOut) {
        argOut.set(this.m_u2).mulLocal(this.m_impulse).mulLocal(inv_dt);
    }

    @Override
    public float getReactionTorque(float inv_dt) {
        return 0.0f;
    }

    public Vec2 getGroundAnchorA() {
        return this.m_groundAnchor1;
    }

    public Vec2 getGroundAnchorB() {
        return this.m_groundAnchor2;
    }

    public float getLength1() {
        Vec2 p = this.pool.popVec2();
        this.m_bodyA.getWorldPointToOut(this.m_localAnchor1, p);
        p.subLocal(this.m_groundAnchor1);
        float len = p.length();
        this.pool.pushVec2(1);
        return len;
    }

    public float getLength2() {
        Vec2 p = this.pool.popVec2();
        this.m_bodyB.getWorldPointToOut(this.m_localAnchor2, p);
        p.subLocal(this.m_groundAnchor2);
        float len = p.length();
        this.pool.pushVec2(1);
        return len;
    }

    public float getRatio() {
        return this.m_ratio;
    }

    @Override
    public void initVelocityConstraints(TimeStep step) {
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        Vec2 r1 = this.pool.popVec2();
        Vec2 r2 = this.pool.popVec2();
        Vec2 p1 = this.pool.popVec2();
        Vec2 p2 = this.pool.popVec2();
        Vec2 s1 = this.pool.popVec2();
        Vec2 s2 = this.pool.popVec2();
        r1.set(this.m_localAnchor1).subLocal(b1.getLocalCenter());
        r2.set(this.m_localAnchor2).subLocal(b2.getLocalCenter());
        Mat22.mulToOut(b1.getTransform().R, r1, r1);
        Mat22.mulToOut(b2.getTransform().R, r2, r2);
        p1.set(b1.m_sweep.c).addLocal(r1);
        p2.set(b2.m_sweep.c).addLocal(r2);
        s1.set(this.m_groundAnchor1);
        s2.set(this.m_groundAnchor2);
        this.m_u1.set(p1).subLocal(s1);
        this.m_u2.set(p2).subLocal(s2);
        float length1 = this.m_u1.length();
        float length2 = this.m_u2.length();
        if (length1 > Settings.linearSlop) {
            this.m_u1.mulLocal(1.0f / length1);
        } else {
            this.m_u1.setZero();
        }
        if (length2 > Settings.linearSlop) {
            this.m_u2.mulLocal(1.0f / length2);
        } else {
            this.m_u2.setZero();
        }
        float C = this.m_constant - length1 - this.m_ratio * length2;
        if (C > 0.0f) {
            this.m_state = LimitState.INACTIVE;
            this.m_impulse = 0.0f;
        } else {
            this.m_state = LimitState.AT_UPPER;
        }
        if (length1 < this.m_maxLength1) {
            this.m_limitState1 = LimitState.INACTIVE;
            this.m_limitImpulse1 = 0.0f;
        } else {
            this.m_limitState1 = LimitState.AT_UPPER;
        }
        if (length2 < this.m_maxLength2) {
            this.m_limitState2 = LimitState.INACTIVE;
            this.m_limitImpulse2 = 0.0f;
        } else {
            this.m_limitState2 = LimitState.AT_UPPER;
        }
        float cr1u1 = Vec2.cross(r1, this.m_u1);
        float cr2u2 = Vec2.cross(r2, this.m_u2);
        this.m_limitMass1 = b1.m_invMass + b1.m_invI * cr1u1 * cr1u1;
        this.m_limitMass2 = b2.m_invMass + b2.m_invI * cr2u2 * cr2u2;
        this.m_pulleyMass = this.m_limitMass1 + this.m_ratio * this.m_ratio * this.m_limitMass2;
        assert (this.m_limitMass1 > 1.1920929E-7f);
        assert (this.m_limitMass2 > 1.1920929E-7f);
        assert (this.m_pulleyMass > 1.1920929E-7f);
        this.m_limitMass1 = 1.0f / this.m_limitMass1;
        this.m_limitMass2 = 1.0f / this.m_limitMass2;
        this.m_pulleyMass = 1.0f / this.m_pulleyMass;
        if (step.warmStarting) {
            this.m_impulse *= step.dtRatio;
            this.m_limitImpulse1 *= step.dtRatio;
            this.m_limitImpulse2 *= step.dtRatio;
            Vec2 P1 = this.pool.popVec2();
            Vec2 P2 = this.pool.popVec2();
            Vec2 temp = this.pool.popVec2();
            P1.set(this.m_u1).mulLocal(-(this.m_impulse + this.m_limitImpulse1));
            P2.set(this.m_u2).mulLocal(-this.m_ratio * this.m_impulse - this.m_limitImpulse2);
            temp.set(P1).mulLocal(b1.m_invMass);
            b1.m_linearVelocity.addLocal(temp);
            b1.m_angularVelocity += b1.m_invI * Vec2.cross(r1, P1);
            temp.set(P2).mulLocal(b2.m_invMass);
            b2.m_linearVelocity.addLocal(temp);
            b2.m_angularVelocity += b2.m_invI * Vec2.cross(r2, P2);
            this.pool.pushVec2(3);
        } else {
            this.m_impulse = 0.0f;
            this.m_limitImpulse1 = 0.0f;
            this.m_limitImpulse2 = 0.0f;
        }
        this.pool.pushVec2(6);
    }

    @Override
    public void solveVelocityConstraints(TimeStep step) {
        Vec2 temp;
        float oldImpulse;
        float impulse;
        Vec2 v1;
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        Vec2 r1 = this.pool.popVec2();
        Vec2 r2 = this.pool.popVec2();
        r1.set(this.m_localAnchor1).subLocal(b1.getLocalCenter());
        r2.set(this.m_localAnchor2).subLocal(b2.getLocalCenter());
        Mat22.mulToOut(b1.getTransform().R, r1, r1);
        Mat22.mulToOut(b2.getTransform().R, r2, r2);
        if (this.m_state == LimitState.AT_UPPER) {
            v1 = this.pool.popVec2();
            Vec2 v2 = this.pool.popVec2();
            Vec2.crossToOut(b1.m_angularVelocity, r1, v1);
            Vec2.crossToOut(b2.m_angularVelocity, r2, v2);
            v1.addLocal(b1.m_linearVelocity);
            v2.addLocal(b2.m_linearVelocity);
            float Cdot = -Vec2.dot(this.m_u1, v1) - this.m_ratio * Vec2.dot(this.m_u2, v2);
            float impulse2 = this.m_pulleyMass * -Cdot;
            float oldImpulse2 = this.m_impulse;
            this.m_impulse = MathUtils.max(0.0f, this.m_impulse + impulse2);
            impulse2 = this.m_impulse - oldImpulse2;
            Vec2 P1 = this.pool.popVec2();
            Vec2 P2 = this.pool.popVec2();
            Vec2 temp2 = this.pool.popVec2();
            P1.set(this.m_u1).mulLocal(-impulse2);
            P2.set(this.m_u2).mulLocal(-this.m_ratio * impulse2);
            temp2.set(P1).mulLocal(b1.m_invMass);
            b1.m_linearVelocity.addLocal(temp2);
            b1.m_angularVelocity += b1.m_invI * Vec2.cross(r1, P1);
            temp2.set(P2).mulLocal(b2.m_invMass);
            b2.m_linearVelocity.addLocal(temp2);
            b2.m_angularVelocity += b2.m_invI * Vec2.cross(r2, P2);
            this.pool.pushVec2(5);
        }
        if (this.m_limitState1 == LimitState.AT_UPPER) {
            v1 = this.pool.popVec2();
            Vec2.crossToOut(b1.m_angularVelocity, r1, v1);
            v1.addLocal(b1.m_linearVelocity);
            float Cdot = -Vec2.dot(this.m_u1, v1);
            impulse = -this.m_limitMass1 * Cdot;
            oldImpulse = this.m_limitImpulse1;
            this.m_limitImpulse1 = MathUtils.max(0.0f, this.m_limitImpulse1 + impulse);
            impulse = this.m_limitImpulse1 - oldImpulse;
            Vec2 P1 = this.pool.popVec2();
            temp = this.pool.popVec2();
            P1.set(this.m_u1).mulLocal(-impulse);
            temp.set(P1).mulLocal(b1.m_invMass);
            b1.m_linearVelocity.addLocal(temp);
            b1.m_angularVelocity += b1.m_invI * Vec2.cross(r1, P1);
            this.pool.pushVec2(3);
        }
        if (this.m_limitState2 == LimitState.AT_UPPER) {
            Vec2 v2 = this.pool.popVec2();
            Vec2.crossToOut(b2.m_angularVelocity, r2, v2);
            v2.addLocal(b2.m_linearVelocity);
            float Cdot = -Vec2.dot(this.m_u2, v2);
            impulse = -this.m_limitMass2 * Cdot;
            oldImpulse = this.m_limitImpulse2;
            this.m_limitImpulse2 = MathUtils.max(0.0f, this.m_limitImpulse2 + impulse);
            impulse = this.m_limitImpulse2 - oldImpulse;
            Vec2 P2 = this.pool.popVec2();
            temp = this.pool.popVec2();
            P2.set(this.m_u2).mulLocal(-impulse);
            temp.set(P2).mulLocal(b2.m_invMass);
            b2.m_linearVelocity.addLocal(temp);
            b2.m_angularVelocity += b2.m_invI * Vec2.cross(r2, P2);
            this.pool.pushVec2(3);
        }
        this.pool.pushVec2(2);
    }

    @Override
    public boolean solvePositionConstraints(float baumgarte) {
        float impulse;
        Vec2 r1;
        Body b1 = this.m_bodyA;
        Body b2 = this.m_bodyB;
        Vec2 s1 = this.pool.popVec2();
        Vec2 s2 = this.pool.popVec2();
        s1.set(this.m_groundAnchor1);
        s2.set(this.m_groundAnchor2);
        float linearError = 0.0f;
        if (this.m_state == LimitState.AT_UPPER) {
            r1 = this.pool.popVec2();
            Vec2 r2 = this.pool.popVec2();
            Vec2 p1 = this.pool.popVec2();
            Vec2 p2 = this.pool.popVec2();
            r1.set(this.m_localAnchor1).subLocal(b1.getLocalCenter());
            r2.set(this.m_localAnchor2).subLocal(b2.getLocalCenter());
            Mat22.mulToOut(b1.getTransform().R, r1, r1);
            Mat22.mulToOut(b2.getTransform().R, r2, r2);
            p1.set(b1.m_sweep.c).addLocal(r1);
            p2.set(b2.m_sweep.c).addLocal(r2);
            this.m_u1.set(p1).subLocal(s1);
            this.m_u2.set(p2).subLocal(s2);
            float length1 = this.m_u1.length();
            float length2 = this.m_u2.length();
            if (length1 > Settings.linearSlop) {
                this.m_u1.mulLocal(1.0f / length1);
            } else {
                this.m_u1.setZero();
            }
            if (length2 > Settings.linearSlop) {
                this.m_u2.mulLocal(1.0f / length2);
            } else {
                this.m_u2.setZero();
            }
            float C = this.m_constant - length1 - this.m_ratio * length2;
            linearError = MathUtils.max(linearError, -C);
            C = MathUtils.clamp(C + Settings.linearSlop, -Settings.maxLinearCorrection, 0.0f);
            float impulse2 = -this.m_pulleyMass * C;
            Vec2 P1 = this.pool.popVec2();
            Vec2 P2 = this.pool.popVec2();
            Vec2 temp = this.pool.popVec2();
            P1.set(this.m_u1).mulLocal(-impulse2);
            P2.set(this.m_u2).mulLocal(-this.m_ratio * impulse2);
            temp.set(P1).mulLocal(b1.m_invMass);
            b1.m_sweep.c.addLocal(temp);
            b1.m_sweep.a += b1.m_invI * Vec2.cross(r1, P1);
            temp.set(P2).mulLocal(b2.m_invMass);
            b2.m_sweep.c.addLocal(temp);
            b2.m_sweep.a += b2.m_invI * Vec2.cross(r2, P2);
            b1.synchronizeTransform();
            b2.synchronizeTransform();
            this.pool.pushVec2(7);
        }
        if (this.m_limitState1 == LimitState.AT_UPPER) {
            r1 = this.pool.popVec2();
            Vec2 p1 = this.pool.popVec2();
            r1.set(this.m_localAnchor1).subLocal(b1.getLocalCenter());
            Mat22.mulToOut(b1.getTransform().R, r1, r1);
            p1.set(b1.m_sweep.c).addLocal(r1);
            this.m_u1.set(p1).subLocal(s1);
            float length1 = this.m_u1.length();
            if (length1 > Settings.linearSlop) {
                this.m_u1.mulLocal(1.0f / length1);
            } else {
                this.m_u1.setZero();
            }
            float C = this.m_maxLength1 - length1;
            linearError = MathUtils.max(linearError, -C);
            C = MathUtils.clamp(C + Settings.linearSlop, -Settings.maxLinearCorrection, 0.0f);
            impulse = -this.m_limitMass1 * C;
            Vec2 P1 = this.pool.popVec2();
            Vec2 temp = this.pool.popVec2();
            P1.set(this.m_u1).mulLocal(-impulse);
            temp.set(P1).mulLocal(b1.m_invMass);
            b1.m_sweep.c.addLocal(temp);
            b1.m_sweep.a += b1.m_invI * Vec2.cross(r1, P1);
            b1.synchronizeTransform();
            this.pool.pushVec2(4);
        }
        if (this.m_limitState2 == LimitState.AT_UPPER) {
            Vec2 r2 = this.pool.popVec2();
            Vec2 p2 = this.pool.popVec2();
            r2.set(this.m_localAnchor2).subLocal(b2.getLocalCenter());
            Mat22.mulToOut(b2.getTransform().R, r2, r2);
            p2.set(b2.m_sweep.c).addLocal(r2);
            this.m_u2.set(p2).subLocal(s2);
            float length2 = this.m_u2.length();
            if (length2 > Settings.linearSlop) {
                this.m_u2.mulLocal(1.0f / length2);
            } else {
                this.m_u2.setZero();
            }
            float C = this.m_maxLength2 - length2;
            linearError = MathUtils.max(linearError, -C);
            C = MathUtils.clamp(C + Settings.linearSlop, -Settings.maxLinearCorrection, 0.0f);
            impulse = -this.m_limitMass2 * C;
            Vec2 P2 = this.pool.popVec2();
            Vec2 temp = this.pool.popVec2();
            P2.set(this.m_u2).mulLocal(-impulse);
            temp.set(P2).mulLocal(b2.m_invMass);
            b2.m_sweep.c.addLocal(temp);
            b2.m_sweep.a += b2.m_invI * Vec2.cross(r2, P2);
            b2.synchronizeTransform();
            this.pool.pushVec2(4);
        }
        this.pool.pushVec2(2);
        return linearError < Settings.linearSlop;
    }
}

