/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.io.Serializable;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;

public class Mat22
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Vec2 col1;
    public final Vec2 col2;

    public String toString() {
        String s = "";
        s = s + "[" + this.col1.x + "," + this.col2.x + "]\n";
        s = s + "[" + this.col1.y + "," + this.col2.y + "]";
        return s;
    }

    public Mat22() {
        this.col1 = new Vec2();
        this.col2 = new Vec2();
    }

    public Mat22(Vec2 c1, Vec2 c2) {
        this.col1 = c1.clone();
        this.col2 = c2.clone();
    }

    public Mat22(float col1x, float col2x, float col1y, float col2y) {
        this.col1 = new Vec2(col1x, col1y);
        this.col2 = new Vec2(col2x, col2y);
    }

    public final Mat22 set(Mat22 m) {
        this.col1.x = m.col1.x;
        this.col1.y = m.col1.y;
        this.col2.x = m.col2.x;
        this.col2.y = m.col2.y;
        return this;
    }

    public final Mat22 set(float col1x, float col2x, float col1y, float col2y) {
        this.col1.x = col1x;
        this.col1.y = col1y;
        this.col2.x = col2x;
        this.col2.y = col2y;
        return this;
    }

    public final Mat22 clone() {
        return new Mat22(this.col1, this.col2);
    }

    public final void set(float angle) {
        float c = MathUtils.cos(angle);
        float s = MathUtils.sin(angle);
        this.col1.x = c;
        this.col2.x = -s;
        this.col1.y = s;
        this.col2.y = c;
    }

    public final void setIdentity() {
        this.col1.x = 1.0f;
        this.col2.x = 0.0f;
        this.col1.y = 0.0f;
        this.col2.y = 1.0f;
    }

    public final void setZero() {
        this.col1.x = 0.0f;
        this.col2.x = 0.0f;
        this.col1.y = 0.0f;
        this.col2.y = 0.0f;
    }

    public final float getAngle() {
        return MathUtils.atan2(this.col1.y, this.col1.x);
    }

    public final void set(Vec2 c1, Vec2 c2) {
        this.col1.x = c1.x;
        this.col2.x = c2.x;
        this.col1.y = c1.y;
        this.col2.y = c2.y;
    }

    public final Mat22 invert() {
        float a = this.col1.x;
        float b = this.col2.x;
        float c = this.col1.y;
        float d = this.col2.y;
        Mat22 B = new Mat22();
        float det = a * d - b * c;
        if (det != 0.0f) {
            det = 1.0f / det;
        }
        B.col1.x = det * d;
        B.col2.x = -det * b;
        B.col1.y = -det * c;
        B.col2.y = det * a;
        return B;
    }

    public final Mat22 invertLocal() {
        float a = this.col1.x;
        float d = this.col2.y;
        float b = this.col2.x;
        float c = this.col1.y;
        float det = a * d - b * c;
        if (det != 0.0f) {
            det = 1.0f / det;
        }
        this.col1.x = det * d;
        this.col2.x = -det * b;
        this.col1.y = -det * c;
        this.col2.y = det * a;
        return this;
    }

    public final void invertToOut(Mat22 out) {
        float a = this.col1.x;
        float b = this.col2.x;
        float c = this.col1.y;
        float d = this.col2.y;
        float det = a * d - b * c;
        det = 1.0f / det;
        out.col1.x = det * d;
        out.col2.x = -det * b;
        out.col1.y = -det * c;
        out.col2.y = det * a;
    }

    public final Mat22 abs() {
        return new Mat22(MathUtils.abs(this.col1.x), MathUtils.abs(this.col2.x), MathUtils.abs(this.col1.y), MathUtils.abs(this.col2.y));
    }

    public final void absLocal() {
        this.col1.absLocal();
        this.col2.absLocal();
    }

    public static final Mat22 abs(Mat22 R) {
        return R.abs();
    }

    public static void absToOut(Mat22 R, Mat22 out) {
        out.col1.x = MathUtils.abs(R.col1.x);
        out.col1.y = MathUtils.abs(R.col1.y);
        out.col2.x = MathUtils.abs(R.col2.x);
        out.col2.y = MathUtils.abs(R.col2.y);
    }

    public final Vec2 mul(Vec2 v) {
        return new Vec2(this.col1.x * v.x + this.col2.x * v.y, this.col1.y * v.x + this.col2.y * v.y);
    }

    public final void mulToOut(Vec2 v, Vec2 out) {
        float tempy = this.col1.y * v.x + this.col2.y * v.y;
        out.x = this.col1.x * v.x + this.col2.x * v.y;
        out.y = tempy;
    }

    public final Mat22 mul(Mat22 R) {
        Mat22 C = new Mat22();
        C.col1.x = this.col1.x * R.col1.x + this.col2.x * R.col1.y;
        C.col1.y = this.col1.y * R.col1.x + this.col2.y * R.col1.y;
        C.col2.x = this.col1.x * R.col2.x + this.col2.x * R.col2.y;
        C.col2.y = this.col1.y * R.col2.x + this.col2.y * R.col2.y;
        return C;
    }

    public final Mat22 mulLocal(Mat22 R) {
        this.mulToOut(R, this);
        return this;
    }

    public final void mulToOut(Mat22 R, Mat22 out) {
        float tempx2;
        float tempx1;
        float tempy1 = this.col1.y * R.col1.x + this.col2.y * R.col1.y;
        out.col1.x = tempx1 = this.col1.x * R.col1.x + this.col2.x * R.col1.y;
        out.col1.y = tempy1;
        float tempy2 = this.col1.y * R.col2.x + this.col2.y * R.col2.y;
        out.col2.x = tempx2 = this.col1.x * R.col2.x + this.col2.x * R.col2.y;
        out.col2.y = tempy2;
    }

    public final Mat22 mulTrans(Mat22 B) {
        Mat22 C = new Mat22();
        C.col1.x = Vec2.dot(this.col1, B.col1);
        C.col1.y = Vec2.dot(this.col2, B.col1);
        C.col2.x = Vec2.dot(this.col1, B.col2);
        C.col2.y = Vec2.dot(this.col2, B.col2);
        return C;
    }

    public final Mat22 mulTransLocal(Mat22 B) {
        this.mulTransToOut(B, this);
        return this;
    }

    public final void mulTransToOut(Mat22 B, Mat22 out) {
        float x1 = this.col1.x * B.col1.x + this.col1.y * B.col1.y;
        float y1 = this.col2.x * B.col1.x + this.col2.y * B.col1.y;
        float x2 = this.col1.x * B.col2.x + this.col1.y * B.col2.y;
        float y2 = this.col2.x * B.col2.x + this.col2.y * B.col2.y;
        out.col1.x = x1;
        out.col2.x = x2;
        out.col1.y = y1;
        out.col2.y = y2;
    }

    public final Vec2 mulTrans(Vec2 v) {
        return new Vec2(v.x * this.col1.x + v.y * this.col1.y, v.x * this.col2.x + v.y * this.col2.y);
    }

    public final void mulTransToOut(Vec2 v, Vec2 out) {
        out.x = v.x * this.col1.x + v.y * this.col1.y;
        out.y = v.x * this.col2.x + v.y * this.col2.y;
    }

    public final Mat22 add(Mat22 B) {
        Mat22 m = new Mat22();
        m.col1.x = this.col1.x + B.col1.x;
        m.col1.y = this.col1.y + B.col1.y;
        m.col2.x = this.col2.x + B.col2.x;
        m.col2.y = this.col2.y + B.col2.y;
        return m;
    }

    public final Mat22 addLocal(Mat22 B) {
        this.col1.x += B.col1.x;
        this.col1.y += B.col1.y;
        this.col2.x += B.col2.x;
        this.col2.y += B.col2.y;
        return this;
    }

    public final Vec2 solve(Vec2 b) {
        float a11 = this.col1.x;
        float a22 = this.col2.y;
        float a12 = this.col2.x;
        float a21 = this.col1.y;
        float det = a11 * a22 - a12 * a21;
        if (det != 0.0f) {
            det = 1.0f / det;
        }
        Vec2 x = new Vec2(det * (a22 * b.x - a12 * b.y), det * (a11 * b.y - a21 * b.x));
        return x;
    }

    public final void solveToOut(Vec2 b, Vec2 out) {
        float a11 = this.col1.x;
        float a22 = this.col2.y;
        float a12 = this.col2.x;
        float a21 = this.col1.y;
        float det = a11 * a22 - a12 * a21;
        if (det != 0.0f) {
            det = 1.0f / det;
        }
        float tempy = det * (a11 * b.y - a21 * b.x);
        out.x = det * (a22 * b.x - a12 * b.y);
        out.y = tempy;
    }

    public static final Vec2 mul(Mat22 R, Vec2 v) {
        return new Vec2(R.col1.x * v.x + R.col2.x * v.y, R.col1.y * v.x + R.col2.y * v.y);
    }

    public static final void mulToOut(Mat22 R, Vec2 v, Vec2 out) {
        float tempy = R.col1.y * v.x + R.col2.y * v.y;
        out.x = R.col1.x * v.x + R.col2.x * v.y;
        out.y = tempy;
    }

    public static final Mat22 mul(Mat22 A, Mat22 B) {
        Mat22 C = new Mat22();
        C.col1.x = A.col1.x * B.col1.x + A.col2.x * B.col1.y;
        C.col1.y = A.col1.y * B.col1.x + A.col2.y * B.col1.y;
        C.col2.x = A.col1.x * B.col2.x + A.col2.x * B.col2.y;
        C.col2.y = A.col1.y * B.col2.x + A.col2.y * B.col2.y;
        return C;
    }

    public static final void mulToOut(Mat22 A, Mat22 B, Mat22 out) {
        float tempy1 = A.col1.y * B.col1.x + A.col2.y * B.col1.y;
        float tempx1 = A.col1.x * B.col1.x + A.col2.x * B.col1.y;
        float tempy2 = A.col1.y * B.col2.x + A.col2.y * B.col2.y;
        float tempx2 = A.col1.x * B.col2.x + A.col2.x * B.col2.y;
        out.col1.x = tempx1;
        out.col1.y = tempy1;
        out.col2.x = tempx2;
        out.col2.y = tempy2;
    }

    public static final Vec2 mulTrans(Mat22 R, Vec2 v) {
        return new Vec2(v.x * R.col1.x + v.y * R.col1.y, v.x * R.col2.x + v.y * R.col2.y);
    }

    public static final void mulTransToOut(Mat22 R, Vec2 v, Vec2 out) {
        float outx = v.x * R.col1.x + v.y * R.col1.y;
        out.y = v.x * R.col2.x + v.y * R.col2.y;
        out.x = outx;
    }

    public static final Mat22 mulTrans(Mat22 A, Mat22 B) {
        Mat22 C = new Mat22();
        C.col1.x = A.col1.x * B.col1.x + A.col1.y * B.col1.y;
        C.col1.y = A.col2.x * B.col1.x + A.col2.y * B.col1.y;
        C.col2.x = A.col1.x * B.col2.x + A.col1.y * B.col2.y;
        C.col2.y = A.col2.x * B.col2.x + A.col2.y * B.col2.y;
        return C;
    }

    public static final void mulTransToOut(Mat22 A, Mat22 B, Mat22 out) {
        float x1 = A.col1.x * B.col1.x + A.col1.y * B.col1.y;
        float y1 = A.col2.x * B.col1.x + A.col2.y * B.col1.y;
        float x2 = A.col1.x * B.col2.x + A.col1.y * B.col2.y;
        float y2 = A.col2.x * B.col2.x + A.col2.y * B.col2.y;
        out.col1.x = x1;
        out.col1.y = y1;
        out.col2.x = x2;
        out.col2.y = y2;
    }

    public static final Mat22 createRotationalTransform(float angle) {
        Mat22 mat = new Mat22();
        float c = MathUtils.cos(angle);
        float s = MathUtils.sin(angle);
        mat.col1.x = c;
        mat.col2.x = -s;
        mat.col1.y = s;
        mat.col2.y = c;
        return mat;
    }

    public static final void createRotationalTransform(float angle, Mat22 out) {
        float c = MathUtils.cos(angle);
        float s = MathUtils.sin(angle);
        out.col1.x = c;
        out.col2.x = -s;
        out.col1.y = s;
        out.col2.y = c;
    }

    public static final Mat22 createScaleTransform(float scale) {
        Mat22 mat = new Mat22();
        mat.col1.x = scale;
        mat.col2.y = scale;
        return mat;
    }

    public static final void createScaleTransform(float scale, Mat22 out) {
        out.col1.x = scale;
        out.col2.y = scale;
    }
}

