package circle;
import interfaces.IPrototype;
import interfaces.Brush;

public class Circle implements IPrototype
{
    public Circle()
    {
        this.centerX = 0;
        this.centerY = 0;
        this.radius = 10;
        this.brush = new Brush(1,1);
    }
    public Circle(double centerX, double centerY, double radius)
    {
        this.centerX = centerX;
        this.centerY = centerY;
        this.radius = radius;
    }
    public void setBrush(Brush brush)
    {
        this.brush = brush;
    }
    // Clone deep copy implementation
    public IPrototype clone()
    {
	System.out.println("Cloning a new circle (" + centerX + "," + centerY + "," + radius +")");
        Circle clone = new Circle(centerX, centerY, radius);
	clone.setBrush(new Brush(brush));
	return clone;
    }
    private double centerX;
    private double centerY;
    private double radius;
    private Brush brush;
}
