public class Mensagem{
    private int idSender;
    private ValorSensoriado[] valores; 

    
    public Mensagem(int id, double valorMedio, int totalFilhos){
        this(id);
        this.addValorSensoriado(new ValorSensoriado(valorMedio, totalFilhos));
    }  
    
    public Mensagem(int id){
        this.valores = new ValorSensoriado[0];
        this.setIdSender(id);
    }     
    
    public void setIdSender(int idSender){
        this.idSender = idSender;
    }    
    
    public void addValorSensoriado(ValorSensoriado valor){
       ValorSensoriado[] novo = new ValorSensoriado[this.valores.length + 1];
       
       for(int i = 0; i < this.valores.length; i++)
        novo[i] = this.valores[i];
       novo[novo.length - 1] = valor;
       this.valores = novo;
    }    
    
    public ValorSensoriado[] getValores(){
        return this.valores;
    }    
    
    public void add(ValorSensoriado[] valores){
        for(ValorSensoriado valor :  valores)
          this.addValorSensoriado(valor);
    }      
    
    public double media(){
       int qtde = 0;
       double temp = 0;
       for(ValorSensoriado valor :  this.valores){
           qtde += valor.getQtdeEstacoes();
           temp += valor.getTempTotal();
        }    
       return temp / qtde; 
    } 
    
    public double tempTotal(){
       double temp = 0;
       for(ValorSensoriado valor :  this.valores)
           temp += valor.getTempTotal();
       return temp; 
    }    
    
    public int qtdeEstacoes(){
       int qtde = 0;
       for(ValorSensoriado valor :  this.valores){
           qtde += valor.getQtdeEstacoes();
        }    
       return qtde; 
    }  
    
    public String toString(){
        String rep = "[" + idSender + "] - [";
        for(ValorSensoriado valor : this.valores)
          rep += valor + " ";
        return rep + "]";
    }    
    
    
    
    
}
