public class EstacaoColeta extends UnidadeSensora{
    private double[] mediaValores = new double[0];
    
    public EstacaoColeta(int id){
        super(id);
    }  
   
    public Mensagem processar(){
        int totalFilhos = 0;
        double sumMedida = 0; 
        double valorMedio = 0;
        
        for(UnidadeSensora unidadeSensora : filhos){
            Mensagem m = unidadeSensora.processar();
            System.out.println(m);
            totalFilhos += m.qtdeEstacoes();
            sumMedida += m.tempTotal();
        }    
        
        valorMedio = sumMedida / totalFilhos;
        this.addValorMedio(valorMedio);
        
        
        return new Mensagem(this.id, valorMedio, totalFilhos);
    };  
    
    public void addValorMedio(double valorMedio){
       double[] novo = new double[this.mediaValores.length + 1];
       
       for(int i = 0; i < this.mediaValores.length; i++)
        novo[i] = this.mediaValores[i];
       novo[novo.length - 1] = valorMedio;
       this.mediaValores = novo;        
    }    
    
}
