package br.edu.ifba.inf008.avaliacao.modelo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import br.edu.ifba008.avaliacao.excecao.AtividadeInexistenteException;

public class Projeto {
	private String nome;

	private List<Pessoa> responsaveis;
	private Map<Long, Atividade> atividades;

	
	public Projeto(String nome){
		this.setNome(nome);
		this.atividades = new HashMap<Long, Atividade>();
		this.responsaveis = new ArrayList<Pessoa>();		
	}
	
	
	public String getNome() {
		return nome;
	}
	
	public void setNome(String nome) {
		this.nome = nome;
	}
	
	
	public Collection<Atividade> getAtividades(){
		return this.atividades.values();
	}
	
	public Collection<Pessoa> getResponsaveis(){
		return this.responsaveis;
	}	
	
	public void addResponsavel(Pessoa responsavel){
		this.responsaveis.add(responsavel);
	}
	
	public void addAtividade(Atividade atividade){
		this.atividades.put(atividade.getId(), atividade);
	}	
	
	
	public boolean estaConcluido() {
		for(Atividade a : this.atividades.values())
			if(!a.estaConcluida())
				return false;
		return true;
	};	
	
	public long startAfter(long id) throws AtividadeInexistenteException{
		Atividade a = this.findById(id);
		return a.startAfter();
	}


	public Atividade findById(long id) throws AtividadeInexistenteException{
		Atividade atividade = this.atividades.get(id);
		if (atividade == null)
			throw new AtividadeInexistenteException(id);
		return atividade;
	}
	

}
