package br.edu.ifba.inf008.avaliacao.modelo;

public class Elementar extends Atividade{
	
	public static final Elementar INICIAL = new Elementar(0, "INICIAL", 0, true, false);
	public static final Elementar TERMINAL = new Elementar(Long.MAX_VALUE, "TERMINAL", 0, false, true);
	
	private long duracao;
	private boolean concluida;
	private Pessoa responsavel;


	private boolean inicial;
	private boolean terminal;
	
	
	public Elementar(long id,  String descricao, long duracao){
		super(id, descricao);
		this.setConcluida(false);
		this.setDuracao(duracao);
		this.setInicial(false);
		this.setTerminal(false);
	}
	
	private Elementar(long id,  String descricao, long duracao, boolean inicial, boolean terminal){
		super(id, descricao);
		this.setConcluida(false);
		this.setDuracao(duracao);
		this.setInicial(inicial);
		this.setTerminal(terminal);
		this.setConcluida(true);
	}	
	
	@Override
	public boolean estaConcluida() {
		return this.concluida;
	}

	public long getDuracao() {
		return duracao;
	}

	public void setDuracao(long duracao) {
		this.duracao = duracao;
	}

	public boolean isConcluida() {
		return concluida;
	}

	public void setConcluida(boolean concluida) {
		this.concluida = concluida;
	}
	
	public boolean isInicial() {
		return inicial;
	}

	private void setInicial(boolean inicial) {
		this.inicial = inicial;
	}

	public boolean isTerminal() {
		return terminal;
	}

	private void setTerminal(boolean terminal) {
		this.terminal = terminal;
	}
	


}
