package br.edu.ifba.inf008.avaliacao.modelo;

import br.edu.ifba.inf008.avaliacao.persistencia.PessoaMemDB;
import br.edu.ifba.inf008.avaliacao.persistencia.PessoaPersistenciaIF;

public class AtividadeApp implements AtividadeAppIF {
	
	private PessoaPersistenciaIF pessoaPersistencia;

	
	public AtividadeApp() {
		this.pessoaPersistencia = new PessoaMemDB();
	}
	
	@Override
	public void cadastrarPessoa(String mat, String nome) throws Exception {
		Pessoa p = new Pessoa(mat, nome);
		this.pessoaPersistencia.salvar(p);
	}

	@Override
	public String recuperarNomePessoa(String mat) throws Exception {
		Pessoa p = this.pessoaPersistencia.findByMatricula(mat);
		return p.getNome();
	}

}
