﻿create sequence seq_editora start 1;

create table editora(
	cod_editora int default nextval ('seq_editora'),
	descricao varchar(30) not null,
	endereco varchar (30) null
);
--Ponto e vírgula serve para separar os scripts
-- Alterando a estrutura da tabela primária criando a primary key - define cod_editora como chave primária
alter table editora  -- Usa um add por vez
	add constraint pk_editora
		primary key(cod_editora);

create sequence seq_autor start 1;

create table autor (
	cod_autor int primary key
		default nextval('seq_autor'),
	nome varchar(45) not null,
	sexo char(1) null,
	data_nascimento date not null
);

create sequence seq_livro start 1;
create table livro(
	cod_livro int default nextval ('seq_livro'),
	isbn varchar(20) not null,
	titulo varchar (45) not null,
	num_edicao int not null,
	preco float not null,
	cod_editora int not null,
--Regras constraints <
	constraint pk_livro -- Dando nome a regra
		primary key(cod_livro),

	constraint fk_livro_editora
		foreign key (cod_editora) --atributo cod_editora
			references editora(cod_editora) -- cod_editora vem da tabela editora
);

create table livro_autor(
	cod_livro int,
	cod_autor int,	

	constraint pk_livro_autor
		primary key (cod_livro, cod_autor),
	constraint fk_livro_autor_livro
		foreign key(cod_livro)
			references livro(cod_livro),
	constraint fk_livro_autor_autor
		foreign key (cod_autor)
			references autor (cod_autor)
	
);