package br.edu.ifba.inf008.avaliacao.modelo;

import br.edu.ifba008.avaliacao.excecao.AtividadeInexistenteException;

public class Projeto {
	private String nome;

	private Pessoa[] responsaveis;
	private Atividade[] atividades;

	
	public Projeto(String nome){
		this.setNome(nome);
		this.atividades = new Atividade[0];
		this.responsaveis = new Pessoa[0];		
	}
	
	
	public String getNome() {
		return nome;
	}
	
	public void setNome(String nome) {
		this.nome = nome;
	}
	
	
	public Atividade[] getAtividades(){
		return this.atividades;
	}
	
	public Pessoa[] getResponsaveis(){
		return this.responsaveis;
	}	
	
	public void addResponsavel(Pessoa responsavel){
		Pessoa[] novo = new Pessoa[this.responsaveis.length+1];
		for(int iCont = 0; iCont < this.responsaveis.length; iCont++)
			novo[iCont] = this.responsaveis[iCont];
		novo[novo.length - 1] = responsavel;
		this.responsaveis = novo;
	}
	
	public void addAtividade(Atividade atividade){
		Atividade[] novo = new Atividade[this.atividades.length+1];
		for(int iCont = 0; iCont < this.atividades.length; iCont++)
			novo[iCont] = this.atividades[iCont];
		novo[novo.length - 1] = atividade;
		this.atividades = novo;
	}	
	
	
	public boolean estaConcluido() {
		for(Atividade a : this.atividades)
			if(!a.estaConcluida())
				return false;
		return true;
	};	
	
	public long startAfter(long id) throws AtividadeInexistenteException{
		Atividade a = this.findById(id);
		return a.startAfter();
	}


	public Atividade findById(long id) throws AtividadeInexistenteException{
		for(Atividade atividade : this.atividades)
			if(atividade.getId() == id)
				return atividade;
		throw new AtividadeInexistenteException(id);
	}
	

}
