public class Macro extends Atividade{
	

	private Atividade[] internas;
	
	public Macro(long id, String descricao) {
		super(id, descricao);
		this.internas = new Atividade[0];
	}
	

	public long getDuracao(){
		Atividade[] finais = this.localizarFinais();
		long duracao = 0;
		for(Atividade a : finais){
			long toStart = a.startAfter() + a.getDuracao();
			if(duracao < toStart)
				duracao = toStart;
		}
			
		return duracao;
	}
	
	@Override
	public boolean estaConcluida() {
		for(Atividade a : this.internas)
			if(!a.estaConcluida())
				return false;
		return true;
	};
	
	private Atividade[] localizarFinais(){
		Atividade[] finais = new Atividade[0];
		for(Atividade interna : this.internas){
			if(interna.pos.length == 0){
				Atividade[] novo = new Atividade[finais.length+1];
				for(int iCont = 0; iCont < finais.length; iCont++)
					novo[iCont] = finais[iCont];
				novo[novo.length - 1] = interna;
				finais = novo;
			}
		}
		return finais;
	}
	
	
	

	
	public void addAtividadeInterna(Atividade atividade){
		Atividade[] novo = new Atividade[this.internas.length+1];
		for(int iCont = 0; iCont < this.internas.length; iCont++)
			novo[iCont] = this.internas[iCont];
		novo[novo.length - 1] = atividade;
		this.internas = novo;
	}
	

}
