public abstract class Atividade {

	private long id;
	private String descricao;
	protected Atividade[] pre;
	protected Atividade[] pos;	
	
	
	public Atividade(long id,  String descricao){
		this.setId(id);
		this.setDescricao(descricao);
		this.pre = new Atividade[0];
		this.pos = new Atividade[0];		
		
	}
	
	public long getId() {
		return id;
	}
	public void setId(long id) {
		this.id = id;
	}
	public String getDescricao() {
		return descricao;
	}
	public void setDescricao(String descricao) {
		this.descricao = descricao;
	}
	
	public abstract boolean estaConcluida();
	
	public abstract long getDuracao();
	
	public void addAtividadePre(Atividade atividade){
		Atividade[] novo = new Atividade[this.pre.length+1];
		for(int iCont = 0; iCont < this.pre.length; iCont++)
			novo[iCont] = this.pre[iCont];
		novo[novo.length - 1] = atividade;
		this.pre = novo;
	}	
	
	public void addAtividadePos(Atividade atividade){
		Atividade[] novo = new Atividade[this.pos.length+1];
		for(int iCont = 0; iCont < this.pos.length; iCont++)
			novo[iCont] = this.pos[iCont];
		novo[novo.length - 1] = atividade;
		this.pos = novo;
	}
	
	public long startAfter(){
		long after = 0;
		for(Atividade atividade : this.pre){
			long tempo = atividade.getDuracao() + atividade.startAfter();
			if(after < tempo)
				after = tempo;
		}
		return after;
	}	
	

}
