#ifndef IABSTRACTION_H
#define IABSTRACTION_H

#include <QtCore/QList>
#include <QtWidgets/QAbstractGraphicsShapeItem>

#include "iimplementation.h"

class IAbstraction
{
public:
    IAbstraction(IImplementation *impl = 0);
    void setImplementation(IImplementation *impl);

    virtual QList<QAbstractGraphicsShapeItem  *> graphicItems() = 0;

private:
    IImplementation *impl;
};

Q_DECLARE_METATYPE(IAbstraction *)

#endif // IABSTRACTION_H
