/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.WorldManifold;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactConstraint;
import org.jbox2d.dynamics.contacts.ContactConstraintPoint;
import org.jbox2d.dynamics.contacts.PositionSolverManifold;

public class ContactSolver {
    public static final int INITIAL_NUM_CONSTRAINTS = 256;
    public static final float k_maxConditionNumber = 100.0f;
    public ContactConstraint[] m_constraints;
    public int m_constraintCount;
    private final WorldManifold worldManifold = new WorldManifold();
    private final Vec2 tangent = new Vec2();
    private final Vec2 temp1 = new Vec2();
    private final Vec2 temp2 = new Vec2();
    private final Vec2 P = new Vec2();
    private final Vec2 dv = new Vec2();
    private final Vec2 a = new Vec2();
    private final Vec2 b = new Vec2();
    private final Vec2 dv1 = new Vec2();
    private final Vec2 dv2 = new Vec2();
    private final Vec2 x = new Vec2();
    private final Vec2 d = new Vec2();
    private final Vec2 P1 = new Vec2();
    private final Vec2 P2 = new Vec2();
    private final PositionSolverManifold psolver = new PositionSolverManifold();
    private final Vec2 rA = new Vec2();
    private final Vec2 rB = new Vec2();

    public ContactSolver() {
        this.m_constraints = new ContactConstraint[256];
        for (int i = 0; i < this.m_constraints.length; ++i) {
            this.m_constraints[i] = new ContactConstraint();
        }
    }

    public final void init(Contact[] contacts, int contactCount, float impulseRatio) {
        this.m_constraintCount = contactCount;
        if (this.m_constraints.length < contactCount) {
            ContactConstraint[] old = this.m_constraints;
            int newLen = MathUtils.max(old.length * 2, this.m_constraintCount);
            this.m_constraints = new ContactConstraint[newLen];
            System.arraycopy(old, 0, this.m_constraints, 0, old.length);
            for (int i = old.length; i < this.m_constraints.length; ++i) {
                this.m_constraints[i] = new ContactConstraint();
            }
        }
        for (int i = 0; i < this.m_constraintCount; ++i) {
            float k12;
            float rn2B;
            float rn2A;
            float k22;
            float rn1B;
            Contact contact = contacts[i];
            Fixture fixtureA = contact.m_fixtureA;
            Fixture fixtureB = contact.m_fixtureB;
            Shape shapeA = fixtureA.getShape();
            Shape shapeB = fixtureB.getShape();
            float radiusA = shapeA.m_radius;
            float radiusB = shapeB.m_radius;
            Body bodyA = fixtureA.getBody();
            Body bodyB = fixtureB.getBody();
            Manifold manifold = contact.getManifold();
            float friction = Settings.mixFriction(fixtureA.getFriction(), fixtureB.getFriction());
            float restitution = Settings.mixRestitution(fixtureA.getRestitution(), fixtureB.getRestitution());
            Vec2 vA = bodyA.m_linearVelocity;
            Vec2 vB = bodyB.m_linearVelocity;
            float wA = bodyA.m_angularVelocity;
            float wB = bodyB.m_angularVelocity;
            assert (manifold.pointCount > 0);
            this.worldManifold.initialize(manifold, bodyA.m_xf, radiusA, bodyB.m_xf, radiusB);
            ContactConstraint cc = this.m_constraints[i];
            cc.bodyA = bodyA;
            cc.bodyB = bodyB;
            cc.manifold = manifold;
            cc.normal.x = this.worldManifold.normal.x;
            cc.normal.y = this.worldManifold.normal.y;
            cc.pointCount = manifold.pointCount;
            cc.friction = friction;
            cc.restitution = restitution;
            cc.localNormal.x = manifold.localNormal.x;
            cc.localNormal.y = manifold.localNormal.y;
            cc.localPoint.x = manifold.localPoint.x;
            cc.localPoint.y = manifold.localPoint.y;
            cc.radius = radiusA + radiusB;
            cc.type = manifold.type;
            for (int j = 0; j < cc.pointCount; ++j) {
                ManifoldPoint cp = manifold.points[j];
                ContactConstraintPoint ccp = cc.points[j];
                ccp.normalImpulse = impulseRatio * cp.normalImpulse;
                ccp.tangentImpulse = impulseRatio * cp.tangentImpulse;
                ccp.localPoint.x = cp.localPoint.x;
                ccp.localPoint.y = cp.localPoint.y;
                ccp.rA.x = this.worldManifold.points[j].x - bodyA.m_sweep.c.x;
                ccp.rA.y = this.worldManifold.points[j].y - bodyA.m_sweep.c.y;
                ccp.rB.x = this.worldManifold.points[j].x - bodyB.m_sweep.c.x;
                ccp.rB.y = this.worldManifold.points[j].y - bodyB.m_sweep.c.y;
                float rnA = ccp.rA.x * cc.normal.y - ccp.rA.y * cc.normal.x;
                float rnB = ccp.rB.x * cc.normal.y - ccp.rB.y * cc.normal.x;
                rnA *= rnA;
                rnB *= rnB;
                float kNormal = bodyA.m_invMass + bodyB.m_invMass + bodyA.m_invI * rnA + bodyB.m_invI * rnB;
                assert (kNormal > 1.1920929E-7f);
                ccp.normalMass = 1.0f / kNormal;
                this.tangent.x = 1.0f * cc.normal.y;
                this.tangent.y = -1.0f * cc.normal.x;
                float rtA = ccp.rA.x * this.tangent.y - ccp.rA.y * this.tangent.x;
                float rtB = ccp.rB.x * this.tangent.y - ccp.rB.y * this.tangent.x;
                rtA *= rtA;
                rtB *= rtB;
                float kTangent = bodyA.m_invMass + bodyB.m_invMass + bodyA.m_invI * rtA + bodyB.m_invI * rtB;
                assert (kTangent > 1.1920929E-7f);
                ccp.tangentMass = 1.0f / kTangent;
                ccp.velocityBias = 0.0f;
                this.temp2.x = -wA * ccp.rA.y;
                this.temp2.y = wA * ccp.rA.x;
                this.temp1.x = -wB * ccp.rB.y + vB.x - vA.x - this.temp2.x;
                this.temp1.y = wB * ccp.rB.x + vB.y - vA.y - this.temp2.y;
                Vec2 a = cc.normal;
                float vRel = a.x * this.temp1.x + a.y * this.temp1.y;
                if (!(vRel < -Settings.velocityThreshold)) continue;
                ccp.velocityBias = -restitution * vRel;
            }
            if (cc.pointCount != 2) continue;
            ContactConstraintPoint ccp1 = cc.points[0];
            ContactConstraintPoint ccp2 = cc.points[1];
            float invMassA = bodyA.m_invMass;
            float invIA = bodyA.m_invI;
            float invMassB = bodyB.m_invMass;
            float invIB = bodyB.m_invI;
            float rn1A = Vec2.cross(ccp1.rA, cc.normal);
            float k11 = invMassA + invMassB + invIA * rn1A * rn1A + invIB * (rn1B = Vec2.cross(ccp1.rB, cc.normal)) * rn1B;
            if (k11 * k11 < 100.0f * (k11 * (k22 = invMassA + invMassB + invIA * (rn2A = Vec2.cross(ccp2.rA, cc.normal)) * rn2A + invIB * (rn2B = Vec2.cross(ccp2.rB, cc.normal)) * rn2B) - (k12 = invMassA + invMassB + invIA * rn1A * rn2A + invIB * rn1B * rn2B) * k12)) {
                cc.K.col1.x = k11;
                cc.K.col1.y = k12;
                cc.K.col2.x = k12;
                cc.K.col2.y = k22;
                cc.normalMass.col1.x = cc.K.col1.x;
                cc.normalMass.col1.y = cc.K.col1.y;
                cc.normalMass.col2.x = cc.K.col2.x;
                cc.normalMass.col2.y = cc.K.col2.y;
                cc.normalMass.invertLocal();
                continue;
            }
            cc.pointCount = 1;
        }
    }

    public void warmStart() {
        for (int i = 0; i < this.m_constraintCount; ++i) {
            ContactConstraint c = this.m_constraints[i];
            Body bodyA = c.bodyA;
            Body bodyB = c.bodyB;
            float invMassA = bodyA.m_invMass;
            float invIA = bodyA.m_invI;
            float invMassB = bodyB.m_invMass;
            float invIB = bodyB.m_invI;
            Vec2 normal = c.normal;
            Vec2.crossToOut(normal, 1.0f, this.tangent);
            for (int j = 0; j < c.pointCount; ++j) {
                ContactConstraintPoint ccp = c.points[j];
                float Px = ccp.normalImpulse * normal.x + ccp.tangentImpulse * this.tangent.x;
                float Py = ccp.normalImpulse * normal.y + ccp.tangentImpulse * this.tangent.y;
                bodyA.m_angularVelocity -= invIA * (ccp.rA.x * Py - ccp.rA.y * Px);
                bodyA.m_linearVelocity.x -= Px * invMassA;
                bodyA.m_linearVelocity.y -= Py * invMassA;
                bodyB.m_angularVelocity += invIB * (ccp.rB.x * Py - ccp.rB.y * Px);
                bodyB.m_linearVelocity.x += Px * invMassB;
                bodyB.m_linearVelocity.y += Py * invMassB;
            }
        }
    }

    public final void solveVelocityConstraints() {
        for (int i = 0; i < this.m_constraintCount; ++i) {
            float Py;
            float Px;
            float newImpulse;
            float lambda;
            ContactConstraint c = this.m_constraints[i];
            Body bodyA = c.bodyA;
            Body bodyB = c.bodyB;
            float wA = bodyA.m_angularVelocity;
            float wB = bodyB.m_angularVelocity;
            Vec2 vA = bodyA.m_linearVelocity;
            Vec2 vB = bodyB.m_linearVelocity;
            float invMassA = bodyA.m_invMass;
            float invIA = bodyA.m_invI;
            float invMassB = bodyB.m_invMass;
            float invIB = bodyB.m_invI;
            this.tangent.x = 1.0f * c.normal.y;
            this.tangent.y = -1.0f * c.normal.x;
            float friction = c.friction;
            assert (c.pointCount == 1 || c.pointCount == 2);
            for (int j = 0; j < c.pointCount; ++j) {
                ContactConstraintPoint ccp = c.points[j];
                Vec2 a = ccp.rA;
                this.dv.x = -wB * ccp.rB.y + vB.x - vA.x + wA * a.y;
                this.dv.y = wB * ccp.rB.x + vB.y - vA.y - wA * a.x;
                float vt = this.dv.x * this.tangent.x + this.dv.y * this.tangent.y;
                lambda = ccp.tangentMass * -vt;
                float maxFriction = friction * ccp.normalImpulse;
                newImpulse = MathUtils.clamp(ccp.tangentImpulse + lambda, -maxFriction, maxFriction);
                lambda = newImpulse - ccp.tangentImpulse;
                Px = this.tangent.x * lambda;
                Py = this.tangent.y * lambda;
                vA.x -= Px * invMassA;
                vA.y -= Py * invMassA;
                wA -= invIA * (ccp.rA.x * Py - ccp.rA.y * Px);
                vB.x += Px * invMassB;
                vB.y += Py * invMassB;
                wB += invIB * (ccp.rB.x * Py - ccp.rB.y * Px);
                ccp.tangentImpulse = newImpulse;
            }
            if (c.pointCount == 1) {
                ContactConstraintPoint ccp = c.points[0];
                Vec2 a1 = ccp.rA;
                this.dv.x = -wB * ccp.rB.y + vB.x - vA.x + wA * a1.y;
                this.dv.y = wB * ccp.rB.x + vB.y - vA.y - wA * a1.x;
                Vec2 b = c.normal;
                float vn = this.dv.x * b.x + this.dv.y * b.y;
                lambda = -ccp.normalMass * (vn - ccp.velocityBias);
                float a = ccp.normalImpulse + lambda;
                newImpulse = a > 0.0f ? a : 0.0f;
                lambda = newImpulse - ccp.normalImpulse;
                Px = c.normal.x * lambda;
                Py = c.normal.y * lambda;
                vA.x -= Px * invMassA;
                vA.y -= Py * invMassA;
                wA -= invIA * (ccp.rA.x * Py - ccp.rA.y * Px);
                vB.x += Px * invMassB;
                vB.y += Py * invMassB;
                wB += invIB * (ccp.rB.x * Py - ccp.rB.y * Px);
                ccp.normalImpulse = newImpulse;
            } else {
                ContactConstraintPoint cp1 = c.points[0];
                ContactConstraintPoint cp2 = c.points[1];
                this.a.x = cp1.normalImpulse;
                this.a.y = cp2.normalImpulse;
                assert (this.a.x >= 0.0f && this.a.y >= 0.0f);
                this.dv1.x = -wB * cp1.rB.y + vB.x - vA.x + wA * cp1.rA.y;
                this.dv1.y = wB * cp1.rB.x + vB.y - vA.y - wA * cp1.rA.x;
                this.dv2.x = -wB * cp2.rB.y + vB.x - vA.x + wA * cp2.rA.y;
                this.dv2.y = wB * cp2.rB.x + vB.y - vA.y - wA * cp2.rA.x;
                float vn1 = this.dv1.x * c.normal.x + this.dv1.y * c.normal.y;
                float vn2 = this.dv2.x * c.normal.x + this.dv2.y * c.normal.y;
                this.b.x = vn1 - cp1.velocityBias;
                this.b.y = vn2 - cp2.velocityBias;
                this.temp2.x = c.K.col1.x * this.a.x + c.K.col2.x * this.a.y;
                this.temp2.y = c.K.col1.y * this.a.x + c.K.col2.y * this.a.y;
                this.b.x -= this.temp2.x;
                this.b.y -= this.temp2.y;
                Mat22 R = c.normalMass;
                this.x.x = -R.col1.x * this.b.x - R.col2.x * this.b.y;
                this.x.y = -R.col1.y * this.b.x - R.col2.y * this.b.y;
                if (this.x.x >= 0.0f && this.x.y >= 0.0f) {
                    this.d.set(this.x).subLocal(this.a);
                    this.P1.set(c.normal).mulLocal(this.d.x);
                    this.P2.set(c.normal).mulLocal(this.d.y);
                    vA.x -= invMassA * (this.P1.x + this.P2.x);
                    vA.y -= invMassA * (this.P1.y + this.P2.y);
                    vB.x += invMassB * (this.P1.x + this.P2.x);
                    vB.y += invMassB * (this.P1.y + this.P2.y);
                    wA -= invIA * (Vec2.cross(cp1.rA, this.P1) + Vec2.cross(cp2.rA, this.P2));
                    wB += invIB * (Vec2.cross(cp1.rB, this.P1) + Vec2.cross(cp2.rB, this.P2));
                    cp1.normalImpulse = this.x.x;
                    cp2.normalImpulse = this.x.y;
                } else {
                    float dy;
                    float dx;
                    this.x.x = -cp1.normalMass * this.b.x;
                    this.x.y = 0.0f;
                    vn1 = 0.0f;
                    vn2 = c.K.col1.y * this.x.x + this.b.y;
                    if (this.x.x >= 0.0f && vn2 >= 0.0f) {
                        dx = this.x.x - this.a.x;
                        dy = this.x.y - this.a.y;
                        this.P1.set(c.normal).mulLocal(dx);
                        this.P2.set(c.normal).mulLocal(dy);
                        vA.x -= invMassA * (this.P1.x + this.P2.x);
                        vA.y -= invMassA * (this.P1.y + this.P2.y);
                        vB.x += invMassB * (this.P1.x + this.P2.x);
                        vB.y += invMassB * (this.P1.y + this.P2.y);
                        wA -= invIA * (Vec2.cross(cp1.rA, this.P1) + Vec2.cross(cp2.rA, this.P2));
                        wB += invIB * (Vec2.cross(cp1.rB, this.P1) + Vec2.cross(cp2.rB, this.P2));
                        cp1.normalImpulse = this.x.x;
                        cp2.normalImpulse = this.x.y;
                    } else {
                        this.x.x = 0.0f;
                        this.x.y = -cp2.normalMass * this.b.y;
                        vn1 = c.K.col2.x * this.x.y + this.b.x;
                        vn2 = 0.0f;
                        if (this.x.y >= 0.0f && vn1 >= 0.0f) {
                            dx = this.x.x - this.a.x;
                            dy = this.x.y - this.a.y;
                            this.P1.set(c.normal).mulLocal(dx);
                            this.P2.set(c.normal).mulLocal(dy);
                            vA.x -= invMassA * (this.P1.x + this.P2.x);
                            vA.y -= invMassA * (this.P1.y + this.P2.y);
                            vB.x += invMassB * (this.P1.x + this.P2.x);
                            vB.y += invMassB * (this.P1.y + this.P2.y);
                            wA -= invIA * (Vec2.cross(cp1.rA, this.P1) + Vec2.cross(cp2.rA, this.P2));
                            wB += invIB * (Vec2.cross(cp1.rB, this.P1) + Vec2.cross(cp2.rB, this.P2));
                            cp1.normalImpulse = this.x.x;
                            cp2.normalImpulse = this.x.y;
                        } else {
                            this.x.x = 0.0f;
                            this.x.y = 0.0f;
                            vn1 = this.b.x;
                            vn2 = this.b.y;
                            if (vn1 >= 0.0f && vn2 >= 0.0f) {
                                dx = this.x.x - this.a.x;
                                dy = this.x.y - this.a.y;
                                this.P1.set(c.normal).mulLocal(dx);
                                this.P2.set(c.normal).mulLocal(dy);
                                vA.x -= invMassA * (this.P1.x + this.P2.x);
                                vA.y -= invMassA * (this.P1.y + this.P2.y);
                                vB.x += invMassB * (this.P1.x + this.P2.x);
                                vB.y += invMassB * (this.P1.y + this.P2.y);
                                wA -= invIA * (Vec2.cross(cp1.rA, this.P1) + Vec2.cross(cp2.rA, this.P2));
                                wB += invIB * (Vec2.cross(cp1.rB, this.P1) + Vec2.cross(cp2.rB, this.P2));
                                cp1.normalImpulse = this.x.x;
                                cp2.normalImpulse = this.x.y;
                            }
                        }
                    }
                }
            }
            bodyA.m_angularVelocity = wA;
            bodyB.m_angularVelocity = wB;
        }
    }

    public void storeImpulses() {
        for (int i = 0; i < this.m_constraintCount; ++i) {
            ContactConstraint c = this.m_constraints[i];
            Manifold m = c.manifold;
            for (int j = 0; j < c.pointCount; ++j) {
                m.points[j].normalImpulse = c.points[j].normalImpulse;
                m.points[j].tangentImpulse = c.points[j].tangentImpulse;
            }
        }
    }

    public final boolean solvePositionConstraints(float baumgarte) {
        float minSeparation = 0.0f;
        for (int i = 0; i < this.m_constraintCount; ++i) {
            ContactConstraint c = this.m_constraints[i];
            Body bodyA = c.bodyA;
            Body bodyB = c.bodyB;
            float invMassA = bodyA.m_mass * bodyA.m_invMass;
            float invIA = bodyA.m_mass * bodyA.m_invI;
            float invMassB = bodyB.m_mass * bodyB.m_invMass;
            float invIB = bodyB.m_mass * bodyB.m_invI;
            for (int j = 0; j < c.pointCount; ++j) {
                PositionSolverManifold psm = this.psolver;
                psm.initialize(c, j);
                Vec2 normal = psm.normal;
                Vec2 point = psm.point;
                float separation = psm.separation;
                this.rA.set(point).subLocal(bodyA.m_sweep.c);
                this.rB.set(point).subLocal(bodyB.m_sweep.c);
                minSeparation = MathUtils.min(minSeparation, separation);
                float C = MathUtils.clamp(baumgarte * (separation + Settings.linearSlop), -Settings.maxLinearCorrection, 0.0f);
                float rnA = Vec2.cross(this.rA, normal);
                float rnB = Vec2.cross(this.rB, normal);
                float K = invMassA + invMassB + invIA * rnA * rnA + invIB * rnB * rnB;
                float impulse = K > 0.0f ? -C / K : 0.0f;
                float Px = normal.x * impulse;
                float Py = normal.y * impulse;
                bodyA.m_sweep.c.x -= Px * invMassA;
                bodyA.m_sweep.c.y -= Py * invMassA;
                bodyA.m_sweep.a -= invIA * Vec2.cross(this.rA, this.P);
                bodyA.synchronizeTransform();
                bodyB.m_sweep.c.x += Px * invMassB;
                bodyB.m_sweep.c.y += Py * invMassB;
                bodyB.m_sweep.a += invIB * Vec2.cross(this.rB, this.P);
                bodyB.synchronizeTransform();
            }
        }
        return minSeparation >= -1.5f * Settings.linearSlop;
    }
}

