/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.io.Serializable;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;

public class Transform
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Vec2 position;
    public final Mat22 R;

    public Transform() {
        this.position = new Vec2();
        this.R = new Mat22();
    }

    public Transform(Transform xf) {
        this.position = xf.position.clone();
        this.R = xf.R.clone();
    }

    public Transform(Vec2 _position, Mat22 _R) {
        this.position = _position.clone();
        this.R = _R.clone();
    }

    public final Transform set(Transform xf) {
        this.position.set(xf.position);
        this.R.set(xf.R);
        return this;
    }

    public final void set(Vec2 p, float angle) {
        this.position.set(p);
        this.R.set(angle);
    }

    public final float getAngle() {
        return MathUtils.atan2(this.R.col1.y, this.R.col1.x);
    }

    public final void setIdentity() {
        this.position.setZero();
        this.R.setIdentity();
    }

    public static final Vec2 mul(Transform T, Vec2 v) {
        return new Vec2(T.position.x + T.R.col1.x * v.x + T.R.col2.x * v.y, T.position.y + T.R.col1.y * v.x + T.R.col2.y * v.y);
    }

    public static final void mulToOut(Transform T, Vec2 v, Vec2 out) {
        float tempy = T.position.y + T.R.col1.y * v.x + T.R.col2.y * v.y;
        out.x = T.position.x + T.R.col1.x * v.x + T.R.col2.x * v.y;
        out.y = tempy;
    }

    public static final Vec2 mulTrans(Transform T, Vec2 v) {
        float v1x = v.x - T.position.x;
        float v1y = v.y - T.position.y;
        Vec2 b = T.R.col1;
        Vec2 b1 = T.R.col2;
        return new Vec2(v1x * b.x + v1y * b.y, v1x * b1.x + v1y * b1.y);
    }

    public static final void mulTransToOut(Transform T, Vec2 v, Vec2 out) {
        float v1x = v.x - T.position.x;
        float v1y = v.y - T.position.y;
        Vec2 b = T.R.col1;
        Vec2 b1 = T.R.col2;
        float tempy = v1x * b1.x + v1y * b1.y;
        out.x = v1x * b.x + v1y * b.y;
        out.y = tempy;
    }

    public final String toString() {
        String s = "XForm:\n";
        s = s + "Position: " + this.position + "\n";
        s = s + "R: \n" + this.R + "\n";
        return s;
    }
}

