package br.ifba.ads.inf008.imc.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import br.ifba.ads.inf008.imc.model.Pessoa;

public class MemDAOPessoa implements IDAOPessoa{

	private final String fileName = "C:\\Users\\aluno\\workspace\\PESSOA.POJO"; 
	
	private Map<String, Pessoa> mapaPessoas;
	
	public MemDAOPessoa() throws FileNotFoundException, IOException, ClassNotFoundException{
		File file = new File(fileName);
		if(file.exists()){
			ObjectInputStream ois = new ObjectInputStream(new FileInputStream(fileName));
			this.mapaPessoas = (Map<String, Pessoa>) ois.readObject();
			ois.close();
		}
		else
			this.mapaPessoas = new HashMap<String, Pessoa>();
		
	}
	
	@Override
	public void salvar(Pessoa pessoa) throws FileNotFoundException, IOException {
		ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fileName));
		this.mapaPessoas.put(pessoa.getNome(), pessoa);
		oos.writeObject(this.mapaPessoas);
		oos.close();
	}

	@Override
	public Pessoa recuperarPeloNome(String nome) {
		return this.mapaPessoas.get(nome);
	}

	@Override
	public Set<Pessoa> recuperarTodos() {
		return new HashSet<Pessoa>(this.mapaPessoas.values());
	}

}
