package br.ifba.ads.inf008.imc.model;

import java.io.FileNotFoundException;
import java.io.IOException;

import br.ifba.ads.inf008.imc.persistence.BDDAOPessoa;
import br.ifba.ads.inf008.imc.persistence.IDAOPessoa;
import br.ifba.ads.inf008.imc.persistence.MemDAOPessoa;

public class CalculaIMCApp implements ICalculaIMCApp {

	private IDAOPessoa daoPessoa;
	
	public CalculaIMCApp() throws FileNotFoundException, ClassNotFoundException, IOException{
		this.daoPessoa = new BDDAOPessoa();
	}
	
	@Override
	public FichaIMC calcularIMC(String nome, double peso, long altura) {
		Pessoa pessoa = new Pessoa(nome, peso, altura);
		CalculadoraIMC calculadora = new CalculadoraIMC();
		
		double imc = calculadora.getIMC(pessoa.getPeso(), pessoa.getAltura());
		String classificacaoIMC = calculadora.getClassificacao(imc);
		
		return new FichaIMC(pessoa.getNome(), imc, classificacaoIMC);
	}

	@Override
	public FichaIMC calcularIMC(String nome) throws Exception {
		Pessoa pessoa =  this.daoPessoa.recuperarPeloNome(nome);
		return this.calcularIMC(pessoa.getNome(), pessoa.getPeso(), pessoa.getAltura());
	}

	@Override
	public void salvar(String nome, double peso, long altura) throws Exception {
		Pessoa pessoa = new Pessoa(nome, peso, altura);
		this.daoPessoa.salvar(pessoa);
	}

}
