package br.ifba.ads.inf008.imc.ui;

import java.io.FileNotFoundException;
import java.io.IOException;

import br.ifba.ads.inf008.imc.model.FichaIMC;

public class IMCCommandLine extends IMCUI{
	
	public IMCCommandLine() throws FileNotFoundException, ClassNotFoundException, IOException{
		super();
	}
	
	public void run(String[] args){
		if(args.length != 3){
			System.out.println("Numero de Argumentos Errados");
			return;
		}	
		String nome = args[0];
		double peso = Double.parseDouble(args[1]);
		long altura = Long.parseLong(args[2]);
		FichaIMC ficha = this.app.calcularIMC(nome, peso, altura);
		this.printFichaApp(ficha);
	}
	
	public static void main(String[] args) throws FileNotFoundException, ClassNotFoundException, IOException {
		(new IMCCommandLine()).run(args);
	}

}
