package br.ifba.ads.inf008.imc.ui;

import java.awt.GridLayout;
import java.io.FileNotFoundException;
import java.io.IOException;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

import br.ifba.ads.inf008.imc.model.CalculaIMCApp;
import br.ifba.ads.inf008.imc.model.FichaIMC;
import br.ifba.ads.inf008.imc.model.ICalculaIMCApp;

public class IMCWindow extends JFrame{


	private static final long serialVersionUID = 1L;
	private JTextField nomeTextField;
	private JTextField pesoTextField;
	private JTextField alturaTextField;	

	private JLabel nomeLabel;
	private JLabel pesoLabel;
	private JLabel alturaLabel;		
	
	private JButton calcularBTN;
	
	private ICalculaIMCApp app;
	
	   public IMCWindow() throws FileNotFoundException, ClassNotFoundException, IOException {
	        initComponents();
			this.app = new CalculaIMCApp();	        
	    }	
	
	private void initComponents() {
	    this.nomeTextField = new JTextField();
	    this.pesoTextField = new JTextField();
	    this.alturaTextField = new JTextField();
	    this.nomeLabel = new JLabel();
	    this.pesoLabel = new JLabel();	
	    this.alturaLabel= new JLabel();
	    
	    this.calcularBTN = new JButton();
	    this.calcularBTN.setText("Calcular IMC");
	    this.setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
	    
	    this.setTitle("Calcular IMC");
	 
	    this.nomeLabel.setText("Nome: ");
	    this.pesoLabel.setText("Peso: ");	
	    this.alturaLabel.setText("Altura: ");	    

	    
	    this.calcularBTN.addActionListener(new java.awt.event.ActionListener() {
	            public void actionPerformed(java.awt.event.ActionEvent evt) {
	                calcularIMCActionPerformed(evt);
	            }
	        });
	 
        GridLayout layout = new GridLayout(4, 2);
	    this.getContentPane().setLayout(layout);
	    
	    this.getContentPane().add(this.nomeLabel);
	    this.getContentPane().add(this.nomeTextField);	    
	    
	    this.getContentPane().add(this.pesoLabel);
	    this.getContentPane().add(this.pesoTextField);	    

	    this.getContentPane().add(this.alturaLabel);
	    this.getContentPane().add(this.alturaTextField);	    

	    this.getContentPane().add(this.calcularBTN);
	    
	    this.pack();
	 }	
	
	
	private void calcularIMCActionPerformed(java.awt.event.ActionEvent evt) {
		FichaIMC ficha;
		JLabel label1 = new JLabel();
		JLabel label2 = new JLabel();
		JLabel label3 = new JLabel();
		
		
		
		ficha = this.app.calcularIMC(this.nomeTextField.getText(),
				             Double.parseDouble(this.pesoTextField.getText()), 
				             Long.parseLong(this.alturaTextField.getText()));
		
		JDialog dialog = new JDialog(this, true); 
		dialog.setTitle("Ficha IMC");
		dialog.setSize(200,200);
		
		dialog.getContentPane().setLayout(new GridLayout(3,1));
		
		label1.setText("Nome: " + ficha.getNome());
		label2.setText("IMC: " + ficha.getImc());
		label3.setText("Classificacao: " + ficha.getClassificacaoIMC());
		
		dialog.add(label1);
		dialog.add(label2);
		dialog.add(label3);
		
		dialog.setVisible(true);
		
    }
	
	public void run(){
		this.setVisible(true);
	}
	
	public static void main(String[] args) throws FileNotFoundException, ClassNotFoundException, IOException {
	  (new IMCWindow()).run();	
	}
	
}
