package br.ifba.ads.inf008.imc.ui;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;

import br.ifba.ads.inf008.imc.exception.IMCException;
import br.ifba.ads.inf008.imc.model.FichaIMC;



public class IMCConsole extends IMCUI{
	
	private BufferedReader bf;
	
	public IMCConsole() throws FileNotFoundException, ClassNotFoundException, IOException{
		super();
		this.bf = new BufferedReader(new InputStreamReader(System.in));
	}
	
	@Override
	public void run(String[] args) throws Exception {
		int opcao = 1;
		
		while(opcao != 0){
			opcao = menu();
			switch(opcao){
			   case 1:opcao1();break;
			   case 2:opcao2();break;
			   case 3:opcao3();break;
			}
		}
	}
	
	
	public int menu() throws NumberFormatException, IOException{
		System.out.println("\n\n\n");
		System.out.println("************************************");
		System.out.println("[1] - Calcular Ficha Dados Completos");
		System.out.println("[2] - Salvar Dados");
		System.out.println("[3] -  Calcular Ficha Salva");
		System.out.println("[0] -  Finaliza");		
		System.out.println("************************************");		
		return Integer.parseInt(this.bf.readLine());
	}
	
	public void opcao1() throws IOException{
		String nome;
		double peso;
		long altura;
		
		System.out.println("Informe o nome do paciente");
		nome = this.bf.readLine();
		
		System.out.println("Informe o peso do paciente");
		peso = Double.parseDouble(this.bf.readLine());

		System.out.println("Informe a altura do paciente");
		altura = Long.parseLong(this.bf.readLine());
		
		this.calcularIMC(nome, peso, altura);
	}
	
	public void opcao2() throws Exception{
		String nome;
		double peso;
		long altura;
		
		System.out.println("Informe o nome do paciente");
		nome = this.bf.readLine();
		
		System.out.println("Informe o peso do paciente");
		peso = Double.parseDouble(this.bf.readLine());

		System.out.println("Informe a altura do paciente");
		altura = Long.parseLong(this.bf.readLine());
		
		this.salvar(nome, peso, altura);
	}
	

	public void opcao3() throws Exception{
		String nome;
		
		System.out.println("Informe o nome do paciente");
		nome = this.bf.readLine();
		
		try{
			this.calcularIMC(nome);
		}catch(IMCException e){
			System.out.println("Paciente Invalido: " + e.getMensagemErro());
		}
	}
	
	
	public static void main(String[] args) throws Exception {
		(new IMCConsole()).run(args);
	}	
	
	
}
