/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package DAO;

import POJO.Livro;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

/**
 *
 * @author manoel
 */
public class DaoLivroHibernate implements DaoLivro {
    private Session session = ConexaoHibernate.getSessionFactory().openSession();
    @Override
    public void save(Livro livro) throws Exception {
        Transaction t = session.beginTransaction();
        session.save(livro);
        t.commit();
    }

    @Override
    public Livro load(String isbn) throws Exception {
       return (Livro) session.load(Livro.class, isbn);
    }

    @Override
    public List<Livro> list(String autor) throws Exception {
        Transaction t = session.beginTransaction();
        Query query = session.createQuery("from Livro l where l.autor like :nome");
        List lista = query.setString("nome", "%" + autor + "%").list();
        t.commit();
        return lista;
    }

    @Override
    public List<Livro> listAll() throws Exception {
        Transaction t = session.beginTransaction();
        List lista = session.createQuery("from Livro").list();
        t.commit();
        return lista;
    }
    
    

    @Override
    public void update(Livro livro) throws Exception {       
        Transaction t = session.beginTransaction();
        session.update(livro);
        t.commit();
    }

    @Override
    public void remove(Livro livro) throws Exception {
        Transaction t = session.beginTransaction();
        session.delete(livro);
        t.commit();
    }
}
