/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package controle;

import DAO.DaoLivro;
import DAO.DaoLivroHibernate;
import POJO.Livro;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.event.RowEditEvent;

/**
 *
 * @author manoel
 */
@ManagedBean(name = "livroBean")
@SessionScoped
public class LivroBean implements Serializable {

    private Livro local = new Livro();
    private DaoLivro dao = new DaoLivroHibernate();
    private List<Livro> lista;

    public String getTitulo() {
        return local.getTitulo();
    }

    public void setTitulo(String titulo) {
        local.setTitulo(titulo);
    }

    public String getGenero() {
        return local.getGenero();
    }

    public void setGenero(String genero) {
        local.setGenero(genero);
    }

    public LivroBean() {
    }

    public String getIsbn() {
        return local.getIsbn();
    }

    public void setIsbn(String isbn) {
        local.setIsbn(isbn);
    }

    public String getAutor() {
        return local.getAutor();
    }

    public void setAutor(String autor) {
        local.setAutor(autor);
    }

    public List<Livro> getLista() {
        return lista;
    }

    public void saveLivro(ActionEvent actionEvent) {
        try {
            dao.save(local);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Livro " + local.getTitulo() + " salvo com sucesso!"));
            local = new Livro();
        } catch (Exception ex) {
            Logger.getLogger(LivroBean.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void searchAutor(ActionEvent actionEvent) {
        try {
            lista = dao.list(local.getAutor());
            FacesContext faces = FacesContext.getCurrentInstance();
            faces.getExternalContext().redirect("/Livros/faces/lista.xhtml");
            //faces.getApplication().getNavigationHandler().handleNavigation(faces, null, "/lista.xhtml");
        } catch (Exception ex) {
            Logger.getLogger(LivroBean.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void onEdit(RowEditEvent event) {
        Livro temp = (Livro) event.getObject();
        try {
            dao.update(temp);
            FacesMessage msg = new FacesMessage("Livro Editado", temp.getTitulo());
            FacesContext.getCurrentInstance().addMessage(null, msg);
        } catch (Exception ex) {
            Logger.getLogger(LivroBean.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void onCancel(RowEditEvent event) {   
    }
    
    public void  deleteLivro(Livro livro){
    FacesMessage msg = new FacesMessage("Problemas ao tentar apagar o Livro Apagado", local.getTitulo());
        try {
            dao.remove(livro);
            msg = new FacesMessage("Livro Apagado", livro.getTitulo());
            lista = dao.list(local.getAutor());
        } catch (Exception ex) {
            Logger.getLogger(LivroBean.class.getName()).log(Level.SEVERE, null, ex);
        }
        FacesContext.getCurrentInstance().addMessage(null, msg);
    }
}
