/*
 * Decompiled with CFR 0.152.
 */
package desenho.formas;

import desenho.Elementar;
import desenho.formas.FormaArea;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.XMLGenerate;

public class DimensionadorArea
extends Elementar {
    private static final long serialVersionUID = -625690746882991181L;
    private final FormaArea regiao;
    boolean isHide = false;
    Point inidown = new Point(0, 0);
    Point down = new Point(0, 0);
    boolean isMouseDown = false;
    public boolean AllwaysHide = false;
    private int largura = 10;
    private String texto = "";

    public DimensionadorArea(FormaArea reg) {
        super(reg);
        this.setWidth(this.getMaster().getPontoWidth());
        this.setHeight(this.getMaster().getPontoHeigth() * 4);
        this.setBackColor(Color.BLACK);
        this.regiao = reg;
    }

    public boolean getIsHide() {
        return this.isHide;
    }

    public void setIsHide(boolean ishide) {
        this.isHide = ishide;
    }

    @Override
    public boolean isCanPaint() {
        return super.isCanPaint() && !this.getIsHide();
    }

    @Override
    public void DoPaint(Graphics2D g) {
        if (this.regiao == null) {
            return;
        }
        super.DoPaint(g);
        g.setColor(this.getBackColor());
        g.fillRect(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.inidown = new Point(e.getX(), e.getY());
        this.isMouseDown = true;
        this.down = new Point(e.getX(), e.getY());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isMouseDown = false;
        FormaArea dono = this.regiao;
        dono.Reenquadre();
        dono.DoRaizeReenquadreReposicione();
        Point enddown = new Point(e.getX(), e.getY());
        if (!enddown.equals(this.inidown)) {
            dono.DoMuda();
        }
        super.mouseReleased(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        FormaArea dono = this.regiao;
        super.mouseDragged(e);
        int X = e.getX();
        if (this.isMouseDown && (double)X - this.down.getX() != 0.0) {
            int mov = X - this.down.x;
            int b = this.getLargura();
            this.setLargura(this.getLargura() + mov);
            if (b != this.getLargura()) {
                b = this.getLargura() - b;
                if (b != mov) {
                    X -= mov - b;
                }
                this.down.setLocation(new Point(X, e.getY()));
            }
            dono.RePosicioneRegioes();
        }
    }

    public void Posicione() {
        FormaArea fa = this.regiao;
        int top = this.regiao.getTop() + this.regiao.getAlturaTexto();
        int t = top + (fa.getHeight() - this.getHeight()) / 2;
        int l = this.regiao.getLocalDaLinha(this);
        this.SetBounds(l, t, this.getWidth(), this.getHeight());
        this.setCursor(new Cursor(11));
    }

    @Override
    public void mouseDblClicked(MouseEvent e) {
        this.regiao.Remova(this);
    }

    public int getLargura() {
        return this.largura;
    }

    public void setLargura(int largura) {
        this.largura = largura;
        if (this.largura < this.getWidth() / 2) {
            this.largura = this.getWidth() / 2;
        }
    }

    public String getTexto() {
        return this.texto;
    }

    public void setTexto(String texto) {
        this.texto = texto;
    }

    protected void ToXmlValores(Document doc, Element root) {
        Element me = doc.createElement("Dimensao");
        me.appendChild(XMLGenerate.ValorString(doc, "Texto", this.getTexto()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Largura", this.getLargura()));
        root.appendChild(me);
    }

    public boolean LoadFromXML(Element me, boolean colando) {
        this.setTexto(XMLGenerate.getValorStringFrom(me, "Texto"));
        this.setLargura(XMLGenerate.getValorIntegerFrom(me, "Largura"));
        return true;
    }
}

