/*
 * Decompiled with CFR 0.152.
 */
package desenho.preAnyDiagrama;

import controlador.Diagrama;
import desenho.formas.FormaTextoBase;
import desenho.linhas.SuperLinha;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;

public class PreTexto
extends FormaTextoBase {
    private static final long serialVersionUID = 101922832291188735L;
    private boolean autosize = false;
    private TipoTexto Tipo = TipoTexto.tpNota;
    private boolean sombra = true;
    private Color corSombra = new Color(51, 51, 51);
    private boolean gradiente = false;
    private Color gradienteEndColor = new Color(204, 204, 204, 255);
    private Color gradienteStartColor = Color.BLACK;
    private boolean gradientePinteDetalhe = true;
    private Color gradienteCorDetalhe = new Color(102, 102, 102);
    private transient int fonteH = 0;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private final int roundRectSize = 12;
    private int gdirecao = 0;
    private String titulo = "";
    private boolean paintTitulo = false;
    private float alfa = 0.8f;

    public PreTexto(Diagrama modelo) {
        super(modelo);
        this.Init();
    }

    public PreTexto(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.titulo = this.getTexto();
        this.Init();
    }

    private void Init() {
        this.getTextoFormatado().LimitarAreaDePintura = true;
        this.setBackColor(Color.WHITE);
    }

    protected void ReSizedByAutoSize() {
    }

    public TipoTexto getTipo() {
        return this.Tipo;
    }

    public void setTipo(TipoTexto Tipo) {
        this.Tipo = Tipo;
        this.InvalidateArea();
    }

    public void setTipobyInt(int Tipo) {
        TipoTexto inttp = TipoTexto.tpRetangulo;
        try {
            inttp = TipoTexto.values()[Tipo];
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.Tipo = inttp;
        Rectangle rec = this.getBounds();
        rec.grow(2, 2);
        this.InvalidateArea(rec);
    }

    public boolean isSombra() {
        return this.sombra;
    }

    public void setSombra(boolean Sombra) {
        this.sombra = Sombra;
        this.Invalidate();
    }

    public Color getCorSombra() {
        return this.isDisablePainted() ? this.disabledColor : this.corSombra;
    }

    public void setCorSombra(Color corSombra) {
        if (this.corSombra != corSombra) {
            this.corSombra = corSombra;
            this.InvalidateArea(this.getSuperArea());
        }
    }

    public Color getGradienteCorDetalhe() {
        return this.isDisablePainted() ? this.disabledColor : this.gradienteCorDetalhe;
    }

    public void setGradienteCorDetalhe(Color gradienteCorDetalhe) {
        this.gradienteCorDetalhe = gradienteCorDetalhe;
        this.InvalidateArea();
    }

    public boolean isGradientePinteDetalhe() {
        return this.gradientePinteDetalhe;
    }

    public void setGradientePinteDetalhe(boolean gradientePinteDetalhe) {
        this.gradientePinteDetalhe = gradientePinteDetalhe;
        this.InvalidateArea();
    }

    public Color getGradienteStartColor() {
        return this.isDisablePainted() ? this.disabledColor : this.gradienteStartColor;
    }

    public void setGradienteStartColor(Color gradienteStartColor) {
        this.gradienteStartColor = gradienteStartColor;
        this.InvalidateArea();
    }

    public boolean isGradiente() {
        return this.gradiente;
    }

    public void setGradiente(boolean gradiente) {
        this.gradiente = gradiente;
        this.InvalidateArea();
    }

    public Color getGradienteEndColor() {
        return this.isDisablePainted() ? this.disabledColor : this.gradienteEndColor;
    }

    public void setGradienteEndColor(Color gradienteEndColor) {
        this.gradienteEndColor = gradienteEndColor;
        this.InvalidateArea();
    }

    @Override
    public void DoPaint(Graphics2D g) {
        Composite originalComposite = g.getComposite();
        switch (this.Tipo) {
            case tpNota: {
                if (this.isGradiente()) {
                    int dist = 0;
                    int w = this.getWidth() - dist;
                    int h = this.getHeight() - dist;
                    int L = this.getLeft();
                    int T = this.getTop();
                    boolean dv = this.getGDirecao() == 0;
                    GradientPaint GP = new GradientPaint(L, T, this.getGradienteStartColor(), dv ? (float)L : (float)(L + w), dv ? (float)(T + h) : (float)T, this.getGradienteEndColor(), true);
                    g.setPaint(GP);
                } else {
                    g.setColor(this.getBackColor());
                }
                g.setComposite(AlphaComposite.getInstance(3, this.alfa));
                GeneralPath pa = new GeneralPath();
                pa.setWindingRule(1);
                Rectangle rec = this.getBounds();
                int tam = Math.min(rec.width / 6, rec.height / 6);
                int curv = tam / 4;
                int lw = rec.x + rec.width;
                int[] px = new int[]{rec.x, lw - tam, lw, lw, rec.x};
                int[] py = new int[]{rec.y, rec.y, rec.y + tam, rec.y + rec.height, rec.y + rec.height};
                Polygon po = new Polygon(px, py, 5);
                pa.append(po, true);
                pa.moveTo(lw - tam, rec.y);
                pa.curveTo(lw - tam, rec.y, lw - tam + curv, rec.y + curv, lw - tam, rec.y + tam - 1);
                pa.moveTo(lw - tam, rec.y + tam - 1);
                pa.lineTo(lw, rec.y + tam);
                pa.closePath();
                if (this.isGradiente()) {
                    g.fill(pa);
                    g.draw(pa);
                    break;
                }
                g.fill(pa);
                g.setColor(this.getForeColor());
                g.draw(pa);
                break;
            }
            case tpRetangulo: {
                if (this.sombra) {
                    g.setPaint(this.getCorSombra());
                    for (int i = 0; i < 2; ++i) {
                        g.drawLine(this.getLeft() + 2, this.getTopHeight() + i, this.getLeftWidth() + 2 - 1, this.getTopHeight() + i);
                        g.drawLine(this.getLeftWidth() + i, this.getTop() + 2, this.getLeftWidth() + i, this.getTopHeight() + 2 - 1);
                    }
                }
                g.setComposite(AlphaComposite.getInstance(3, this.alfa));
                g.setPaint(this.getBackColor());
                if (this.isGradiente()) {
                    this.PaintGradiente(g, false);
                    break;
                }
                g.fillRect(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
                if (this.sombra) {
                    g.setPaint(this.getCorSombra());
                } else {
                    g.setPaint(this.getForeColor());
                }
                g.drawRect(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
                break;
            }
            case tpRetanguloArred: {
                if (this.sombra) {
                    int rx = 6;
                    g.setPaint(this.getCorSombra());
                    for (int i = 0; i < 2; ++i) {
                        g.drawLine(this.getLeft() + rx, this.getTopHeight() + i, this.getLeftWidth() + 2 - 1, this.getTopHeight() + i);
                        g.drawLine(this.getLeftWidth() + i, this.getTop() + rx, this.getLeftWidth() + i, this.getTopHeight() + 2 - 1);
                    }
                    g.fillPolygon(new int[]{this.getLeftWidth() - rx, this.getLeftWidth(), this.getLeftWidth()}, new int[]{this.getTopHeight(), this.getTopHeight() - rx, this.getTopHeight()}, 3);
                }
                g.setPaint(this.getBackColor());
                g.setComposite(AlphaComposite.getInstance(3, this.alfa));
                if (this.isGradiente()) {
                    this.PaintGradiente(g, true);
                    break;
                }
                g.fillRoundRect(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 12, 12);
                if (this.sombra) {
                    g.setPaint(this.getCorSombra());
                } else {
                    g.setPaint(this.getForeColor());
                }
                g.drawRoundRect(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 12, 12);
            }
        }
        g.setColor(this.getForeColor());
        if (this.isPaintTitulo()) {
            g.setFont(this.getFont());
            if (this.fonteH == 0) {
                FontMetrics fm = g.getFontMetrics();
                this.fonteH = fm.getHeight();
            }
            int db = 6;
            Rectangle bkp = g.getClipBounds();
            Rectangle cl = this.getClientRectangle();
            g.clipRect(cl.x, cl.y, cl.width, cl.height);
            int des = this.fonteH + this.fonteH / 2;
            g.drawString(this.getTitulo(), this.getLeft() + db, this.getTop() + des);
            g.setClip(bkp);
            int av = db + des;
            this.getTextoFormatado().CorretorPosicao = new Point(db, av + db);
        } else {
            this.getTextoFormatado().CorretorPosicao = new Point(4, 4);
        }
        g.setComposite(originalComposite);
        super.DoPaint(g);
        if (this.Tipo == TipoTexto.tpEmBranco && this.isAutosize()) {
            FontMetrics fm = g.getFontMetrics();
            int x = -1;
            int y = -1;
            int a = this.getTextoFormatado().getMaxWidth() + 4 + fm.charWidth('W');
            if (a != this.getWidth()) {
                x = a;
            }
            if ((a = this.getTextoFormatado().getMaxHeigth() + 2) != this.getHeight()) {
                y = a;
            }
            if (y != -1 || x != -1) {
                this.setStopRaize(true);
                if (x != -1) {
                    this.setWidth(x);
                }
                if (y != -1) {
                    this.setHeight(y);
                }
                this.setStopRaize(false);
                this.needRecalPts = true;
                if (this.isSelecionado()) {
                    this.Reposicione();
                }
                this.ReSizedByAutoSize();
            }
        }
    }

    public float getAlfa() {
        return this.alfa;
    }

    public void setAlfa(float alfa) {
        this.alfa = alfa;
    }

    public void SetAlfa(int alfa) {
        this.alfa = (float)alfa / 100.0f;
        if (this.alfa > 1.0f) {
            this.alfa = 0.5f;
        }
        this.InvalidateArea();
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        if (!this.titulo.equals(titulo)) {
            this.titulo = titulo;
            this.InvalidateArea();
        }
    }

    public boolean isPaintTitulo() {
        return this.paintTitulo;
    }

    public void setPaintTitulo(boolean paintTitulo) {
        if (this.paintTitulo != paintTitulo) {
            this.paintTitulo = paintTitulo;
            this.InvalidateArea();
        }
    }

    public int getGDirecao() {
        return this.gdirecao;
    }

    public void setGDirecao(int aDirection) {
        this.gdirecao = aDirection;
        this.InvalidateArea();
    }

    protected void PaintGradiente(Graphics2D g, boolean round) {
        int dist = 0;
        int w = this.getWidth() - dist;
        int h = this.getHeight() - dist;
        int L = this.getLeft();
        int T = this.getTop();
        boolean dv = this.getGDirecao() == 0;
        GradientPaint GP = new GradientPaint(L, T, this.getGradienteStartColor(), dv ? (float)L : (float)(L + w), dv ? (float)(T + h) : (float)T, this.getGradienteEndColor(), true);
        g.setPaint(this.getForeColor());
        if (round) {
            g.drawRoundRect(L, T, w - 1, h - 1, 12, 12);
            g.setPaint(GP);
            g.fillRoundRect(L + 1, T + 1, w - 2, h - 2, 12, 12);
            g.setPaint(this.isDisablePainted() ? this.disabledColor : Color.WHITE);
            g.drawRoundRect(L + 1, T + 1, w - 3, h - 3, 12, 12);
        } else {
            g.drawRect(L, T, w - 1, h - 1);
            g.setPaint(GP);
            g.fillRect(L + 1, T + 1, w - 2, h - 2);
            g.setPaint(this.isDisablePainted() ? this.disabledColor : Color.WHITE);
            g.drawRect(L + 1, T + 1, w - 3, h - 3);
        }
        if (this.isGradientePinteDetalhe()) {
            g.setPaint(this.getGradienteCorDetalhe());
            GeneralPath path = new GeneralPath();
            path.moveTo(L + 2, T + 2);
            path.quadTo(L + w / 2 + 1, T + h / 2 + 1, L + w - 1, T + 2);
            path.closePath();
            g.fill(path);
        }
    }

    @Override
    public void EscrevaTexto(ArrayList<String> txts) {
        txts.add(this.getTitulo());
    }

    public boolean isAutosize() {
        return this.autosize;
    }

    public void setAutosize(boolean autosize) {
        if (this.autosize == autosize) {
            return;
        }
        this.autosize = autosize;
        this.InvalidateArea();
    }

    public void Posicione() {
    }

    public void SetLinhaMestre(SuperLinha LinhaMestre) {
    }

    @Override
    public void PinteTexto(Graphics2D g) {
        super.PinteTexto(g);
        if (this.getTextoFormatado().CorretorPosicao.equals(new Point(0, 0))) {
            this.InvalidateArea();
        }
    }

    public static enum TipoTexto {
        tpEmBranco,
        tpNota,
        tpRetangulo,
        tpRetanguloArred;

    }
}

