/*
 * Decompiled with CFR 0.152.
 */
package controlador.editores;

import controlador.Editor;
import controlador.editores.EditorTexto;
import diagramas.logico.DataBaseModel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import principal.Aplicacao;
import util.BrLogger;
import util.Dialogos;

public class MostradorDeCodigo
extends JDialog
implements ClipboardOwner {
    int vlZoom = 12;
    private JButton btnCopy;
    private JButton btnEditar;
    private JButton btnFechar;
    private JButton btnSalvar;
    private JButton btnZma;
    private JButton btnZmn;
    private JPanel jPanel2;
    private JToolBar.Separator jSeparator1;
    private JToolBar jToolBar1;
    private JScrollPane scrPrincipal;
    private JTextField txtZoon;
    public JLabel lblHtml = null;
    private DataBaseModel dbModel = new DataBaseModel();
    private String buffer = "";

    public MostradorDeCodigo(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.lblHtml = new JLabel();
        this.scrPrincipal.getViewport().add(this.lblHtml);
        this.getRootPane().registerKeyboardAction(e -> this.setVisible(false), KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().registerKeyboardAction(e -> this.setVisible(false), KeyStroke.getKeyStroke(10, 128), 2);
        this.getRootPane().registerKeyboardAction(e -> this.btnCopyActionPerformed(null), KeyStroke.getKeyStroke(67, 128), 2);
        this.setTitle(Editor.fromConfiguracao.getValor("Controler.interface.Titulo.MostradorDeCodigo"));
        this.pack();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.btnFechar = new JButton();
        this.scrPrincipal = new JScrollPane();
        this.jToolBar1 = new JToolBar();
        this.btnZmn = new JButton();
        this.txtZoon = new JTextField();
        this.btnZma = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.btnCopy = new JButton();
        this.btnEditar = new JButton();
        this.btnSalvar = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("principal/Formularios_pt_BR");
        this.btnFechar.setText(bundle.getString("MC.btnFchar"));
        this.btnFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MostradorDeCodigo.this.btnFecharActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 575, Short.MAX_VALUE).addComponent(this.btnFechar)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnFechar)));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMargin(new Insets(2, 2, 2, 2));
        this.btnZmn.setIcon(new ImageIcon(this.getClass().getResource("/imagens/zoommenos.png")));
        this.btnZmn.setFocusable(false);
        this.btnZmn.setHorizontalTextPosition(0);
        this.btnZmn.setVerticalTextPosition(3);
        this.btnZmn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MostradorDeCodigo.this.btnZmnActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnZmn);
        this.txtZoon.setEditable(false);
        this.txtZoon.setHorizontalAlignment(0);
        this.txtZoon.setText("12");
        this.txtZoon.setToolTipText(bundle.getString("MostradorDeCodigo.toolTipText"));
        this.txtZoon.setBorder(null);
        this.txtZoon.setCaretPosition(0);
        this.txtZoon.setMinimumSize(new Dimension(30, 14));
        this.txtZoon.setPreferredSize(new Dimension(140, 14));
        this.jToolBar1.add(this.txtZoon);
        this.btnZma.setIcon(new ImageIcon(this.getClass().getResource("/imagens/zoom.png")));
        this.btnZma.setFocusable(false);
        this.btnZma.setHideActionText(true);
        this.btnZma.setHorizontalTextPosition(0);
        this.btnZma.setVerticalTextPosition(3);
        this.btnZma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MostradorDeCodigo.this.btnZmaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnZma);
        this.jToolBar1.add(this.jSeparator1);
        this.btnCopy.setIcon(new ImageIcon(this.getClass().getResource("/imagens/cp.png")));
        this.btnCopy.setFocusable(false);
        this.btnCopy.setHorizontalTextPosition(0);
        this.btnCopy.setPressedIcon(new ImageIcon(this.getClass().getResource("/imagens/cpdim_cp.png")));
        this.btnCopy.setVerticalTextPosition(3);
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MostradorDeCodigo.this.btnCopyActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnCopy);
        this.btnEditar.setIcon(new ImageIcon(this.getClass().getResource("/imagens/green_edit.gif")));
        this.btnEditar.setFocusable(false);
        this.btnEditar.setHorizontalTextPosition(0);
        this.btnEditar.setVerticalTextPosition(3);
        this.btnEditar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MostradorDeCodigo.this.btnEditarActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnEditar);
        this.btnSalvar.setIcon(new ImageIcon(this.getClass().getResource("/imagens/menu_salvarc.png")));
        this.btnSalvar.setFocusable(false);
        this.btnSalvar.setHorizontalTextPosition(0);
        this.btnSalvar.setVerticalTextPosition(3);
        this.btnSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MostradorDeCodigo.this.btnSalvarActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnSalvar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.scrPrincipal).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 160, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, -1, -2).addGap(1, 1, 1).addComponent(this.scrPrincipal, -1, 424, Short.MAX_VALUE).addGap(1, 1, 1).addComponent(this.jPanel2, -2, -1, -2)));
        this.pack();
    }

    private void btnFecharActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void btnZmaActionPerformed(ActionEvent evt) {
        ++this.vlZoom;
        if (this.vlZoom > 72) {
            this.vlZoom = 72;
            return;
        }
        this.txtZoon.setText(String.valueOf(this.vlZoom));
        this.setTexto(this.buffer);
    }

    private void btnZmnActionPerformed(ActionEvent evt) {
        --this.vlZoom;
        if (this.vlZoom < 1) {
            this.vlZoom = 1;
            return;
        }
        this.txtZoon.setText(String.valueOf(this.vlZoom));
        this.setTexto(this.buffer);
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        StringSelection vai = new StringSelection(this.buffer);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(vai, this);
    }

    private void btnEditarActionPerformed(ActionEvent evt) {
        EditorTexto edt = new EditorTexto((Frame)Aplicacao.fmPrincipal.getRootPane().getParent(), true);
        edt.setLocationRelativeTo(Aplicacao.fmPrincipal.getRootPane());
        edt.setTexto(this.buffer);
        edt.setVisible(true);
    }

    private void btnSalvarActionPerformed(ActionEvent evt) {
        File arq;
        String pat = Aplicacao.getDiagramaSelecionado().getArquivo();
        if (pat != null && !pat.isEmpty()) {
            pat = new File(pat).getParentFile().getAbsolutePath() + File.separator + Aplicacao.getDiagramaSelecionado().getNome() + ".sql";
        }
        if ((arq = Dialogos.ShowDlgSaveAsAny(this.getRootPane(), pat)) == null) {
            return;
        }
        if (arq.exists() && Dialogos.ShowMessageConfirm(this.getRootPane(), Editor.fromConfiguracao.getValor("Controler.MSG_QUESTION_REWRITE")) != 0) {
            return;
        }
        try {
            PrintWriter out = new PrintWriter(arq.getAbsoluteFile());
            out.print(this.buffer);
            out.close();
        }
        catch (IOException iOException) {
            BrLogger.Logger("ERROR_DIAGRAMA_SAVE_ANY", iOException.getMessage());
        }
    }

    public String getTexto() {
        return this.buffer;
    }

    public void setTexto(String texto) {
        this.buffer = texto;
        this.lblHtml.setText(this.Formate(texto));
    }

    public DataBaseModel getDbModel() {
        return this.dbModel;
    }

    public void setDbModel(DataBaseModel dbModel) {
        this.dbModel = dbModel;
    }

    private String Formate(String texto) {
        String[] subs = texto.split("\n");
        StringBuilder bu = new StringBuilder();
        String fr = "<font color='red'>";
        String fb = "<font color='blue'>";
        String fimR = "</font>";
        String fimB = "</font>";
        for (String str : subs) {
            int p;
            str = " " + str + " ";
            String tmp = str.toUpperCase();
            for (String rw : this.dbModel.getDataTypes()) {
                p = tmp.indexOf(" " + rw + " ");
                if (p == -1) {
                    p = tmp.indexOf(" " + rw + ",");
                }
                while (p > -1) {
                    tmp = (str = this.injete(str, rw, "<font color='blue'>", "</font>", p)).toUpperCase();
                    if ((p = tmp.indexOf(" " + rw + " ")) != -1) continue;
                    p = tmp.indexOf(" " + rw + ",");
                }
            }
            for (String rw : this.dbModel.getReservedWords()) {
                p = tmp.indexOf(" " + rw + " ");
                if (p == -1) {
                    p = tmp.indexOf(" " + rw + ",");
                }
                while (p > -1) {
                    tmp = (str = this.injete(str, rw, "<font color='red'>", "</font>", p)).toUpperCase();
                    if ((p = tmp.indexOf(" " + rw + " ")) != -1) continue;
                    p = tmp.indexOf(" " + rw + ",");
                }
            }
            str = str.replaceAll("  ", "&nbsp;&nbsp;");
            bu.append("<li>").append(str).append("</li>").append("\n");
        }
        String res = "<html>\n<style>ol {\n    display: block;\n    list-style-type: decimal;\n    margin-top: 1em;\n    margin-bottom: 1em;\n    margin-left:  " + this.vlZoom + ";\n    margin-right: 0;\n    padding-left: " + this.vlZoom + "px;\n}</style><body style=\"font-size: " + this.vlZoom + "\">\n<ol>" + bu.toString() + "</ol>\n</font>\n</body>\n</html>";
        return res;
    }

    public String injete(String origem, String palavra, String inj, String fim, int posi) {
        String res = posi == 0 ? inj + origem.substring(1, palavra.length()) : origem.substring(0, posi + 1) + inj + origem.substring(posi + 1, posi + 1 + palavra.length());
        res = res + fim;
        res = res + origem.substring(posi += (" " + palavra).length());
        return res;
    }

    @Override
    public void lostOwnership(Clipboard clpbrd, Transferable t) {
    }
}

