/*
 * Decompiled with CFR 0.152.
 */
package util;

import controlador.Controler;
import controlador.inspector.InspectorProperty;
import desenho.Elementar;
import desenho.FormaElementar;
import desenho.formas.Forma;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;

public class CopFormatacao {
    private ArrayList<InspectorProperty> copiado = null;
    private Font fonteCopiada = null;
    private Rectangle regiaoCopiada = new Rectangle();
    private final String[] pprts = new String[]{"setGradiente", "setGradienteStartColor", "setGradienteEndColor", "setGradientePinteDetalhe", "setGradienteCorDetalhe", "setGDirecao", "setForeColor", "setAlfa", "setDashed"};

    public void Copiar(FormaElementar ori) {
        this.copiado = this.Resuma(ori.GenerateFullProperty());
        this.fonteCopiada = Elementar.CloneFont(ori.getFont());
    }

    public void Colar(ArrayList<FormaElementar> lst) {
        lst.forEach(it -> this.Colar((FormaElementar)it));
    }

    public void Ajustar(ArrayList<FormaElementar> lst, Controler.menuComandos mm, int dimh, int dimv) {
        this.regiaoCopiada = lst.get(0).getBounds();
        for (int i = 1; i < lst.size(); ++i) {
            if (!(lst.get(i) instanceof Forma) || !((Forma)lst.get(i)).isAlinhavel()) continue;
            this.Ajustar(lst.get(i), mm, dimh, dimv);
        }
    }

    public boolean isCopiado() {
        return this.copiado != null;
    }

    public void Clear() {
        this.fonteCopiada = null;
        this.copiado = null;
    }

    private ArrayList<InspectorProperty> Resuma(ArrayList<InspectorProperty> quem) {
        ArrayList<InspectorProperty> res = new ArrayList<InspectorProperty>();
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.addAll(Arrays.asList(this.pprts));
        quem.stream().filter(it -> tmp.indexOf(it.property) > -1).forEach(it -> res.add((InspectorProperty)it));
        return res;
    }

    public void Colar(FormaElementar var) {
        if (this.copiado == null) {
            return;
        }
        if (var instanceof Forma && ((Forma)var).editFonte) {
            var.setFont(this.fonteCopiada);
        }
        if (this.copiado.isEmpty()) {
            return;
        }
        ArrayList<InspectorProperty> dest = this.Resuma(var.GenerateFullProperty());
        ArrayList<InspectorProperty> aColar = new ArrayList<InspectorProperty>();
        ArrayList tmp = new ArrayList();
        dest.forEach(it -> tmp.add(it.property));
        this.copiado.stream().filter(c -> tmp.indexOf(c.property) > -1).forEach(ac -> aColar.add((InspectorProperty)ac));
        aColar.forEach(ac -> var.getMaster().ColeFormatacao(var, (InspectorProperty)ac, ac.valor_string));
    }

    public void Ajustar(FormaElementar var, Controler.menuComandos cmd, int dimH, int dimV) {
        ((Forma)var).HidePontos(true);
        switch (cmd) {
            case cmdDimPastLeft: {
                int x = this.regiaoCopiada.x - var.getLeft();
                var.DoMove(x, 0);
                break;
            }
            case cmdDimPastTop: {
                int y = this.regiaoCopiada.y - var.getTop();
                var.DoMove(0, y);
                break;
            }
            case cmdDimPastRight: {
                int r = this.regiaoCopiada.width + this.regiaoCopiada.x - var.getLeftWidth();
                var.DoMove(r, 0);
                break;
            }
            case cmdDimPastBottom: {
                int b = this.regiaoCopiada.height + this.regiaoCopiada.y - var.getTopHeight();
                var.DoMove(0, b);
                break;
            }
            case cmdDimPastWidth: {
                ((Forma)var).ReciveFormaResize(new Rectangle(0, 0, var.getWidth() - this.regiaoCopiada.width, 0));
                break;
            }
            case cmdDimPastHeight: {
                ((Forma)var).ReciveFormaResize(new Rectangle(0, 0, 0, var.getHeight() - this.regiaoCopiada.height));
                break;
            }
            case cmdDimAlignH: {
                int hh = dimH + this.regiaoCopiada.x + this.regiaoCopiada.width - var.getLeft();
                int yy = this.regiaoCopiada.y - var.getTop() + (this.regiaoCopiada.height - var.getHeight()) / 2;
                var.DoMove(hh, yy);
                this.regiaoCopiada = new Rectangle(var.getBounds());
                break;
            }
            case cmdDimAlignV: {
                int vv = dimV + this.regiaoCopiada.y + this.regiaoCopiada.height - var.getTop();
                int xx = this.regiaoCopiada.x - var.getLeft() + (this.regiaoCopiada.width - var.getWidth()) / 2;
                var.DoMove(xx, vv);
                this.regiaoCopiada = new Rectangle(var.getBounds());
            }
        }
        var.Reposicione();
        var.Reenquadre();
        ((Forma)var).HidePontos(false);
    }
}

