/*
 * Decompiled with CFR 0.152.
 */
package diagramas.logico;

import controlador.Diagrama;
import controlador.Editor;
import controlador.apoios.TreeItem;
import controlador.inspector.InspectorProperty;
import desenho.ElementarEvento;
import desenho.FormaElementar;
import desenho.formas.Forma;
import desenho.linhas.PontoDeLinha;
import desenho.preDiagrama.baseDrawerFromForma;
import diagramas.logico.Campo;
import diagramas.logico.Constraint;
import diagramas.logico.DiagramaLogico;
import diagramas.logico.LogicoLinha;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import principal.Aplicacao;
import util.DesenhadorDeTexto;
import util.Dialogos;
import util.XMLGenerate;

public class Tabela
extends baseDrawerFromForma {
    private static final long serialVersionUID = -8275314691624584199L;
    private ArrayList<Campo> Campos = new ArrayList();
    private Campo campoSelecionado = null;
    private ArrayList<Constraint> Constraints = new ArrayList();
    private Constraint constraintSelecionado = null;
    protected final String COMM_EDT_CMPS = "edt_campos";
    protected final String COMM_EDT_CMPS_TP = "edt_campos_tipo";
    private final int EDITOR_CAMPOS = 200317;
    private final int EDITOR_CAMPOS_TP = 180717;
    private final int PRINT_DDL = 310317;
    private final int DESCE_CONSTAN = 110417;
    private final int SOBE_CONSTAN = -110417;
    private final int DESCE_CAMPO = 1;
    private final int SOBE_CAMPO = -1;
    protected final String COMM_RI = "tabela.constraint";
    protected final String COMM_RI_PK = "constraint.key";
    public final String COMM_RI_FK = "constraint.fkey";
    protected final String COMM_RI_UN = "constraint.unique";
    protected int cmpAltura = 22;
    final int cmpAlturaPadrao = 22;
    private boolean showInPlain = false;
    private boolean showDDL = false;
    private boolean plainIR = true;
    private transient DesenhadorDeTexto ddl_desenhador = null;
    public final int DDL_PEGAR_TABELAS = 0;
    public final int DDL_PEGAR_INTEGRIDADE = 1;
    public final int DDL_PEGAR_TUDO = 2;
    public final int DDL_PEGAR_INTEGRIDADE_PK_UN_NOMEADAS = 3;
    public final int DDL_PEGAR_INTEGRIDADE_FK = 4;
    private int alturaDDL = 0;
    private int altura = 0;
    final String imgk = "diagrama.Campo_Key.img";
    final String imgfk = "diagrama.Campo_Fkey.img";
    final String imgkfk = "diagrama.Campo_KeyFkey.img";
    final String imgunfk = "diagrama.Constraint_UNFK.img";
    final String imgun = "diagrama.Constraint_UN.img";
    private final int piso = 12;
    private boolean autosize = true;
    private transient boolean needRecalc = false;
    public final int CODE_EDT_CMP = 3;
    public final int CODE_EDT_CMP_TP = 5;
    public final int CODE_DDL = 6;
    public final int CODE_SOBE = 7;
    public final int CODE_DESCE = 8;
    public final int CODE_DEL_CMP_CONST = 9;
    public static final int MSG_IR_CHANGE_ADD_CMP = 2;
    public static final int MSG_IR_CHANGE_DEL_CMP = 3;
    public static final int MSG_IR_PREDELETE = 4;
    public static final int MSG_CMP_DELETE = 5;
    public static final int MSG_CMP_CHANGE_TIPO = 6;
    private boolean mostrarConstraints = true;
    private transient Constraint constraintRoqued = null;

    public Tabela(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.Inicie();
    }

    public Tabela(Diagrama modelo) {
        super(modelo);
        this.Inicie();
    }

    private void Inicie() {
        this.setAlfa(0.25f);
        this.setGradiente(true);
        this.showOrgDiag = true;
        this.INI_ORGDIAG = this.roundrect / 2;
    }

    @Override
    public ArrayList<Integer> getAncorasCode() {
        ArrayList<Integer> res = super.getAncorasCode();
        Integer[] ancorasCode = new Integer[]{3, 5, 6, 7, 8, 9};
        res.addAll(Arrays.asList(ancorasCode));
        return res;
    }

    public final ArrayList<Campo> getCampos() {
        return this.Campos;
    }

    public Campo getCampoSelecionado() {
        return this.campoSelecionado;
    }

    public void setCampoSelecionado(Campo selecionado) {
        if (this.campoSelecionado == selecionado) {
            return;
        }
        if (this.campoSelecionado != null) {
            this.campoSelecionado.setSelecionado(false);
        }
        this.campoSelecionado = selecionado;
        if (this.campoSelecionado != null) {
            this.campoSelecionado.setSelecionado(true);
            this.setConstraintSelecionado(null);
        }
        if (this.getMaster().getSelecionado() == this) {
            this.getMaster().PerformInspector();
        }
        this.InvalidateArea();
    }

    public int getCampoSelectedIndex() {
        return this.Campos.indexOf(this.getCampoSelecionado());
    }

    public final ArrayList<Constraint> getConstraints() {
        return this.Constraints;
    }

    public Constraint getConstraintSelecionado() {
        return this.constraintSelecionado;
    }

    public void setConstraintSelecionado(Constraint selecionado) {
        if (this.constraintSelecionado == selecionado) {
            return;
        }
        if (this.constraintSelecionado != null) {
            this.constraintSelecionado.setSelecionado(false);
        }
        this.constraintSelecionado = selecionado;
        if (this.constraintSelecionado != null) {
            this.constraintSelecionado.setSelecionado(true);
            this.setCampoSelecionado(null);
        }
        if (this.getMaster().getSelecionado() == this) {
            this.getMaster().PerformInspector();
        }
        this.InvalidateArea();
    }

    public int getConstraintSelectedIndex() {
        return this.Constraints.indexOf(this.getConstraintSelecionado());
    }

    public void setCampoSelectedIndex(int selectedIndex) {
        if (selectedIndex > -1 && selectedIndex < this.Campos.size()) {
            this.setCampoSelecionado(this.Campos.get(selectedIndex));
        } else {
            this.setCampoSelecionado(null);
        }
    }

    public void setConstraintSelectedIndex(int selectedIndex) {
        if (selectedIndex > -1 && selectedIndex < this.Constraints.size()) {
            this.setConstraintSelecionado(this.Constraints.get(selectedIndex));
        } else {
            this.setConstraintSelecionado(null);
        }
    }

    public ArrayList<Tabela> getListaDeTabelasLigadas() {
        ArrayList<Tabela> res = new ArrayList<Tabela>();
        res.add(this);
        this.getListaDeFormasLigadas().stream().filter(fe -> fe instanceof Tabela).map(fe -> (Tabela)fe).forEach(fe -> res.add((Tabela)fe));
        return res;
    }

    public ArrayList<String> getStrListaDeTabelas(ArrayList<Tabela> lst) {
        ArrayList<String> res = new ArrayList<String>();
        lst.stream().forEach(fe -> res.add(fe.getTexto()));
        return res;
    }

    public ArrayList<String> getListaDeCampos() {
        ArrayList<String> res = new ArrayList<String>();
        this.Campos.stream().forEach(fe -> res.add((fe.isKey() ? "(*) " : "") + fe.getTexto()));
        return res;
    }

    @Override
    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> GP) {
        ArrayList<InspectorProperty> res = GP;
        if (this.getCampoSelecionado() == null && this.getConstraintSelecionado() == null) {
            res.add(InspectorProperty.PropertyFactorySeparador("tabela.exibicao"));
            res.add(InspectorProperty.PropertyFactorySN("tabela.autosize", "setAutosize", this.isAutosize()));
            res.add(InspectorProperty.PropertyFactorySN("tabela.showinplain", "setShowInPlain", this.isShowInPlain()));
            res.add(InspectorProperty.PropertyFactorySN("tabela.showddl", "setShowDDL", this.isShowDDL()));
            res.add(InspectorProperty.PropertyFactorySN("constraints.mostrar", "setMostrarConstraints", this.isMostrarConstraints()).AddCondicaoForTrue(new String[]{"setPlainIR"}));
            res.add(InspectorProperty.PropertyFactorySN("tabela.ir.plain", "setPlainIR", this.isPlainIR()));
            res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "tabela.printddl").setTag(310317));
        }
        if (this.getCampoSelecionado() != null) {
            Campo sel = this.getCampoSelecionado();
            res.clear();
            sel.CompleteGenerateProperty(res);
        } else if (this.getConstraintSelecionado() != null) {
            res.clear();
            this.getConstraintSelecionado().CompleteGenerateProperty(res);
        }
        if (this.getCampos().size() > 1 && this.getConstraintSelecionado() == null) {
            res.add(InspectorProperty.PropertyFactorySeparador("tabela.campos", true));
            int i = 11;
            for (Campo campo : this.getCampos()) {
                if (!campo.isSelecionado()) {
                    res.add(InspectorProperty.PropertyFactoryCommandPlain(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "tabela.campo", "[" + campo.getTexto() + "]").setTag(i++));
                    continue;
                }
                ++i;
            }
        }
        if (this.getConstraints().size() > 1 && this.getCampoSelecionado() == null) {
            res.add(InspectorProperty.PropertyFactorySeparador("tabela.constraint", true));
            int i = 1001;
            for (Constraint constraint : this.getConstraints()) {
                if (!constraint.isSelecionado()) {
                    res.add(InspectorProperty.PropertyFactoryCommandPlain(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "tabela.constraint", "[" + constraint.getNomeFormatado() + "]").setTag(i++));
                    continue;
                }
                ++i;
            }
        }
        if (this.getCampoSelecionado() == null && this.getConstraintSelecionado() == null) {
            super.CompleteGenerateProperty(GP);
        }
        res.add(InspectorProperty.PropertyFactorySeparador("tabela.edtitores", true));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "constraint.key").setTag(120420170));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "constraint.unique").setTag(120420172));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "constraint.fkey").setTag(120420171));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "edt_campos").setTag(200317));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "edt_campos_tipo").setTag(180717));
        return GP;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Autosize", this.isAutosize()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Gradiente", this.isGradiente()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteStartColor", this.getGradienteStartColor()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteEndColor", this.getGradienteEndColor()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "GDirecao", this.getGDirecao()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Alfa", (int)(100.0f * this.getAlfa())));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "ShowDDL", this.isShowDDL()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "ShowInPlain", this.isShowInPlain()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "MostrarConstraints", this.isMostrarConstraints()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "PlainIR", this.isPlainIR()));
        Element sbCampos = doc.createElement("Campos");
        this.getCampos().stream().forEach(c -> c.ToXmlValores(doc, sbCampos));
        me.appendChild(sbCampos);
        Element sbConstraints = doc.createElement("Constraints");
        this.getConstraints().stream().forEach(c -> c.ToXmlValores(doc, sbConstraints));
        me.appendChild(sbConstraints);
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        Node tmp;
        Serializable c;
        int i;
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        this.setAutosize(XMLGenerate.getValorBooleanFrom(me, "Autosize"));
        this.setPlainIR(XMLGenerate.getValorBooleanFrom(me, "PlainIR"));
        int l = XMLGenerate.getValorIntegerFrom(me, "GDirecao");
        if (l != -1) {
            this.setGDirecao(l);
        }
        if ((l = XMLGenerate.getValorIntegerFrom(me, "Alfa")) != -1) {
            this.SetAlfa(l);
        }
        this.setGradiente(XMLGenerate.getValorBooleanFrom(me, "Gradiente"));
        Color cor = XMLGenerate.getValorColorFrom(me, "GradienteStartColor");
        if (cor != null) {
            this.setGradienteStartColor(cor);
        }
        if ((cor = XMLGenerate.getValorColorFrom(me, "GradienteEndColor")) != null) {
            this.setGradienteEndColor(cor);
        }
        this.setShowDDL(XMLGenerate.getValorBooleanFrom(me, "ShowDDL"));
        this.setShowInPlain(XMLGenerate.getValorBooleanFrom(me, "ShowInPlain"));
        this.setMostrarConstraints(XMLGenerate.getValorBooleanFrom(me, "MostrarConstraints"));
        NodeList ptLst = me.getElementsByTagName("Campos");
        Element pontos = (Element)ptLst.item(0);
        ptLst = pontos.getChildNodes();
        for (i = 0; i < ptLst.getLength(); ++i) {
            c = new Campo(this);
            tmp = ptLst.item(i);
            if (tmp.getNodeType() != 1) continue;
            ((Campo)c).LoadFromXML((Element)tmp, colando);
        }
        ptLst = me.getElementsByTagName("Constraints");
        pontos = (Element)ptLst.item(0);
        ptLst = pontos.getChildNodes();
        for (i = 0; i < ptLst.getLength(); ++i) {
            c = new Constraint(this);
            tmp = ptLst.item(i);
            if (tmp.getNodeType() != 1) continue;
            ((Constraint)c).LoadFromXML((Element)tmp, colando);
        }
        return true;
    }

    @Override
    public boolean CommitXML(Element me, HashMap<Element, FormaElementar> mapa) {
        if (!super.CommitXML(me, mapa)) {
            return false;
        }
        Element constraits = XMLGenerate.FindByNodeName(me, "Constraints");
        NodeList ptLst = constraits.getChildNodes();
        int j = 0;
        for (int i = 0; i < ptLst.getLength(); ++i) {
            Constraint c = this.getConstraints().get(j);
            Node tmp = ptLst.item(i);
            if (tmp.getNodeType() != 1) continue;
            ++j;
            if (c.CommitXML((Element)tmp, mapa)) continue;
            return false;
        }
        this.needRecalc = true;
        return true;
    }

    public Campo Add(String texto) {
        Campo c = new Campo(this);
        c.setTexto(this.NomeieCampo(texto));
        if (this.isAutosize()) {
            this.needRecalc = true;
        }
        this.setCampoSelecionado(c);
        return c;
    }

    public boolean isShowInPlain() {
        return this.showInPlain;
    }

    public void setShowInPlain(boolean showInPlain) {
        this.showInPlain = showInPlain;
        if (!showInPlain && this.isAutosize()) {
            this.needRecalc = true;
        }
        this.InvalidateArea();
    }

    public boolean isShowDDL() {
        return this.showDDL;
    }

    public void setShowDDL(boolean showDDL) {
        this.showDDL = showDDL;
        if (this.isAutosize()) {
            this.needRecalc = true;
        }
        this.InvalidateArea();
    }

    public boolean isPlainIR() {
        return this.plainIR;
    }

    public void setPlainIR(boolean plainIR) {
        if (this.plainIR == plainIR) {
            return;
        }
        this.plainIR = plainIR;
        this.InvalidateArea();
    }

    private void FillCampos(Graphics2D g, Rectangle r, boolean normal) {
        Composite originalComposite = g.getComposite();
        float alfa = 1.0f - this.getAlfa();
        g.setComposite(AlphaComposite.getInstance(3, alfa));
        Paint bkpp = g.getPaint();
        g.setColor(this.getMaster().getBackground());
        if (!normal) {
            if (this.isGradiente()) {
                g.setColor(this.getGradienteStartColor());
            } else {
                g.setColor(this.getForeColor());
            }
        }
        g.setComposite(AlphaComposite.getInstance(3, this.getAlfa()));
        g.fill(r);
        g.setPaint(bkpp);
        g.setComposite(originalComposite);
    }

    public void setRoqued(boolean sn, LogicoLinha linha) {
        this.getConstraints().stream().filter(c -> c.getLigacao() == linha && c.getTipo() == Constraint.CONSTRAINT_TIPO.tpFK).forEach(co -> {
            co.roqued = sn;
            co.getCamposDeDestino().stream().forEach(c -> {
                c.roqued = sn;
            });
            co.getCamposDeOrigem().stream().filter(c -> c != null).forEach(c -> {
                c.roqued = sn;
            });
            if (co.getTabelaDeOrigem() != null) {
                co.getConstraintOrigem().roqued = sn;
                co.getTabelaDeOrigem().repaint();
            }
            co.getTabela().repaint();
        });
    }

    @Override
    public void DoPaint(Graphics2D g) {
        Composite ori = g.getComposite();
        Paint bkp_paint = g.getPaint();
        Rectangle rgn = g.getClipBounds();
        super.DoPaint(g);
        Composite orig = g.getComposite();
        Font bkpf = g.getFont();
        g.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), this.getFont().getSize() - 2));
        FontMetrics fm = g.getFontMetrics();
        int y = this.margemTitulo + 1;
        Rectangle r = new Rectangle(this.getLeft() + 1, this.getTop() + y + 1, this.getWidth() - 1, this.getHeight() - y - 12 - 2);
        g.clipRect(r.x - 1, r.y, r.width + 1, r.height + 2);
        g.setComposite(ori);
        int bkpAltura = this.altura;
        this.cmpAltura = g.getFontMetrics(g.getFont()).getHeight() + 4 + 4;
        this.cmpAltura = Math.max(this.cmpAltura, 22);
        if (!this.isShowInPlain()) {
            this.altura = 0;
            for (Campo campo : this.getCampos()) {
                campo.Paint(1, y, this.cmpAltura, g);
                if (campo.roqued) {
                    this.drawRoqued(campo.area, g);
                }
                y += this.cmpAltura;
                this.altura += this.cmpAltura;
            }
        } else {
            this.altura = 0;
            g.setPaint(this.getForeColor());
            this.FillCampos(g, r, true);
            int sp = 8;
            Rectangle rectangle = fm.getStringBounds(this.getTexto() + " {", g).getBounds();
            this.altura = rectangle.height + sp;
            g.drawString(this.getTexto() + " {", this.getLeft() + 2, (y += rectangle.height + sp) + this.getTop());
            int proxW = rectangle.width + 2;
            Rectangle rtmp = fm.getStringBounds(", ", g).getBounds();
            int larg = rtmp.width;
            int tl = this.getCampos().size() - 1;
            int i = 0;
            for (Campo c : this.getCampos()) {
                boolean s2 = i != tl;
                Rectangle rt2 = fm.getStringBounds(c.getTexto() + (s2 ? ", " : ""), g).getBounds();
                int imgl = 20;
                int w = rt2.width + (c.roqued ? 20 : 0);
                if (proxW + w > this.getWidth()) {
                    y += rt2.height + sp;
                    this.altura += rectangle.height + sp;
                    proxW = 20;
                }
                c.area = new Rectangle(this.getLeft() + proxW, this.getTop() + y - rt2.height + 2, w + (s2 ? -larg : 0), rt2.height + 4);
                if (c.isSelecionado()) {
                    this.FillCampos(g, c.area, false);
                }
                if (c.roqued) {
                    this.drawRoqued(c.area, g);
                }
                g.drawString(c.getTexto() + (s2 ? ", " : ""), this.getLeft() + proxW, y + this.getTop());
                if (c.isKey()) {
                    g.drawLine(c.area.x, c.area.y, c.area.x + c.area.width - 2, c.area.y);
                }
                if (c.isFkey()) {
                    g.drawLine(c.area.x, c.area.y + rt2.height, c.area.x + c.area.width - 2, c.area.y + rt2.height);
                }
                proxW += w;
                ++i;
            }
            Rectangle rectangle2 = fm.getStringBounds("}", g).getBounds();
            if (proxW + rectangle2.width >= this.getWidth()) {
                y += rectangle2.height + sp;
                this.altura += rectangle2.height + sp;
                proxW = 20;
            }
            g.drawString("}", this.getLeft() + proxW, y + this.getTop());
            y += rectangle2.height;
            this.altura += rectangle2.height;
        }
        if (this.isMostrarConstraints() && !this.getConstraints().isEmpty()) {
            g.setPaint(this.getCorBorda());
            g.setComposite(orig);
            g.drawLine(this.getLeft() + 1, this.getTop() + (y += 2), this.getLeftWidth(), this.getTop() + y);
            y += 2;
            this.altura += 4;
            g.setComposite(ori);
            if (this.isPlainIR()) {
                int lar = 1;
                for (Constraint c : this.getConstraints()) {
                    c.Paint(lar, y, g);
                    lar += this.cmpAltura + 2;
                }
                int n = this.getWidth() - lar - 1;
                if (n > 1) {
                    Rectangle rx = new Rectangle(this.getLeft() + lar, this.getTop() + y, n, this.cmpAltura);
                    float alfa = 1.0f - this.getAlfa();
                    Composite originalComposite = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, alfa));
                    Paint bkpp = g.getPaint();
                    g.setColor(this.getMaster().getBackground());
                    g.fill(rx);
                    g.setComposite(originalComposite);
                    g.setColor(this.getForeColor());
                    g.setPaint(bkpp);
                }
                y += this.cmpAltura;
                this.altura += this.cmpAltura;
            } else {
                for (Constraint constraint : this.getConstraints()) {
                    constraint.Paint(1, y, this.cmpAltura, g);
                    y += this.cmpAltura;
                    this.altura += this.cmpAltura;
                }
            }
        }
        if (bkpAltura != this.altura) {
            this.needRecalc = true;
        }
        if (this.isShowDDL()) {
            g.setPaint(this.getCorBorda());
            g.setComposite(orig);
            g.drawLine(this.getLeft() + 1, this.getTop() + (y += 2), this.getLeftWidth(), this.getTop() + y);
            g.setComposite(ori);
            g.setPaint(this.getForeColor());
            int bkpADDL = this.alturaDDL;
            Rectangle rectangle = fm.getStringBounds("C", g).getBounds();
            r = new Rectangle(this.getLeft() + 2, this.getTop() + y + rectangle.height / 2, this.getWidth() - 4, this.getDDL_Desenhador().getMaxHeigth() + rectangle.height);
            ArrayList<String> ls = new ArrayList<String>();
            this.DDLGenerate(ls, 2);
            String tmp = ls.stream().map(s -> "\n" + s).reduce("", String::concat);
            this.getDDL_Desenhador().setFont(g.getFont());
            this.getDDL_Desenhador().PinteTexto(g, this.getForeColor(), r, tmp);
            if (r.height != this.getDDL_Desenhador().getMaxHeigth() + rectangle.height) {
                r = new Rectangle(this.getLeft() + 2, this.getTop() + y + rectangle.height / 2, this.getWidth() - 4, this.getDDL_Desenhador().getMaxHeigth() + rectangle.height);
                this.getDDL_Desenhador().PinteTexto(g, this.getForeColor(), r, tmp);
            }
            this.alturaDDL = this.getDDL_Desenhador().getMaxHeigth() + 12;
            if (bkpADDL != this.alturaDDL) {
                this.needRecalc = true;
            }
        } else {
            if (this.alturaDDL != 0) {
                this.needRecalc = true;
            }
            this.alturaDDL = 0;
        }
        g.setFont(bkpf);
        if (this.needRecalc) {
            this.needRecalc = false;
            this.ReCalculaAltura();
        }
        g.setComposite(ori);
        g.setPaint(bkp_paint);
        g.setClip(rgn);
    }

    public void drawRoqued(Rectangle area, Graphics2D g) {
        ImageIcon img = Editor.fromControler().ImagemDeDiagrama.get("diagrama.Constraint_see.img");
        int imgl = 16;
        if (this.getWidth() > imgl && img != null) {
            int x = (area.height - imgl) / 2;
            g.drawImage(img.getImage(), area.x + area.width - imgl - 2, area.y + x, imgl, imgl, null);
            Stroke bkps = g.getStroke();
            g.setStroke(new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f));
            g.drawRoundRect(area.x + 1, area.y + 1, area.width - 2, area.height - 2, 4, 4);
            g.setStroke(bkps);
        }
    }

    private DesenhadorDeTexto getDDL_Desenhador() {
        if (this.ddl_desenhador != null) {
            return this.ddl_desenhador;
        }
        this.ddl_desenhador = new DesenhadorDeTexto();
        return this.ddl_desenhador;
    }

    public void DDLGenerate(List<String> texto, int ddl_pegar) {
        String createTable = "CREATE TABLE ";
        String pktxt = "PRIMARY KEY";
        String utxt = "UNIQUE";
        String em_branco = "    ";
        if (ddl_pegar == 2 || ddl_pegar == 0) {
            String tmp = "CREATE TABLE " + this.getPrefixo() + this.getTexto() + " (";
            texto.add(tmp);
            int total_campos = this.getCampos().size() - 1;
            Constraint pk = this.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpPK).findFirst().orElse(null);
            boolean nomeada = pk != null && pk.isNomeada();
            boolean chaveSimples = pk != null && pk.getCamposDeOrigem().size() == 1 && !nomeada;
            boolean pk_noNome_simples = pk != null && !nomeada && !chaveSimples;
            List uniao_noNome_complex = this.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpUNIQUE && !c.isNomeada() && c.getCamposDeOrigem().size() > 1).collect(Collectors.toList());
            boolean u_noNomea_complex = !uniao_noNome_complex.isEmpty();
            int contador_campos = 0;
            for (Campo c2 : this.getCampos()) {
                boolean eh_ultimo_campo = contador_campos == total_campos;
                tmp = c2.getTexto() + (c2.getTipo().isEmpty() ? "" : " " + c2.getTipo()) + (!c2.getComplemento().isEmpty() ? " " + c2.getComplemento() : "");
                if (c2.isKey() && chaveSimples) {
                    tmp = tmp + " PRIMARY KEY";
                }
                if (c2.isUnique()) {
                    List<Constraint> ux = this.getPresentAsUN(c2);
                    tmp = ux.stream().filter(u -> !u.isNomeada() && u.getCamposDeOrigem().size() == 1).map(_item -> " UNIQUE").reduce(tmp, String::concat);
                }
                if (eh_ultimo_campo) {
                    if (pk_noNome_simples || u_noNomea_complex) {
                        tmp = tmp + ",";
                    }
                } else {
                    tmp = tmp + ",";
                }
                texto.add("    " + tmp);
                ++contador_campos;
            }
            if (pk_noNome_simples) {
                texto.add("    " + pk.getDDL() + (u_noNomea_complex ? "," : ""));
            }
            if (u_noNomea_complex) {
                int total_uniao = uniao_noNome_complex.size();
                int contador_uniao = 0;
                for (Constraint c3 : uniao_noNome_complex) {
                    texto.add("    " + c3.getDDL() + (++contador_uniao != total_uniao ? "," : ""));
                }
            }
            if (texto.size() == 1) {
                texto.add(" ");
            }
            texto.add(")" + this.getSepadorSql());
        }
        if (ddl_pegar == 2 || ddl_pegar == 1 || ddl_pegar == 3) {
            this.getConstraints().stream().filter(constr -> constr.getTipo() != Constraint.CONSTRAINT_TIPO.tpFK && constr.isNomeada()).forEach(constr -> {
                texto.add(" ");
                this.AddSubsDDL(texto, constr.getDDL(), "    ");
            });
        }
        if (ddl_pegar == 2 || ddl_pegar == 1 || ddl_pegar == 4) {
            this.getConstraints().stream().filter(constr -> constr.getTipo() == Constraint.CONSTRAINT_TIPO.tpFK).forEach(constr -> {
                texto.add(" ");
                this.AddSubsDDL(texto, constr.getDDL(), "    ");
            });
        }
    }

    private void AddSubsDDL(List<String> texto, String valor, String espaco) {
        String[] arr = valor.split("\n");
        String ax = "";
        for (String a : arr) {
            texto.add(ax + a);
            ax = espaco;
        }
    }

    @Override
    public void ReciveNotificacao(ElementarEvento evt) {
        super.ReciveNotificacao(evt);
        int i = evt.getCod();
        if (i == 1) {
            if (evt.getSender() instanceof Tabela) {
                Tabela origem = (Tabela)evt.getSender();
                this.getConstraints().stream().filter(c -> c.getTabelaDeOrigem() == origem).forEach(c -> c.setConstraintOrigem(null));
            }
        } else if (i == 7) {
            this.InvalidateArea();
        }
    }

    public void RemoveCampo(int idx) {
        if (idx > -1 && idx < this.getCampos().size()) {
            this.RemoveCampo(this.getCampos().get(idx));
        }
    }

    public void RemoveCampo(Campo campo) {
        if (campo == this.getCampoSelecionado()) {
            this.setCampoSelecionado(null);
        }
        int i = 0;
        while (i < this.getConstraints().size()) {
            boolean deve;
            Constraint onstr = this.getConstraints().get(i);
            boolean bl = deve = onstr.getCamposDeOrigem().indexOf(campo) > -1 || onstr.getCamposDeDestino().indexOf(campo) > -1;
            if (deve) {
                onstr.RemoveFromOrigem(campo);
                if (this.AnaliseAndRemove(onstr)) continue;
                ++i;
                continue;
            }
            ++i;
        }
        this.Campos.remove(campo);
        this.NotifiqueIR(null, 5, campo);
        if (this.isAutosize()) {
            this.needRecalc = true;
            this.InvalidateArea();
        }
        this.DoMuda();
    }

    public boolean AnaliseAndRemove(Constraint constr) {
        if (constr.getCamposDeOrigem().isEmpty() && constr.getCamposDeDestino().isEmpty()) {
            this.InternalRemoveConstraint(constr);
            return true;
        }
        return false;
    }

    public void RemoveConstraint(Constraint constr) {
        this.InternalRemoveConstraint(constr);
        this.DoMuda();
    }

    protected void InternalRemoveConstraint(Constraint constr) {
        if (constr == this.getConstraintSelecionado()) {
            this.setConstraintSelecionado(null);
        }
        switch (constr.getTipo()) {
            case tpPK: {
                constr.getCamposDeOrigem().stream().forEach(cmp -> cmp.SetKey(false));
                break;
            }
            case tpUNIQUE: {
                constr.getCamposDeOrigem().forEach(cmp -> cmp.SetUnique(this.getPresentAsUN((Campo)cmp).size() > 1));
                break;
            }
            case tpFK: {
                if (constr.getLigacao() != null) {
                    constr.getLigacao().PerformRoqued(false);
                }
                constr.getCamposDeDestino().stream().filter(cmp -> cmp != null).forEach(cmp -> cmp.SetFkey(false));
            }
        }
        this.NotifiqueIR(constr, 4, null);
        constr.Clear();
        this.Constraints.remove(constr);
        this.SendNotificacao(constr, 8);
        if (this.isAutosize()) {
            this.needRecalc = true;
            this.InvalidateArea();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (this.isSelecionado()) {
            this.SelecioneCampoConstraint(e);
        }
    }

    private void SelecioneCampoConstraint(MouseEvent e) {
        for (Campo campo : this.getCampos()) {
            if (!campo.isMe(e.getPoint())) continue;
            this.setCampoSelecionado(campo);
            return;
        }
        this.setCampoSelecionado(null);
        for (Constraint constraint : this.getConstraints()) {
            if (!constraint.isMe(e.getPoint())) continue;
            this.setConstraintSelecionado(constraint);
            return;
        }
        this.setConstraintSelecionado(null);
    }

    public Campo getCampoFromPoint(Point p) {
        for (Campo c : this.getCampos()) {
            if (!c.isMe(p)) continue;
            return c;
        }
        return null;
    }

    public Constraint getConstraintFromPoint(Point p) {
        for (Constraint c : this.getConstraints()) {
            if (!c.isMe(p)) continue;
            return c;
        }
        return null;
    }

    public String NomeieCampo(String nome) {
        if (nome.equals("_")) {
            return "_";
        }
        ArrayList<Campo> campos = this.getCampos();
        ArrayList nomes = new ArrayList();
        campos.stream().forEach(c -> nomes.add(c.getTexto()));
        int i = 0;
        String tmp = nome;
        while (nomes.indexOf(tmp) > -1) {
            tmp = nome + "_" + String.valueOf(++i);
        }
        return tmp;
    }

    public void Add(Campo aThis) {
        this.getCampos().add(aThis);
        if (this.isAutosize()) {
            this.needRecalc = true;
        }
    }

    public void Add(Constraint aThis) {
        this.getConstraints().add(aThis);
        if (this.isAutosize()) {
            this.needRecalc = true;
        }
    }

    private void ReCalculaAltura() {
        if (!this.isAutosize()) {
            return;
        }
        int topo = this.margemTitulo + 1;
        int tam = this.altura + topo + 12 + this.alturaDDL;
        if (tam != this.getHeight() && tam > 50) {
            boolean sn = this.autosize;
            this.autosize = false;
            this.ReciveFormaResize(new Rectangle(0, 0, 0, this.getHeight() - tam));
            this.autosize = sn;
            this.DoRaizeReenquadreReposicione();
            this.calculePontos();
            this.SendNotificacao(4);
            if (this.isSelecionado()) {
                this.Reposicione();
            }
            this.repaint();
        }
    }

    public boolean isAutosize() {
        return this.autosize;
    }

    public void setAutosize(boolean autosize) {
        if (this.autosize == autosize) {
            return;
        }
        this.autosize = autosize;
        if (this.isAutosize()) {
            this.needRecalc = true;
        }
        this.InvalidateArea();
    }

    @Override
    public void ReciveFormaResize(Rectangle ret) {
        if (!this.isAutosize()) {
            super.ReciveFormaResize(ret);
        } else {
            Rectangle rec = new Rectangle(ret.x, ret.y, ret.width, 0);
            super.ReciveFormaResize(rec);
        }
    }

    @Override
    public void DoAnyThing(int Tag) {
        super.DoAnyThing(Tag);
        if (Tag == 120420181) {
            Constraint co = this.getPresentAsFK(this.campoSelecionado);
            this.setConstraintSelecionado(co);
            ((DiagramaLogico)this.getMaster()).LancarEditorDeIR(Tag - 10);
            return;
        }
        if (Tag == 120420170 || Tag == 120420171 || Tag == 120420172) {
            ((DiagramaLogico)this.getMaster()).LancarEditorDeIR(Tag);
            return;
        }
        if (Tag == 200317) {
            ((DiagramaLogico)this.getMaster()).LancarEditorDeCampos();
            return;
        }
        if (Tag == 180717) {
            ((DiagramaLogico)this.getMaster()).LancarEditorDeCamposTP();
            return;
        }
        if (Tag == 310317) {
            this.PrintDDL();
            return;
        }
        if ((Tag == 110417 || Tag == -110417) && this.getConstraintSelecionado() != null) {
            int idxc = this.getConstraints().indexOf(this.getConstraintSelecionado());
            idxc = Tag == -110417 ? --idxc : ++idxc;
            this.getConstraints().remove(this.getConstraintSelecionado());
            this.getConstraints().add(idxc, this.constraintSelecionado);
            this.DoMuda();
            this.InvalidateArea();
            return;
        }
        if (Tag > 10 && Tag < 2000) {
            int i;
            if (Tag > 10 && (i = Tag - 11) < this.getCampos().size()) {
                this.setCampoSelectedIndex(i);
                return;
            }
            if (Tag > 1000 && (i = Tag - 1001) < this.getConstraints().size()) {
                this.setConstraintSelectedIndex(i);
                return;
            }
        }
        if (Tag == -1 || Tag == 1) {
            if (this.getCampoSelecionado() == null) {
                return;
            }
            int idx = this.getCampos().indexOf(this.getCampoSelecionado());
            idx = Tag == -1 ? --idx : ++idx;
            this.getCampos().remove(this.getCampoSelecionado());
            this.getCampos().add(idx, this.campoSelecionado);
            this.DoMuda();
            this.InvalidateArea();
        }
    }

    @Override
    public void ExcluirSubItem(int idx) {
        if (this.getCampoSelecionado() != null) {
            this.RemoveCampo(this.getCampoSelecionado());
            return;
        }
        if (this.getConstraintSelecionado() != null) {
            this.RemoveConstraint(this.getConstraintSelecionado());
        }
    }

    @Override
    public void PoluleColors(ArrayList<Color> cores) {
        super.PoluleColors(cores);
        if (cores.indexOf(this.getGradienteStartColor()) == -1) {
            cores.add(this.getGradienteStartColor());
        }
        if (cores.indexOf(this.getGradienteEndColor()) == -1) {
            cores.add(this.getGradienteEndColor());
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.isAutosize()) {
            this.needRecalc = true;
        }
    }

    @Override
    public void PosicionePonto(PontoDeLinha ponto) {
        super.PosicionePonto(ponto);
        this.AfterPosicione(ponto);
    }

    protected void AfterPosicione(PontoDeLinha ponto) {
        int mx = ponto.getLado();
        int L = ponto.getLeft();
        int T = ponto.getTop();
        int rnd = this.roundrect / 2;
        boolean sn = false;
        switch (mx) {
            case 0: 
            case 2: {
                int tmp = this.getTop() + rnd;
                if (T < tmp) {
                    T = tmp;
                    sn = true;
                    break;
                }
                tmp = this.getTopHeight() - rnd;
                if (T <= tmp) break;
                T = tmp;
                sn = true;
                break;
            }
            case 1: 
            case 3: {
                int tmp = this.getLeft() + rnd;
                if (L < tmp) {
                    L = tmp;
                    sn = true;
                    break;
                }
                tmp = this.getLeftWidth() - rnd;
                if (L <= tmp) break;
                L = tmp;
                sn = true;
            }
        }
        if (sn) {
            ponto.setLocation(L, T);
        }
    }

    @Override
    protected void PropagueResizeParaLigacoes() {
        super.PropagueResizeParaLigacoes();
        this.getListaDePontosLigados().stream().forEach(p -> this.AfterPosicione((PontoDeLinha)p));
    }

    @Override
    public void runAncorasCode(int cod) {
        super.runAncorasCode(cod);
        switch (cod) {
            case 3: {
                this.DoAnyThing(200317);
                break;
            }
            case 5: {
                this.DoAnyThing(180717);
                break;
            }
            case 6: {
                this.DoAnyThing(310317);
                break;
            }
            case 9: {
                this.ExcluirSubItem(0);
                break;
            }
            case 8: {
                if (this.getCampoSelecionado() != null) {
                    if (this.getCampoSelecionado().isLast()) break;
                    this.DoAnyThing(1);
                    break;
                }
                if (this.getConstraintSelecionado() == null || this.getConstraintSelecionado().isLast()) break;
                this.DoAnyThing(110417);
                break;
            }
            case 7: {
                if (this.getCampoSelecionado() != null) {
                    if (this.getCampoSelecionado().isFirst()) break;
                    this.DoAnyThing(-1);
                    break;
                }
                if (this.getConstraintSelecionado() == null || this.getConstraintSelecionado().isFirst()) break;
                this.DoAnyThing(-110417);
            }
        }
    }

    @Override
    public String WhatDrawOnAcorador(Integer c) {
        String res = "";
        boolean any = this.getCampoSelecionado() != null || this.getConstraintSelecionado() != null;
        switch (c) {
            case 3: {
                res = "diagrama.ancordor.3.img";
                break;
            }
            case 5: {
                res = "diagrama.ancordor.5.img";
                break;
            }
            case 6: {
                res = "diagrama.ancordor.6.img";
                break;
            }
            case 7: {
                if (this.getCampoSelecionado() != null && !this.getCampoSelecionado().isFirst() || this.getConstraintSelecionado() != null && !this.getConstraintSelecionado().isFirst()) {
                    res = "diagrama.ancordor.7.img";
                    break;
                }
                res = "diagrama.ancordor.7.0.img";
                break;
            }
            case 8: {
                if (this.getCampoSelecionado() != null && !this.getCampoSelecionado().isLast() || this.getConstraintSelecionado() != null && !this.getConstraintSelecionado().isLast()) {
                    res = "diagrama.ancordor.8.img";
                    break;
                }
                res = "diagrama.ancordor.8.0.img";
                break;
            }
            case 9: {
                String string = res = any ? "diagrama.ancordor.9.img" : "diagrama.ancordor.9.0.img";
            }
        }
        if (!"".equals(res)) {
            return res;
        }
        return super.WhatDrawOnAcorador(c);
    }

    public void PrintDDL() {
        ArrayList<String> ddl = new ArrayList<String>();
        this.DDLGenerate(ddl, 2);
        String tmp = "/* brModelo: */\n";
        Dialogos.ShowDlgTextoReadOnly(Aplicacao.fmPrincipal.getRootPane(), ddl.stream().map(s -> "\n" + s).reduce(tmp, String::concat));
    }

    public void ProcesseIrKey(Campo cmp) {
        if (cmp == null || this.getMaster().isCarregando) {
            return;
        }
        this.direct_ProcesseIrKey(cmp);
    }

    public void direct_ProcesseIrKey(Campo cmp) {
        Constraint pk = this.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpPK).findAny().orElse(null);
        if (pk == null) {
            if (cmp.isKey()) {
                pk = new Constraint(this);
                pk.setTipo(Constraint.CONSTRAINT_TIPO.tpPK);
                pk.Add(cmp, null);
            }
            return;
        }
        if (cmp.isKey() && pk.getCamposDeOrigem().indexOf(cmp) == -1) {
            pk.Add(cmp, null);
            this.NotifiqueIR(pk, 2, cmp);
            return;
        }
        if (!cmp.isKey() && pk.getCamposDeOrigem().indexOf(cmp) > -1) {
            pk.RemoveFromOrigem(cmp);
            this.NotifiqueIR(pk, 3, cmp);
            this.AnaliseAndRemove(pk);
        }
    }

    public void NotifiqueIR(Constraint cons, int msg, Campo cmp) {
        if (this.getMaster().isCarregando) {
            return;
        }
        ((DiagramaLogico)this.getMaster()).ReciveNotifiqueIR(cons, msg, cmp);
    }

    public List<Constraint> getPresentAsUN(Campo cmp) {
        ArrayList<Constraint> lst = new ArrayList<Constraint>();
        this.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpUNIQUE).filter(c -> c.getCamposDeOrigem().indexOf(cmp) > -1).forEach(c -> lst.add((Constraint)c));
        return lst;
    }

    public Constraint getPresentAsFK(Campo cmp) {
        return this.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpFK).filter(c -> c.getCamposDeDestino().indexOf(cmp) > -1).findAny().orElse(null);
    }

    public void ProcesseIrUnique(Campo cmp) {
        if (cmp == null || this.getMaster().isCarregando) {
            return;
        }
        Constraint pk = this.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpUNIQUE).findFirst().orElse(null);
        if (pk == null) {
            if (cmp.isUnique()) {
                pk = new Constraint(this);
                pk.setTipo(Constraint.CONSTRAINT_TIPO.tpUNIQUE);
                pk.Add(cmp, null);
                this.InvalidateArea();
            }
            return;
        }
        if (cmp.isUnique() && pk.getCamposDeOrigem().indexOf(cmp) == -1) {
            pk.Add(cmp, null);
            this.NotifiqueIR(pk, 2, cmp);
            return;
        }
        if (!cmp.isUnique()) {
            List<Constraint> lst = this.getPresentAsUN(cmp);
            lst.stream().forEach(constr -> {
                constr.RemoveFromOrigem(cmp);
                this.NotifiqueIR((Constraint)constr, 3, cmp);
                this.AnaliseAndRemove((Constraint)constr);
            });
        }
    }

    public void ProcesseIrUnique(Campo cmp, Constraint constr, boolean isadd) {
        if (cmp == null || this.getMaster().isCarregando) {
            return;
        }
        Constraint pk = constr;
        if (pk == null) {
            if (isadd) {
                pk = new Constraint(this);
                pk.setTipo(Constraint.CONSTRAINT_TIPO.tpUNIQUE);
                pk.Add(cmp, null);
                this.InvalidateArea();
            }
            return;
        }
        if (isadd && pk.getCamposDeOrigem().indexOf(cmp) == -1) {
            pk.Add(cmp, null);
            this.NotifiqueIR(pk, 2, cmp);
            return;
        }
        if (!isadd && pk.getCamposDeOrigem().indexOf(cmp) > -1) {
            pk.RemoveFromOrigem(cmp);
            this.NotifiqueIR(pk, 3, cmp);
        }
    }

    public void ProcesseIrFK(Campo cmp) {
        if (cmp == null || this.getMaster().isCarregando) {
            return;
        }
        Constraint fk = this.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpFK && !c.isValidado()).findFirst().orElse(null);
        if (fk == null) {
            if (cmp.isFkey()) {
                fk = new Constraint(this);
                fk.setTipo(Constraint.CONSTRAINT_TIPO.tpFK);
                fk.Add(null, cmp);
                this.InvalidateArea();
            }
            return;
        }
        if (cmp.isFkey() && fk.getCamposDeOrigem().indexOf(cmp) == -1) {
            fk.Add(null, cmp);
            return;
        }
        if (!cmp.isFkey()) {
            fk.RemoveFromDestino(cmp);
            this.AnaliseAndRemove(fk);
        }
    }

    @Override
    public void menosLigacao(PontoDeLinha aThis) {
        super.menosLigacao(aThis);
        LogicoLinha linha = (LogicoLinha)aThis.getDono();
        this.Desligacao(linha);
        Forma op = linha.getOutraPonta(this);
        if (op != null && op instanceof Tabela) {
            ((Tabela)op).Desligacao(linha);
        }
    }

    public void Desligacao(LogicoLinha linha) {
        this.getConstraints().stream().filter(c -> c.getLigacao() == linha).forEach(cnsmr -> cnsmr.setLigacao(null));
    }

    public String getSepadorSql() {
        return ((DiagramaLogico)this.getMaster()).getSeparatorSQL();
    }

    public String getPrefixo() {
        return ((DiagramaLogico)this.getMaster()).getPrefixo();
    }

    public boolean isMostrarConstraints() {
        return this.mostrarConstraints;
    }

    public void setMostrarConstraints(boolean mostrarConstraints) {
        if (this.mostrarConstraints == mostrarConstraints) {
            return;
        }
        this.mostrarConstraints = mostrarConstraints;
        this.InvalidateArea();
    }

    @Override
    public void maisLigacao(PontoDeLinha aThis) {
        super.maisLigacao(aThis);
        LogicoLinha linha = (LogicoLinha)aThis.getDono();
        Forma origem = linha.getOutraPonta(this);
        if (origem != null && origem instanceof Tabela) {
            Tabela tab = (Tabela)origem;
            this.ReLiga(linha, tab);
            tab.ReLiga(linha, this);
        }
    }

    public void ReLiga(LogicoLinha linha, Tabela origem) {
        this.getConstraints().stream().filter(c -> c.getLigacao() == null && c.getTabelaDeOrigem() == origem).forEach(cnsmr -> cnsmr.setLigacao(linha));
    }

    @Override
    public void setTexto(String Texto2) {
        super.setTexto(Texto2);
        this.RefreshPosNovoTexto();
    }

    public void RefreshPosNovoTexto() {
        this.SendNotificacao(7);
    }

    @Override
    public void mouseDblClicked(MouseEvent e) {
        super.mouseDblClicked(e);
        if (this.getConstraintSelecionado() != null) {
            int tg = 120420171;
            if (this.getConstraintSelecionado().getTipo() == Constraint.CONSTRAINT_TIPO.tpPK) {
                tg = 120420170;
            } else if (this.getConstraintSelecionado().getTipo() == Constraint.CONSTRAINT_TIPO.tpUNIQUE) {
                tg = 120420172;
            }
            this.DoAnyThing(tg);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        if (this.constraintRoqued != null) {
            this.roqueFromMouse(false);
            this.constraintRoqued = null;
        }
    }

    private void roqueFromMouse(boolean sn) {
        if (sn == this.constraintRoqued.roqued) {
            return;
        }
        if (this.constraintRoqued.isAutoRelacionamento()) {
            this.constraintRoqued.roqued = sn;
            this.constraintRoqued.getCamposDeDestino().stream().filter(c -> c != null).forEach(c -> {
                c.roqued = sn;
            });
            this.constraintRoqued.getCamposDeOrigem().stream().filter(c -> c != null).forEach(c -> {
                c.roqued = sn;
            });
            this.InvalidateArea();
            return;
        }
        if (this.constraintRoqued.getLigacao() != null) {
            this.constraintRoqued.getLigacao().PerformRoqued(sn);
            this.constraintRoqued.getLigacao().SetFatorLargura(sn ? 2.0f : 1.0f);
            this.constraintRoqued.getLigacao().InvalidateArea();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        Constraint tmp = this.getConstraints().stream().filter(constr -> constr.getTipo() == Constraint.CONSTRAINT_TIPO.tpFK && constr.isMe(e.getPoint())).findFirst().orElse(null);
        if (tmp == this.constraintRoqued) {
            return;
        }
        if (this.constraintRoqued != null) {
            this.roqueFromMouse(false);
        }
        if (tmp == null) {
            this.constraintRoqued = null;
        } else {
            this.constraintRoqued = tmp;
            this.roqueFromMouse(true);
        }
    }

    @Override
    public boolean MostreSeParaExibicao(TreeItem root) {
        TreeItem t = new TreeItem(this.getTexto(), this.getID(), this.getClass().getSimpleName());
        this.getCampos().stream().forEach(c -> c.MostreSeParaExibicao(t));
        this.getConstraints().stream().forEach(c -> c.MostreSeParaExibicao(t));
        root.add(t);
        return true;
    }

    @Override
    public void DoSubItemSel(int index) {
        super.DoSubItemSel(index);
        if (index < this.getCampos().size()) {
            this.setCampoSelectedIndex(index);
        } else {
            this.setConstraintSelectedIndex(index -= this.getCampos().size());
        }
    }
}

