/*
 * Decompiled with CFR 0.152.
 */
package diagramas.conceitual;

import controlador.Diagrama;
import controlador.Editor;
import controlador.apoios.TreeItem;
import controlador.inspector.InspectorProperty;
import desenho.FormaElementar;
import desenho.formas.Forma;
import desenho.preAnyDiagrama.PreEntidadeAssociativa;
import diagramas.conceitual.Relacionamento;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.Dialogos;

public class EntidadeAssociativa
extends PreEntidadeAssociativa {
    private static final long serialVersionUID = 7518332308924246293L;

    public EntidadeAssociativa(Diagrama modelo) {
        super(modelo);
        this.nodic = false;
    }

    public EntidadeAssociativa(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.nodic = false;
    }

    public EntidadeAssociativa(Diagrama modelo, String texto, Relacionamento fr) {
        super(modelo, texto, fr);
        this.nodic = false;
    }

    @Override
    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> GP) {
        ArrayList<InspectorProperty> res = GP;
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "entassociativa.convrelacionamento").setTag(90816));
        res.add(InspectorProperty.PropertyFactorySeparador("entidadeasossiativa.relacao"));
        String relaName = Editor.getClassTexto(this.getInterno());
        res.add(InspectorProperty.PropertyFactoryTexto("nome", relaName + ".setTexto", this.getInterno().getTexto()));
        res.add(InspectorProperty.PropertyFactoryTextoL("observacao", relaName + ".setObservacao", this.getInterno().getObservacao()));
        res.add(InspectorProperty.PropertyFactoryTextoL("dicionario", relaName + ".setTextoAdicional", this.getInterno().getTextoAdicional()));
        res.add(InspectorProperty.PropertyFactoryCor("forecolor", relaName + ".setForeColor", this.getInterno().getForeColor()));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "entidade.orgattr").setTag(124));
        super.CompleteGenerateProperty(GP);
        int p = GP.size() - 1;
        ArrayList<Forma> lst = this.getInterno().getListaDeFormasLigadas();
        boolean ja = InspectorProperty.FindByProperty(res, "ligacoes") != null;
        for (Forma f : lst) {
            InspectorProperty ipp = InspectorProperty.PropertyFactoryActionSelect(Editor.fromConfiguracao.getValor("diagrama." + Editor.getClassTexto(f) + ".nome"), f.getTexto(), String.valueOf(((FormaElementar)f.getPrincipal()).getID()));
            if (!ja) {
                ja = true;
                GP.add(InspectorProperty.PropertyFactorySeparador("ligacoes", true));
            }
            GP.add(p, ipp);
        }
        return GP;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        this.getInterno().ToXlm(doc, me);
        NodeList nl = me.getElementsByTagName(this.getInterno().getClass().getSimpleName());
        if (nl != null && nl.getLength() > 0) {
            Element achado = (Element)nl.item(0);
            nl = achado.getElementsByTagName("Bounds");
            achado.removeChild(nl.item(0));
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.getInterno().setFont(font);
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        Element inter = (Element)me.getElementsByTagName(this.getInterno().getClass().getSimpleName()).item(0);
        boolean ret = this.getInterno().LoadFromXML(inter, colando);
        this.ReenquadreInterno();
        return ret;
    }

    @Override
    public boolean CommitXML(Element me, HashMap<Element, FormaElementar> mapa) {
        boolean res = super.CommitXML(me, mapa);
        this.ReenquadreInterno();
        return res;
    }

    @Override
    public void DoAnyThing(int Tag) {
        super.DoAnyThing(Tag);
        if (Tag == 124) {
            this.getInterno().DoAnyThing(123);
            if (this.mudouAtributos || this.getInterno().mudouAtributos) {
                this.DoMuda();
            }
        }
        if (Tag == 90816) {
            this.ConverteRel();
        }
    }

    private void ConverteRel() {
        if (!this.getListaDePontosLigados().isEmpty()) {
            Dialogos.ShowMessageInform(this.getMaster().getEditor().getParent(), Editor.fromConfiguracao.getValor("Controler.MSG_INFO_TEM_LIGACAO"));
            return;
        }
        Rectangle res = this.getInterno().getBounds();
        Relacionamento novo = new Relacionamento(this.getMaster());
        novo.SetTexto(this.getInterno().getTexto());
        novo.SetBounds(res);
        this.getInterno().getListaDePontosLigados().stream().forEach(p -> p.SetEm(novo));
        novo.setObservacao(this.getInterno().getObservacao());
        novo.setTextoAdicional(this.getInterno().getTextoAdicional());
        novo.setBackColor(this.getInterno().getBackColor());
        novo.setForeColorWithOutRepaint(this.getInterno().getForeColor());
        novo.setFont(this.getInterno().getFont());
        this.getMaster().Remove(this, true);
        this.getMaster().setSelecionado(novo);
        novo.DoMuda();
    }

    @Override
    public boolean MostreSeParaExibicao(TreeItem root) {
        TreeItem t = new TreeItem(this.getTexto(), this.getID(), this.getClass().getSimpleName());
        t.add(new TreeItem(this.getInterno().getTexto(), this.getID(), this.getInterno().getClass().getSimpleName()));
        root.add(t);
        return true;
    }
}

