/*
 * Decompiled with CFR 0.152.
 */
package controlador.conversor;

import controlador.Controler;
import controlador.Editor;
import controlador.conversor.conversorDialogo;
import controlador.conversor.conversorLink;
import controlador.conversor.conversorOpcoes;
import desenho.FormaElementar;
import desenho.formas.Desenhador;
import desenho.formas.Forma;
import desenho.formas.Legenda;
import desenho.linhas.PontoDeLinha;
import desenho.preAnyDiagrama.PreCardinalidade;
import desenho.preAnyDiagrama.PreEntidade;
import diagramas.conceitual.Atributo;
import diagramas.conceitual.DiagramaConceitual;
import diagramas.conceitual.EntidadeAssociativa;
import diagramas.conceitual.Especializacao;
import diagramas.conceitual.Ligacao;
import diagramas.conceitual.Relacionamento;
import diagramas.conceitual.Texto;
import diagramas.conceitual.Uniao;
import diagramas.logico.Campo;
import diagramas.logico.Constraint;
import diagramas.logico.DiagramaLogico;
import diagramas.logico.LogicoLinha;
import diagramas.logico.Tabela;
import java.awt.Frame;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import util.BrLogger;
import util.ImageGenerate;
import util.Utilidades;

public class conversorConceitualParaLogico {
    public DiagramaConceitual origem = null;
    public DiagramaLogico destino = null;
    private boolean removerEspecial = false;
    public conversorOpcoes Opcoes = new conversorOpcoes();
    private conversorLink Links = new conversorLink();
    private final int DIST = 120;
    BufferedImage dig_img = null;
    private ArrayList<Tabela> frutoAutoRelacionamento = new ArrayList();
    private HashMap<Tabela, Campo> campoTipoJaSetado = new HashMap();
    HashMap<Constraint, LogicoLinha> directFK = new HashMap();
    HashMap<Constraint, Tabela> directPK = new HashMap();
    HashMap<Campo, Campo> camposOrigem = new HashMap();
    HashMap<LogicoLinha, Tabela> origemLigacao = new HashMap();

    public boolean beginConvert(DiagramaConceitual or, DiagramaLogico des) {
        this.origem = or;
        this.destino = des;
        this.destino.isCarregando = true;
        this.origem.ClearSelect();
        boolean sn = this.perguntaCaracteres() && this.converterEntidades() && this.converterAtributos() && this.converterEspecializacao() && this.converterUniao() && this.converterAutoRelacionamento() && this.converterRelacionamento() && this.converterEntidadeAssossiativa() && this.exportarAssessorios() && this.processeConstraints();
        this.destino.isCarregando = false;
        this.destino.getEditor().paintImmediately(0, 0, this.destino.getEditor().getWidth(), this.destino.getEditor().getHeight());
        if (sn) {
            this.destino.isCarregando = true;
            this.renomeieFKs();
            this.organizeDiagrama();
            this.destino.isCarregando = false;
            this.destino.DoMuda(null);
            this.destino.repaint();
            String tmp = "";
            if (!this.Opcoes.Erros.isEmpty()) {
                tmp = this.Opcoes.Erros.stream().map(s -> "\n" + s).reduce(tmp, String::concat);
            }
            JOptionPane.showMessageDialog(this.origem.getEditor().getParent(), Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg75") + (tmp.isEmpty() ? "" : "\n" + Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg76") + tmp), Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg77"), 1);
        } else {
            this.destino.DoMuda(null);
            JOptionPane.showMessageDialog(this.origem.getEditor().getParent(), Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg78"), Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg79"), 2);
        }
        this.destino.getEditor().diagramaAtual.PerformInspector();
        return sn;
    }

    private boolean perguntaCaracteres() {
        this.Opcoes.Inicializar();
        this.Opcoes.opcDefault = 0;
        this.Opcoes.Textos.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.conceitual"));
        this.Opcoes.Questoes.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.conceitual.carcteres"));
        this.Opcoes.Questoes.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.conceitual.carcteresNO"));
        this.Opcoes.obj = null;
        if (!this.Questione()) {
            return false;
        }
        this.removerEspecial = this.Opcoes.OPC == 0;
        return true;
    }

    public conversorLink getLinks() {
        return this.Links;
    }

    public void setLinks(conversorLink Links) {
        this.Links = Links;
    }

    public boolean converterEntidades() {
        this.origem.getListaDeItens().stream().filter(o -> o instanceof PreEntidade).map(e -> (PreEntidade)e).forEach(e -> {
            FormaElementar res = this.destino.ExternalRealiseComando(Controler.Comandos.cmdTabela, e.getLocation());
            if (res != null) {
                ((Tabela)res).SetTexto(this.removerCaracteresEspeciais(e.getTexto()));
                this.Links.Add((FormaElementar)e, res);
            }
        });
        this.destino.isCarregando = false;
        this.destino.repaint();
        this.destino.isCarregando = true;
        return true;
    }

    public boolean converterAtributos() {
        List ents = this.origem.getListaDeItens().stream().filter(o -> o instanceof PreEntidade).map(e -> (PreEntidade)e).collect(Collectors.toList());
        for (PreEntidade E : ents) {
            List<Atributo> lst = E.getListaDePontosLigados().stream().filter(p -> p.getDono().getOutraPonta((PontoDeLinha)p).getEm() instanceof Atributo).map(p -> (Atributo)p.getDono().getOutraPonta((PontoDeLinha)p).getEm()).collect(Collectors.toList());
            List<FormaElementar> tmp = this.Links.getLigadosOrigem(E);
            if (tmp.isEmpty() || tmp.size() > 1) {
                BrLogger.Logger("MSG_CONVERT_ERROR", "QTD TBL " + String.valueOf(tmp.size()));
                this.Opcoes.Erros.add("MSG_CONVERT_ERROR: QTD TBL " + String.valueOf(tmp.size()));
                return false;
            }
            Tabela tbl = tmp.stream().filter(t -> t instanceof Tabela).findFirst().orElse(null);
            if (tbl == null) {
                BrLogger.Logger("MSG_CONVERT_ERROR", "QTD TBL 0");
                this.Opcoes.Erros.add("MSG_CONVERT_ERROR: QTD TBL 0");
                return false;
            }
            if (!this.recebaEConvertaAtributos(E, tbl, lst)) {
                return false;
            }
            this.recebaEConvertaAtributosOcultos(tbl, E.getAtributosOcultos().trim());
        }
        return true;
    }

    private boolean recebaEConvertaAtributosOcultos(Tabela tb, String ao) {
        String[] lst;
        for (String a : lst = ao.split("\n")) {
            a = a.trim();
            String tipo = "";
            if (a.isEmpty()) continue;
            if (a.contains(" ")) {
                String[] ct = a.replaceAll(" +", " ").split(" ");
                a = ct[0];
                tipo = ct[1];
            }
            Campo c = tb.Add(a);
            c.setTexto(this.removerCaracteresEspeciais(a));
            if (tipo.isEmpty()) continue;
            c.setTipo(tipo);
        }
        return true;
    }

    private boolean recebaEConvertaAtributos(Forma E, Tabela tb, List<Atributo> lst) {
        boolean res = true;
        ArrayList<String> infos = this.Opcoes.Textos;
        String pk = Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.pk.sufix");
        String fk = Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.sufix");
        for (Atributo a : lst) {
            boolean tmpcardMaxUtil;
            boolean bl = tmpcardMaxUtil = a.getCardMaxima() > 1 || a.getCardMaxima() == -1;
            if (a.isAtributoComposto() || a.isOpcional() || a.isMultivalorado() && tmpcardMaxUtil) {
                FormaElementar xres;
                int tmp = (a.isOpcional() ? 1 : 0) + (a.isAtributoComposto() ? 1 : 0) + (a.isMultivalorado() ? 1 : 0);
                this.Opcoes.Inicializar();
                String and = " " + Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg06") + " ";
                infos.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.atributo.atributo") + " " + (a.isAtributoComposto() ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.atributo.composto") : "") + (tmp == 3 ? ", " : (tmp > 1 ? and : "")) + (a.isOpcional() ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.atributo.opcional") : "") + (tmp > 1 ? and : "") + (a.isMultivalorado() ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.atributo.multivalorado") : "") + ": " + a.getTexto());
                String s = Utilidades.EncapsuleMsg("msg12", a.getObservacao().isEmpty() ? "[" + Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg09") + "]" : a.getObservacao(), E.getTexto());
                infos.add(s);
                this.Opcoes.opcDefault = a.isMultivalorado() && tmpcardMaxUtil ? 0 : 1;
                this.Opcoes.Questoes.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg11"));
                if (a.isOpcional() && tmp == 1) {
                    this.Opcoes.Questoes.add(Utilidades.EncapsuleMsg("msg12", tb.getTexto()));
                } else {
                    this.Opcoes.Questoes.add(Utilidades.EncapsuleMsg("msg13", tb.getTexto()));
                }
                ArrayList<Atributo> attrs = new ArrayList<Atributo>();
                boolean Limitado = this.captureAtributos(a, attrs);
                if (Limitado) {
                    this.Opcoes.Observacoes.add(0, Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg14"));
                    this.Opcoes.Disables.add(1);
                    this.Opcoes.opcDefault = 0;
                }
                this.Opcoes.obj = a;
                if (!this.Questione()) {
                    return false;
                }
                Tabela ntb = tb;
                if (this.Opcoes.OPC == 0 && (xres = this.CriarTabela(tb)) != null) {
                    ntb = (Tabela)xres;
                    String ax = this.removerCaracteresEspeciais(a.getTexto());
                    ntb.setTexto(ax);
                    this.Links.Add(a, xres);
                    this.setOrigemLigacao(this.LinkTable(tb, ntb, a.isOpcional() ? 0 : (a.isMultivalorado() ? 0 : 1), Limitado ? 3 : 1), tb);
                    Campo c = ntb.Add(ax + pk);
                    c.setTexto(ax + pk);
                    c.setKey(true);
                    c.setTipo("INT");
                    c.setComplemento("NOT NULL");
                    Campo c2 = tb.Add(ax + fk);
                    c2.setTexto(ax + fk);
                    c2.setFkey(true);
                    this.setCampoOrigem(c2, c);
                }
                Tabela T = ntb;
                attrs.forEach(at -> this.ImportaComoCampo(T, (Atributo)at));
                continue;
            }
            this.ImportaComoCampo(tb, a);
        }
        return res;
    }

    private void ImportaComoCampo(Tabela tb, Atributo a) {
        String ax = this.removerCaracteresEspeciais(a.getTexto());
        Campo c = tb.Add(ax);
        c.setTexto(ax);
        c.setTipo(a.getTipoAtributo());
        c.setKey(a.isIdentificador());
        c.setObservacao(a.getObservacao());
        c.setDicionario(a.getTextoAdicional());
    }

    private Campo ImportaCampo(Tabela tb, Campo a, String preTxt) {
        Campo c = tb.Add("_");
        String ax = this.removerCaracteresEspeciais(preTxt + a.getTexto());
        c.setTexto(ax);
        c.setTipo(a.getTipo());
        c.setKey(a.isKey());
        c.setFkey(a.isFkey());
        c.setObservacao(a.getObservacao());
        c.setDicionario(a.getDicionario());
        return c;
    }

    private Campo ImportaCampoIgnoreConstrais(Tabela tb, Campo a, String preTxt) {
        Campo c = tb.Add("_");
        String ax = this.removerCaracteresEspeciais(preTxt + a.getTexto());
        c.setTexto(ax);
        c.setTipo(a.getTipo());
        c.setObservacao(a.getObservacao());
        c.setDicionario(a.getDicionario());
        return c;
    }

    private void ImportaCampoChave(Tabela ori, Tabela dest, String preTxt) {
        if (ori == dest) {
            return;
        }
        ori.getCampos().stream().filter(c -> c.isKey()).forEach(a -> {
            Campo c = dest.Add("_");
            String ax = this.removerCaracteresEspeciais(preTxt + a.getTexto());
            c.setTexto(ax);
            c.setTipo(a.getTipo());
            c.setFkey(true);
            this.setCampoOrigem(c, (Campo)a);
            c.setObservacao(a.getObservacao());
            c.setDicionario(a.getDicionario());
        });
    }

    private void ImportaCampoChaveKFK(Tabela ori, Tabela dest, String preTxt) {
        if (ori == dest) {
            return;
        }
        ori.getCampos().stream().filter(c -> c.isKey()).forEach(a -> {
            Campo c = dest.Add("_");
            String ax = this.removerCaracteresEspeciais(preTxt + a.getTexto());
            c.setTexto(ax);
            c.setTipo(a.getTipo());
            c.setFkey(true);
            c.setKey(true);
            this.setCampoOrigem(c, (Campo)a);
            c.setObservacao(a.getObservacao());
            c.setDicionario(a.getDicionario());
        });
    }

    private void ImportaCampo(Tabela ori, Tabela dest) {
        if (ori == dest || ori == null || dest == null) {
            return;
        }
        ori.getCampos().stream().forEach(a -> {
            if (dest.getCampos().stream().filter(ca -> ca.getTexto().equals(a.getTexto()) && this.getCampoOrigem((Campo)ca) == this.getCampoOrigem((Campo)a) && ca.isFkey() == a.isFkey() && ca.isKey() == a.isKey()).count() == 0L) {
                Campo c = dest.Add("_");
                String ax = this.removerCaracteresEspeciais(a.getTexto());
                c.setTexto(ax);
                c.setTipo(a.getTipo());
                c.setKey(a.isKey());
                c.setFkey(a.isFkey());
                if (c.isFkey()) {
                    this.setCampoOrigem(c, this.getCampoOrigem((Campo)a));
                }
                c.setObservacao(a.getObservacao());
                c.setDicionario(a.getDicionario());
            }
        });
    }

    private boolean Questione() {
        if (this.Opcoes.isYesToAll()) {
            this.Opcoes.OPC = this.Opcoes.opcDefault;
            return true;
        }
        conversorDialogo fm = new conversorDialogo((Frame)((Object)this.origem.getEditor().getFramePrincipal()), true);
        if (this.Opcoes.LastPosi == null) {
            fm.setLocationRelativeTo((Frame)((Object)this.origem.getEditor().getFramePrincipal()));
        } else {
            fm.setLocation(this.Opcoes.LastPosi);
        }
        if (this.dig_img == null) {
            this.dig_img = ImageGenerate.geraImagem(this.origem);
        }
        fm.Inicializar(this.origem, this.destino, this.Opcoes, this.dig_img);
        fm.setVisible(true);
        return this.Opcoes.Resultado != conversorOpcoes.resultOfQuestion.respCancel;
    }

    private boolean captureAtributos(Atributo A, List<Atributo> lst) {
        int mv = 1;
        boolean sera_limitado = false;
        if (A.isMultivalorado()) {
            sera_limitado = A.getCardMaxima() < 0 || A.getCardMaxima() > 10;
            mv = sera_limitado ? 1 : A.getCardMaxima();
        }
        List<Atributo> tmp = A.getAtributos();
        for (int i = 0; i < mv; ++i) {
            if (tmp.isEmpty()) {
                lst.add(A);
            } else {
                for (Atributo a : tmp) {
                    if (!this.captureAtributos(a, lst)) continue;
                    sera_limitado = true;
                }
            }
            if (lst.size() <= 50) continue;
            sera_limitado = true;
            break;
        }
        if (sera_limitado) {
            this.Opcoes.Observacoes.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg16") + " " + A.getTexto() + " " + Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg17"));
        }
        return sera_limitado;
    }

    private LogicoLinha LinkTable(Tabela origem, Tabela destino, int cardO, int cardD) {
        LogicoLinha lin = this.Ligue(origem, destino);
        lin.getCardA().setCard(cardO);
        lin.getCardB().setCard(cardD);
        lin.ajusteSeta();
        return lin;
    }

    private LogicoLinha Ligue(Tabela A, Tabela B) {
        LogicoLinha linha = new LogicoLinha(A.getMaster());
        int m = Forma.MapaPosi(A, B);
        int sp = 2;
        Point ptA = new Point();
        Point ptB = new Point();
        switch (m) {
            case 0: 
            case 1: 
            case 7: {
                ptA = new Point(A.getLeft() + sp, A.getTop() + A.getHeight() / 2);
                ptB = new Point(B.getLeftWidth() - sp, B.getTop() + B.getHeight() / 2);
                break;
            }
            case 2: {
                ptA = new Point(A.getLeft() + A.getWidth() / 2, A.getTop() + sp);
                ptB = new Point(B.getLeft() + B.getWidth() / 2, B.getTopHeight() - sp);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                ptA = new Point(A.getLeftWidth() - sp, A.getTop() + A.getHeight() / 2);
                ptB = new Point(B.getLeft() + sp, B.getTop() + B.getHeight() / 2);
                break;
            }
            case 6: {
                ptA = new Point(A.getLeft() + A.getWidth() / 2, A.getTopHeight() - sp);
                ptB = new Point(B.getLeft() + B.getWidth() / 2, B.getTop() + sp);
            }
        }
        linha.FormasALigar = new Forma[]{A, B};
        linha.SuperInicie(0, ptB, ptA);
        linha.Ligar();
        return linha;
    }

    private Point EspacoOcupado(Tabela tb, Point p) {
        FormaElementar ac = tb;
        Point res = new Point(p);
        while (ac != null) {
            Point x = new Point(res);
            ac = tb.getMaster().getListaDeItens().stream().filter(o -> o.getLocation().equals(x)).findFirst().orElse(null);
            if (ac == null) continue;
            res = new Point(ac.getLeft(), ac.getTopHeight() + 24);
        }
        return res;
    }

    private void organizeDiagrama() {
        this.destino.OrganizeTabelas();
        this.destino.getListaDeTabelas().stream().forEach(tt -> tt.OrganizeDiagrama());
    }

    public boolean converterAutoRelacionamento() {
        List lst = this.origem.getListaDeItens().stream().filter(o -> o instanceof Relacionamento && ((Relacionamento)o).isAutoRelacionamento()).map(r -> (Relacionamento)r).collect(Collectors.toList());
        for (Relacionamento R : lst) {
            if (R.getListaDeFormasLigadas().isEmpty()) continue;
            PreEntidade E = R.getListaDeFormasLigadas().stream().filter(o -> o instanceof PreEntidade).map(e -> (PreEntidade)e).findFirst().orElse(null);
            List lig = R.getListaDePontosLigados().stream().filter(o -> o.getDono().getOutraPonta(R) instanceof PreEntidade).map(o -> (Ligacao)o.getDono()).collect(Collectors.toList());
            int tmp1 = ((Ligacao)lig.get(0)).getCard().CardToInt();
            int tmp2 = ((Ligacao)lig.get(1)).getCard().CardToInt();
            int Card2 = Math.max(tmp1, tmp2);
            int Card1 = Math.min(tmp1, tmp2);
            boolean AdCol = false;
            if (Card2 == 1) {
                AdCol = true;
            } else if (Card1 <= 1) {
                this.Opcoes.Inicializar();
                String tmp = Utilidades.EncapsuleMsg("msg18", PreCardinalidade.CardToString(Card1), PreCardinalidade.CardToString(Card2));
                this.Opcoes.Textos.add(tmp);
                tmp = Utilidades.EncapsuleMsg("msg20", E.getTexto(), R.getTexto());
                this.Opcoes.Textos.add(tmp);
                this.AddObservacoes(R, true);
                this.Opcoes.opcDefault = Card2 == 2 ? 0 : 1;
                tmp = Utilidades.EncapsuleMsg("msg21", E.getTexto());
                this.Opcoes.Questoes.add(tmp);
                this.Opcoes.Questoes.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg22"));
                if (Card1 == 0 && (Card2 == 0 || Card2 == 2)) {
                    this.Opcoes.Disables.add(0);
                    tmp = Utilidades.EncapsuleMsg("msg23", PreCardinalidade.CardToString(Card1), PreCardinalidade.CardToString(Card2));
                    this.Opcoes.Textos.add(tmp);
                }
                this.Opcoes.obj = R;
                if (!this.Questione()) {
                    return false;
                }
                AdCol = this.Opcoes.OPC == 0;
            }
            List tabs = this.Links.getLigadosOrigem(E).stream().filter(t -> t instanceof Tabela).map(t -> (Tabela)t).collect(Collectors.toList());
            Iterator iterator = tabs.iterator();
            while (iterator.hasNext()) {
                Tabela T;
                Tabela T2 = T = (Tabela)iterator.next();
                if (AdCol) {
                    for (int i = 0; i < T.getCampos().size(); ++i) {
                        Campo C2 = T.getCampos().get(i);
                        if (!C2.isKey()) continue;
                        Campo c2 = this.ImportaCampo(T, C2, T.getTexto() + "_");
                        c2.setKey(false);
                        c2.setFkey(true);
                        this.setCampoOrigem(c2, C2);
                    }
                } else {
                    FormaElementar xres = this.CriarTabela(T);
                    if (xres != null) {
                        T2 = (Tabela)xres;
                        String ax = this.removerCaracteresEspeciais(R.getTexto() + (tabs.size() > 1 ? "_" + String.valueOf(tabs.indexOf(T) + 1) : ""));
                        T2.setTexto(ax);
                        this.Links.Add(R, xres);
                        this.setOrigemLigacao(this.LinkTable(T, T2, 0, Card2), T2);
                        Tabela TT = T2;
                        T.getCampos().stream().filter(c -> c.isKey()).forEach(C -> {
                            Campo c = this.ImportaCampo(TT, (Campo)C, T.getTexto() + "_A_");
                            c.setKey(false);
                            c.setFkey(true);
                            this.setCampoOrigem(c, (Campo)C);
                        });
                        T.getCampos().stream().filter(c -> c.isKey()).forEach(C -> {
                            Campo c = this.ImportaCampo(TT, (Campo)C, T.getTexto() + "_B_");
                            c.setKey(false);
                            c.setFkey(true);
                            this.setCampoOrigem(c, (Campo)C);
                        });
                        this.frutoAutoRelacionamento.add(TT);
                    }
                }
                if (this.recebaEConvertaAtributos(R, T2, R.getListaDeFormasLigadas().stream().filter(a -> a instanceof Atributo).map(a -> (Atributo)a).collect(Collectors.toList()))) continue;
                return false;
            }
        }
        return true;
    }

    private FormaElementar CriarTabela(Tabela T) {
        Point p = new Point(T.getLeftWidth() + 120, T.getTop());
        p = this.EspacoOcupado(T, p);
        FormaElementar xres = this.destino.ExternalRealiseComando(Controler.Comandos.cmdTabela, p);
        return xres;
    }

    private FormaElementar CriarTabela(Point pos) {
        Point p = new Point(pos.x, pos.y);
        FormaElementar xres = this.destino.ExternalRealiseComando(Controler.Comandos.cmdTabela, p);
        return xres;
    }

    public boolean converterEspecializacao() {
        Especializacao Esp;
        List lst = this.origem.getListaDeItens().stream().filter(o -> o instanceof Especializacao).map(r -> (Especializacao)r).collect(Collectors.toList());
        int i = 0;
        while (i < lst.size()) {
            Esp = (Especializacao)lst.get(i);
            if (Esp.LigadaAoPontoPrincipal() == null || Esp.getListaDePontosLigados().size() < 2) {
                this.Opcoes.Erros.add(Utilidades.EncapsuleMsg("msg25", new Object[]{Esp.getID()}));
                lst.remove(Esp);
                continue;
            }
            ++i;
        }
        i = 0;
        while (lst.size() > 0 && i < lst.size()) {
            Esp = (Especializacao)lst.get(i);
            PreEntidade entP = Esp.LigadaAoPontoPrincipal();
            boolean tmpContinue = true;
            List<Especializacao> tmp = this.getEspecializacaoDeEspecializada(entP, Esp);
            for (Especializacao espTmp : tmp) {
                if (lst.indexOf(espTmp) == -1) continue;
                tmpContinue = false;
                break;
            }
            if (tmpContinue) {
                if (!this.converterEspecializacaoProcesse(Esp, entP)) {
                    return false;
                }
                lst.remove(Esp);
                i = 0;
                continue;
            }
            ++i;
        }
        return true;
    }

    private List<Especializacao> getEspecializacaoDeEspecializada(PreEntidade ent, Especializacao exceto) {
        return ent.getListaDeFormasLigadas().stream().filter(f -> f instanceof Especializacao && f != exceto).map(f -> (Especializacao)f).filter(e -> e.LigadaAoPontoPrincipal() != ent).collect(Collectors.toList());
    }

    private boolean converterEspecializacaoProcesse(Especializacao Esp, PreEntidade entP) {
        List lst = Esp.getListaDeFormasLigadas().stream().filter(o -> o instanceof PreEntidade && o != entP).map(pr -> (PreEntidade)pr).collect(Collectors.toList());
        this.Opcoes.Inicializar();
        this.Opcoes.Textos.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg26") + " " + (Esp.isParcial() ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg27") + " " : (Esp.isTotal() ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg28") + " " : "")) + (Esp.isExclusiva() ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg29") : (Esp.isNaoExclusiva() ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg30") : "")));
        if (lst.size() == 1) {
            this.Opcoes.Textos.add(Utilidades.EncapsuleMsg("msg31", entP.getTexto()));
        } else {
            this.Opcoes.Textos.add(Utilidades.EncapsuleMsg("msg32", new Object[]{lst.size(), entP.getTexto()}));
        }
        this.AddObservacoes(Esp, false);
        this.Opcoes.opcDefault = Esp.isParcial() ? 0 : 1;
        this.Opcoes.Questoes.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg33"));
        this.Opcoes.Questoes.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg34"));
        if (entP.getListaDeFormasLigadas().stream().filter(e -> e instanceof Especializacao).map(f -> (Especializacao)f).filter(e -> e.LigadaAoPontoPrincipal() == entP).count() == 1L) {
            this.Opcoes.Questoes.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg35") + (Esp.isParcial() ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg36") : ""));
        } else {
            this.Opcoes.Textos.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg37"));
        }
        this.Opcoes.obj = Esp;
        for (PreEntidade pre : lst) {
            if (pre.getListaDeFormasLigadas().stream().filter(e -> e instanceof Especializacao).map(f -> (Especializacao)f).filter(e -> e.LigadaAoPontoPrincipal() != pre).count() <= 1L) continue;
            this.Opcoes.opcDefault = 0;
            this.Opcoes.Disables.add(1);
            this.Opcoes.Textos.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg38"));
            break;
        }
        if (!this.Questione()) {
            return false;
        }
        this.Links.getLigadosOrigem(entP).stream().filter(o -> o instanceof Tabela).map(o -> (Tabela)o).forEach(principal -> {
            ArrayList secundarias = new ArrayList();
            lst.stream().forEach(pre -> this.Links.getLigadosOrigem((FormaElementar)pre).stream().filter(o -> o instanceof Tabela).map(o -> (Tabela)o).forEach(t -> secundarias.add(t)));
            String pretx = (Utilidades.IsUpper(principal.getTexto()) ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix") : Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix").toLowerCase()) + principal.getTexto() + "_";
            int opc = this.Opcoes.OPC;
            switch (opc) {
                case 0: {
                    secundarias.forEach(s -> {
                        this.setOrigemLigacao(this.LinkTable((Tabela)principal, (Tabela)s, 0, 1), (Tabela)s);
                        this.ImportaCampoChaveKFK((Tabela)principal, (Tabela)s, pretx);
                    });
                    break;
                }
                case 1: {
                    String st = "";
                    secundarias.stream().filter(s -> s != principal).map(s -> ", " + s.getTexto()).reduce(st, String::concat);
                    secundarias.stream().filter(s -> s != principal).forEach(s -> {
                        this.MoverLigacoes((Tabela)s, (Tabela)principal);
                        List<Campo> oldkeys = principal.getCampos().stream().filter(cam -> cam.isKey()).collect(Collectors.toList());
                        this.ImportaCampo((Tabela)s, (Tabela)principal);
                        this.NormaliseImportacaoKeys((Tabela)principal, oldkeys, secundarias, pretx);
                        this.TroqueLinksDestino((Tabela)s, (Tabela)principal);
                        this.destino.Remove((FormaElementar)s, true);
                    });
                    if (!Esp.isExclusiva()) break;
                    if (!this.campoTipoJaSetado.containsKey(principal)) {
                        Campo c = principal.Add("");
                        String ax = this.removerCaracteresEspeciais(principal.getTexto());
                        c.setTexto(ax + Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.conceitual.sufixo.tipo"));
                        c.setTipo(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg15"));
                        c.setObservacao(Utilidades.EncapsuleMsg("msg39", principal.getTexto()));
                        this.campoTipoJaSetado.put((Tabela)principal, c);
                    }
                    this.campoTipoJaSetado.get(principal).setObservacao(this.campoTipoJaSetado.get(principal).getObservacao() + st);
                    break;
                }
                case 2: {
                    principal.getListaDePontosLigados().stream().map(p -> (LogicoLinha)p.getDono()).forEach(L -> {
                        Tabela ori = (Tabela)L.getOutraPonta((Forma)principal);
                        secundarias.stream().filter(s -> s != principal && ori != s).forEach(s -> {
                            int c1 = L.getCardA().CardToInt();
                            int c2 = L.getCardB().CardToInt();
                            if (L.getFormaPontaA() != principal) {
                                c2 = L.getCardA().CardToInt();
                                c1 = L.getCardB().CardToInt();
                            }
                            this.setOrigemLigacao(this.LinkTable(ori, (Tabela)s, c2, c1), (Tabela)s);
                        });
                        this.destino.Remove((FormaElementar)L, true);
                    });
                    List<conversorLink.par> destEqPrinc = this.Links.Lista.stream().filter(p -> p.destino == principal).collect(Collectors.toList());
                    destEqPrinc.forEach(dp -> this.Links.Lista.remove(dp));
                    secundarias.stream().filter(s -> s != principal).forEach(s -> {
                        this.ImportaCampo((Tabela)principal, (Tabela)s);
                        destEqPrinc.forEach(dp -> this.Links.Add(dp.origem, (FormaElementar)s));
                        this.Links.Add(entP, (FormaElementar)s);
                    });
                    this.destino.Remove((FormaElementar)principal, true);
                    this.Links.RemovePar(entP, (FormaElementar)principal);
                }
            }
        });
        return true;
    }

    private boolean MoverLigacoes(Tabela origem, Tabela destino) {
        if (origem == destino || origem == null || destino == null) {
            return false;
        }
        List lst = origem.getListaDePontosLigados().stream().collect(Collectors.toList());
        while (lst.size() > 0) {
            PontoDeLinha pt = (PontoDeLinha)lst.get(0);
            int ld = pt.getLado();
            Point p = new Point();
            switch (ld) {
                case 0: {
                    p = new Point(destino.getLeft() + 2, destino.getTop() + destino.getHeight() / 2);
                    break;
                }
                case 1: {
                    p = new Point(destino.getLeft() + destino.getWidth() / 2, destino.getTop() + 2);
                    break;
                }
                case 2: {
                    p = new Point(destino.getLeftWidth() - 2, destino.getTop() + destino.getHeight() / 2);
                    break;
                }
                case 3: {
                    p = new Point(destino.getLeft() + destino.getWidth() / 2, destino.getTopHeight() - 2);
                }
            }
            pt.setCentro(p);
            pt.SetEm(destino);
            pt.getDono().OrganizeLinha();
            pt.getDono().reSetBounds();
            lst.remove(pt);
        }
        this.RemovaLigacoesIguais(destino);
        return true;
    }

    private boolean CloneLigacoes(Tabela origem, Tabela destino) {
        if (origem == destino || origem == null || destino == null) {
            return false;
        }
        List ligs = origem.getListaDeLigacoes().stream().map(L -> (LogicoLinha)L).collect(Collectors.toList());
        ligs.stream().forEach(lig -> {
            LogicoLinha lin;
            int ca = lig.getCardA().CardToInt();
            int cb = lig.getCardB().CardToInt();
            if (lig.getFormaPontaA() == origem) {
                Tabela tmp = (Tabela)lig.getFormaPontaB();
                lin = this.LinkTable(destino, tmp, ca, cb);
            } else {
                Tabela tmp = (Tabela)lig.getFormaPontaA();
                lin = this.LinkTable(tmp, destino, cb, ca);
            }
            if (this.origemLigacao.containsKey(lig)) {
                this.setOrigemLigacao(lin, destino);
            }
        });
        this.RemovaLigacoesIguais(destino);
        return true;
    }

    private void RemovaLigacoesIguais(Tabela destino1) {
        List<LogicoLinha> tmpLst1 = destino1.getListaDePontosLigados().stream().map(p -> (LogicoLinha)p.getDono()).collect(Collectors.toList());
        ArrayList ja = new ArrayList();
        tmpLst1.forEach(Linha2 -> tmpLst1.stream().filter(lin -> lin != Linha2 && ja.indexOf(Linha2) == -1 && ja.indexOf(lin) == -1 && this.LigacoeIguais((LogicoLinha)Linha2, (LogicoLinha)lin)).forEach(L -> {
            this.destino.Remove((FormaElementar)L, true);
            ja.add(L);
        }));
    }

    private void TroqueLinksDestino(Tabela de, Tabela para) {
        if (de == para || de == null || para == null) {
            return;
        }
        this.Links.Lista.stream().filter(p -> p.destino == de).forEach(p -> {
            p.destino = para;
        });
    }

    public boolean converterRelacionamento() {
        List lst = this.origem.getListaDeItens().stream().filter(o -> o instanceof Relacionamento).map(r -> (Relacionamento)r).collect(Collectors.toList());
        this.origem.getListaDeItens().stream().filter(o -> o instanceof EntidadeAssociativa).map(ea -> (Relacionamento)((EntidadeAssociativa)ea).getInterno()).forEach(r -> lst.add(r));
        int j = 0;
        while (j < lst.size()) {
            Relacionamento re = (Relacionamento)lst.get(j);
            if (re.isAutoRelacionamento()) {
                lst.remove(re);
                continue;
            }
            if (re.getListaDeFormasLigadas().stream().filter(f -> f instanceof PreEntidade).map(f -> (PreEntidade)f).count() < 2L) {
                this.Opcoes.Erros.add(Utilidades.EncapsuleMsg("msg40", re.getTexto()));
                lst.remove(re);
                continue;
            }
            ++j;
        }
        for (Relacionamento re : lst) {
            boolean tudocard0;
            List<Ligacao> ligacoes = re.getListaDePontosLigados().stream().filter(p -> p.getDono().getOutraPonta(re) instanceof PreEntidade).map(p -> (Ligacao)p.getDono()).collect(Collectors.toList());
            int tl = Math.toIntExact(ligacoes.stream().filter(L -> L.getCard().getCard() == PreCardinalidade.TiposCard.C11).count());
            boolean bl = tudocard0 = tl == ligacoes.size();
            if (!(tudocard0 ? !this.converterRelacionamentoMerge(re, ligacoes.stream().map(L -> (PreEntidade)L.getOutraPonta(re)).collect(Collectors.toList())) : (ligacoes.size() > 2 ? !this.converterRelacionamentoTernario(re, ligacoes) : !this.converterRelacionamentoBinario(re, ligacoes)))) continue;
            return false;
        }
        return true;
    }

    public boolean converterEntidadeAssossiativa() {
        this.origem.getListaDeItens().stream().filter(o -> o instanceof EntidadeAssociativa).map(r -> (EntidadeAssociativa)r).forEach(entP -> {
            Tabela principal = this.Links.getLigadosOrigem((FormaElementar)entP).stream().filter(o -> o instanceof Tabela).map(o -> (Tabela)o).findFirst().orElse(null);
            Tabela secundaria = this.Links.getLigadosOrigem(entP.getInterno()).stream().filter(o -> o instanceof Tabela).map(o -> (Tabela)o).findFirst().orElse(null);
            this.MoverLigacoes(secundaria, principal);
            this.ImportaCampo(secundaria, principal);
            this.TroqueLinksDestino(secundaria, principal);
            String ax = this.removerCaracteresEspeciais(principal.getTexto() + "_" + secundaria.getTexto());
            principal.SetTexto(ax);
            this.destino.Remove(secundaria, true);
        });
        return true;
    }

    private boolean converterRelacionamentoMerge(Relacionamento re, List<PreEntidade> lst) {
        ArrayList tabelas = new ArrayList();
        lst.stream().forEach(pree -> this.Links.getLigadosOrigem((FormaElementar)pree).stream().filter(fe -> fe instanceof Tabela).map(fe -> (Tabela)fe).forEach(t -> {
            if (tabelas.indexOf(t) == -1) {
                tabelas.add(t);
            }
        }));
        if (tabelas.size() < 2) {
            if (tabelas.size() == 1) {
                return this.recebaEConvertaAtributos(re, (Tabela)tabelas.get(0), re.getListaDeFormasLigadas().stream().filter(f -> f instanceof Atributo).map(f -> (Atributo)f).collect(Collectors.toList()));
            }
            return true;
        }
        Tabela prin = (Tabela)tabelas.get(0);
        tabelas.remove(0);
        re.getListaDeFormasLigadas().stream().filter(f -> f instanceof Atributo).map(f -> (Atributo)f).forEach(a -> this.ImportaComoCampo(prin, (Atributo)a));
        int x = prin.getLeft();
        int y = prin.getTop();
        for (Tabela t : tabelas) {
            this.TroqueLinksDestino(t, prin);
            if (this.MoverLigacoes(t, prin)) {
                this.ImportaCampo(t, prin);
            }
            this.destino.Remove(t, true);
            x += t.getLeft();
            y += t.getTop();
            String ax = this.removerCaracteresEspeciais(prin.getTexto() + "_" + t.getTexto());
            prin.SetTexto(ax);
        }
        prin.DoMove((x /= tabelas.size() + 1) - prin.getLeft(), (y /= tabelas.size() + 1) - prin.getTop());
        this.Links.Add(re, prin);
        return true;
    }

    private boolean converterRelacionamentoTernario(Relacionamento re, List<Ligacao> ligacoes) {
        ArrayList tabelas = new ArrayList();
        ArrayList cards = new ArrayList();
        ligacoes.stream().forEach(L -> {
            PreEntidade pre = (PreEntidade)L.getOutraPonta(re);
            this.Links.getLigadosOrigem(pre).stream().filter(fe -> fe instanceof Tabela).map(fe -> (Tabela)fe).forEach(t -> {
                if (tabelas.indexOf(t) == -1) {
                    tabelas.add(t);
                    cards.add(L.getCard().getCard());
                }
            });
        });
        if (tabelas.size() < 2) {
            if (tabelas.size() == 1) {
                return this.recebaEConvertaAtributos(re, (Tabela)tabelas.get(0), re.getListaDeFormasLigadas().stream().filter(f -> f instanceof Atributo).map(f -> (Atributo)f).collect(Collectors.toList()));
            }
            return true;
        }
        Tabela prin = (Tabela)this.CriarTabela(re.getLocation());
        String ax = this.removerCaracteresEspeciais(re.getTexto());
        prin.SetTexto(ax);
        for (int i = 0; i < tabelas.size(); ++i) {
            Tabela t = (Tabela)tabelas.get(i);
            PreCardinalidade.TiposCard card = (PreCardinalidade.TiposCard)((Object)cards.get(i));
            PreCardinalidade.TiposCard card2 = cards.get(i) == PreCardinalidade.TiposCard.C01 || cards.get(i) == PreCardinalidade.TiposCard.C0N ? PreCardinalidade.TiposCard.C01 : PreCardinalidade.TiposCard.C11;
            this.setOrigemLigacao(this.LinkTable(prin, t, card2.ordinal(), card.ordinal()), prin);
            this.ImportaCampoChave(t, prin, t.getTexto() + "_");
            ax = this.removerCaracteresEspeciais(prin.getTexto() + "_" + t.getTexto());
            prin.setTexto(ax);
        }
        this.Links.Add(re, prin);
        return true;
    }

    private boolean converterRelacionamentoBinario(Relacionamento re, List<Ligacao> ligacoes) {
        int c1;
        int c2;
        ArrayList tabs_origem;
        ArrayList tabs_destino;
        PreEntidade ent1;
        PreEntidade ent2;
        int card2;
        int card1;
        ArrayList tabelasO = new ArrayList();
        ArrayList tabelasD = new ArrayList();
        ArrayList cards = new ArrayList();
        ArrayList<PreEntidade> entidades = new ArrayList<PreEntidade>();
        ligacoes.stream().filter(L -> L.getOutraPonta(re) instanceof PreEntidade).forEach(L -> {
            entidades.add((PreEntidade)L.getOutraPonta(re));
            cards.add(L.getCard().getCard());
        });
        this.Links.getLigadosOrigem((FormaElementar)entidades.get(0)).stream().filter(fe -> fe instanceof Tabela).map(fe -> (Tabela)fe).forEach(t -> {
            if (tabelasO.indexOf(t) == -1) {
                tabelasO.add(t);
            }
        });
        this.Links.getLigadosOrigem((FormaElementar)entidades.get(1)).stream().filter(fe -> fe instanceof Tabela).map(fe -> (Tabela)fe).forEach(t -> {
            if (tabelasD.indexOf(t) == -1) {
                tabelasD.add(t);
            }
        });
        if (tabelasO.isEmpty() || tabelasD.isEmpty()) {
            if (tabelasO.isEmpty() && tabelasD.isEmpty()) {
                return true;
            }
            return this.recebaEConvertaAtributos(re, tabelasO.isEmpty() ? (Tabela)tabelasD.get(0) : (Tabela)tabelasO.get(0), re.getListaDeFormasLigadas().stream().filter(f -> f instanceof Atributo).map(f -> (Atributo)f).collect(Collectors.toList()));
        }
        if (((PreCardinalidade.TiposCard)((Object)cards.get(1))).ordinal() < ((PreCardinalidade.TiposCard)((Object)cards.get(0))).ordinal()) {
            card1 = ((PreCardinalidade.TiposCard)((Object)cards.get(1))).ordinal();
            card2 = ((PreCardinalidade.TiposCard)((Object)cards.get(0))).ordinal();
            ent2 = (PreEntidade)entidades.get(0);
            ent1 = (PreEntidade)entidades.get(1);
            tabs_destino = tabelasO;
            tabs_origem = tabelasD;
        } else {
            tabs_destino = tabelasD;
            tabs_origem = tabelasO;
            card1 = ((PreCardinalidade.TiposCard)((Object)cards.get(0))).ordinal();
            card2 = ((PreCardinalidade.TiposCard)((Object)cards.get(1))).ordinal();
            ent1 = (PreEntidade)entidades.get(0);
            ent2 = (PreEntidade)entidades.get(1);
        }
        List<Atributo> attrs = re.getListaDeFormasLigadas().stream().filter(f -> f instanceof Atributo).map(f -> (Atributo)f).collect(Collectors.toList());
        if (card1 == 0 && card2 == 0 || card1 < 2 && card2 > 1 || card1 == 0 && card2 == 1) {
            this.Opcoes.Inicializar();
            this.Opcoes.Textos.add(Utilidades.EncapsuleMsg("msg41", PreCardinalidade.CardToString(card1), PreCardinalidade.CardToString(card2)));
            this.Opcoes.Textos.add(Utilidades.EncapsuleMsg("msg20", ent1.getTexto(), ent2.getTexto()) + Utilidades.EncapsuleMsg("msg42", re.getTexto()));
            this.AddObservacoes(re, true);
            this.Opcoes.opcDefault = 0;
            this.Opcoes.Questoes.add(Utilidades.EncapsuleMsg("msg43", ent1.getTexto(), ent2.getTexto()));
            if (card2 == 0) {
                this.Opcoes.Questoes.add(Utilidades.EncapsuleMsg("msg43", ent2.getTexto(), ent1.getTexto()));
            } else if (card2 == 1) {
                this.Opcoes.Questoes.add(Utilidades.EncapsuleMsg("msg46", ent1.getTexto(), ent2.getTexto()));
            }
            this.Opcoes.Questoes.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg47"));
            this.Opcoes.obj = re;
            if (!this.Questione()) {
                return false;
            }
            if (this.Opcoes.OPC == 0 || this.Opcoes.OPC == 1 && card2 == 0) {
                String pf;
                if (this.Opcoes.OPC == 0) {
                    pf = Utilidades.IsUpper(ent1.getTexto()) ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix") : Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix").toLowerCase();
                    tabs_origem.forEach(tab1 -> tabs_destino.forEach(tab2 -> {
                        if (tab1 != tab2) {
                            this.ImportaCampoChave((Tabela)tab1, (Tabela)tab2, pf + ent1.getTexto() + "_");
                            this.setOrigemLigacao(this.LinkTable((Tabela)tab1, (Tabela)tab2, card1, card2), (Tabela)tab2);
                            this.Links.Add(re, (FormaElementar)tab2);
                        } else {
                            this.AdicionarChaveEstrangeira((Tabela)tab1, (Tabela)tab1, null);
                        }
                    }));
                } else {
                    pf = Utilidades.IsUpper(ent2.getTexto()) ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix") : Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix").toLowerCase();
                    tabs_destino.forEach(tab2 -> tabs_origem.forEach(tab1 -> {
                        if (tab1 != tab2) {
                            this.ImportaCampoChave((Tabela)tab2, (Tabela)tab1, pf + ent2.getTexto() + "_");
                            this.setOrigemLigacao(this.LinkTable((Tabela)tab2, (Tabela)tab1, card2, card1), (Tabela)tab1);
                            this.Links.Add(re, (FormaElementar)tab1);
                        } else {
                            this.AdicionarChaveEstrangeira((Tabela)tab1, (Tabela)tab1, null);
                        }
                    }));
                }
                int oldopc = this.Opcoes.OPC;
                int continuo = card2 == 0 ? -1 : 3;
                int tl = 0;
                for (Atributo a : attrs) {
                    if (continuo < 2) {
                        this.Opcoes.Inicializar();
                        this.Opcoes.opcDefault = oldopc;
                        this.Opcoes.Textos.add(Utilidades.EncapsuleMsg("msg44", a.getTexto(), re.getTexto()));
                        this.AddObservacoes(a, true);
                        this.Opcoes.Questoes.add(Utilidades.EncapsuleMsg("msg45", ent2.getTexto()));
                        this.Opcoes.Questoes.add(Utilidades.EncapsuleMsg("msg63", ent1.getTexto()));
                        if (attrs.size() > 1 && tl < attrs.size() - 1) {
                            this.Opcoes.Questoes.add(Utilidades.EncapsuleMsg("msg64", ent2.getTexto()));
                            this.Opcoes.Questoes.add(Utilidades.EncapsuleMsg("msg64", ent1.getTexto()));
                            this.Opcoes.opcDefault = oldopc + 2;
                        }
                        this.Opcoes.obj = a;
                        if (!this.Questione()) {
                            return false;
                        }
                        continuo = this.Opcoes.OPC;
                    }
                    ++tl;
                    ArrayList<Atributo> tmp = new ArrayList<Atributo>();
                    tmp.add(a);
                    if (!(continuo == 0 || continuo == 2 ? !tabs_origem.stream().noneMatch(tab1 -> !this.recebaEConvertaAtributos(re, (Tabela)tab1, (List<Atributo>)tmp)) : !tabs_destino.stream().noneMatch(tab2 -> !this.recebaEConvertaAtributos(re, (Tabela)tab2, (List<Atributo>)tmp)))) continue;
                    return false;
                }
                return true;
            }
            if (this.Opcoes.OPC == 1 && card2 == 1) {
                return this.converterRelacionamentoMerge(re, entidades);
            }
        }
        Tabela prin = (Tabela)this.CriarTabela(re.getLocation());
        String ax = this.removerCaracteresEspeciais(re.getTexto().isEmpty() ? ent1.getTexto() + "_" + ent2.getTexto() : re.getTexto());
        prin.SetTexto(ax);
        String pf = Utilidades.IsUpper(prin.getTexto()) ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix") : Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix").toLowerCase();
        ArrayList<Tabela> jaLigada = new ArrayList<Tabela>();
        for (Tabela t2 : tabs_origem) {
            c2 = card1;
            c1 = 1;
            if (c2 == 0 || c2 == 2) {
                c1 = 0;
            }
            if (prin != t2) {
                this.setOrigemLigacao(this.LinkTable(prin, t2, c2, c1), prin);
                jaLigada.add(t2);
            }
            this.ImportaCampoChave(t2, prin, pf + t2.getTexto() + "_");
        }
        for (Tabela t2 : tabs_destino) {
            c2 = card2;
            c1 = 1;
            if (c2 == 0 || c2 == 2) {
                c1 = 0;
            }
            if (jaLigada.indexOf(t2) > -1) {
                LogicoLinha lig = this.LinkTable(prin, t2, c2, c1);
                this.setOrigemLigacao(lig, prin);
                this.AdicionarChaveEstrangeira(prin, t2, lig);
                continue;
            }
            if (prin != t2) {
                this.setOrigemLigacao(this.LinkTable(prin, t2, c2, c1), prin);
            }
            this.ImportaCampoChave(t2, prin, pf + t2.getTexto() + "_");
        }
        if (!this.recebaEConvertaAtributos(re, prin, attrs)) {
            return false;
        }
        this.Links.Add(re, prin);
        return true;
    }

    private void AdicionarChaveEstrangeira(Tabela tab_recebedora, Tabela tab_origen_PK, LogicoLinha lig) {
        Constraint nova_fk = new Constraint(tab_recebedora);
        nova_fk.setTipo(Constraint.CONSTRAINT_TIPO.tpFK);
        List<Campo> camposKey = tab_origen_PK.getCampos().stream().filter(cm -> cm.isKey()).collect(Collectors.toList());
        String pf = Utilidades.IsUpper(tab_recebedora.getTexto()) ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix") : Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix").toLowerCase();
        camposKey.forEach(C -> {
            Campo c = this.ImportaCampoIgnoreConstrais(tab_recebedora, (Campo)C, pf + tab_origen_PK.getTexto() + "_");
            c.SetFkey(true);
            nova_fk.Add((Campo)C, c);
        });
        this.directFK.put(nova_fk, lig);
        this.directPK.put(nova_fk, tab_origen_PK);
    }

    private void AddObservacoes(Forma re, boolean origem) {
        this.Opcoes.Textos.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg08") + " " + (re.getObservacao().isEmpty() ? "[" + Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg09") + "]" : re.getObservacao()) + (origem ? " - " + Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg10") + " " + re.getTexto() : ""));
    }

    private boolean LigacoeIguais(LogicoLinha Lo, LogicoLinha Ld) {
        return Lo.getFormaPontaA() == Ld.getFormaPontaA() && Lo.getFormaPontaB() == Ld.getFormaPontaB() && Lo.getCardA().getCard() == Ld.getCardA().getCard() && Lo.getCardB().getCard() == Ld.getCardB().getCard() || Lo.getFormaPontaA() == Ld.getFormaPontaB() && Lo.getFormaPontaB() == Ld.getFormaPontaA() && Lo.getCardA().getCard() == Ld.getCardB().getCard() && Lo.getCardB().getCard() == Ld.getCardA().getCard();
    }

    public boolean exportarAssessorios() {
        List lst_tex = this.origem.getListaDeItens().stream().filter(o -> o instanceof Texto).map(r -> (Texto)r).collect(Collectors.toList());
        List lst_des = this.origem.getListaDeItens().stream().filter(o -> o instanceof Desenhador).map(r -> (Desenhador)r).collect(Collectors.toList());
        List lst_leg = this.origem.getListaDeItens().stream().filter(o -> o instanceof Legenda).map(r -> (Legenda)r).collect(Collectors.toList());
        Forma obj = null;
        if (!lst_tex.isEmpty()) {
            obj = (Forma)lst_tex.get(0);
        } else if (!lst_des.isEmpty()) {
            obj = (Forma)lst_des.get(0);
        } else if (!lst_leg.isEmpty()) {
            obj = (Forma)lst_leg.get(0);
        }
        if (obj == null) {
            return true;
        }
        this.Opcoes.Inicializar();
        this.Opcoes.Textos.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg65"));
        this.Opcoes.opcDefault = 0;
        String tmp = lst_tex.isEmpty() ? "" : String.valueOf(lst_tex.size()) + " " + (lst_tex.size() == 1 ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg66") : Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg67"));
        tmp = tmp + (lst_des.isEmpty() ? "" : (tmp.isEmpty() ? " " : ", ") + String.valueOf(lst_des.size()) + " " + (lst_des.size() == 1 ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg68") : Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg69")));
        tmp = tmp + (lst_leg.isEmpty() ? "" : (tmp.isEmpty() ? " " : ", ") + String.valueOf(lst_leg.size()) + " " + (lst_leg.size() == 1 ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg70") : Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg71")));
        this.Opcoes.Questoes.add(Utilidades.EncapsuleMsg("msg72", tmp));
        this.Opcoes.Questoes.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg73"));
        this.Opcoes.obj = obj;
        if (!this.Questione()) {
            return false;
        }
        if (this.Opcoes.OPC == 0) {
            this.origem.ClearSelect();
            this.origem.getListaDeItens().stream().filter(o -> o instanceof Texto || o instanceof Desenhador || o instanceof Legenda).forEach(ass -> this.origem.DiagramaDoSelecao((FormaElementar)ass, false, true));
            this.origem.doCopy();
            this.destino.doPaste();
            this.origem.ClearSelect();
            this.destino.ClearSelect();
        }
        return true;
    }

    public boolean converterUniao() {
        List unioes = this.origem.getListaDeItens().stream().filter(o -> o instanceof Uniao).map(r -> (Uniao)r).collect(Collectors.toList());
        int i = 0;
        while (i < unioes.size()) {
            Uniao U = (Uniao)unioes.get(i);
            if (U.LigadaAoPontoPrincipal() == null || U.getListaDePontosLigados().size() < 2) {
                this.Opcoes.Erros.add(Utilidades.EncapsuleMsg("msg74", new Object[]{U.getID()}));
                unioes.remove(U);
                continue;
            }
            ++i;
        }
        for (Uniao U : unioes) {
            PreEntidade entP = U.LigadaAoPontoPrincipal();
            List lst = U.getListaDeFormasLigadas().stream().filter(o -> o instanceof PreEntidade && o != entP).map(pr -> (PreEntidade)pr).collect(Collectors.toList());
            this.Opcoes.Inicializar();
            this.Opcoes.Textos.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.uniao.uniao") + " " + Utilidades.EncapsuleMsg("msg32", new Object[]{lst.size(), entP.getTexto()}));
            this.AddObservacoes(U, false);
            this.Opcoes.opcDefault = 0;
            this.Opcoes.Questoes.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg33"));
            this.Opcoes.Questoes.add(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msg34"));
            this.Opcoes.obj = U;
            if (!this.Questione()) {
                return false;
            }
            int opc = this.Opcoes.OPC;
            switch (opc) {
                case 0: {
                    this.Links.getLigadosOrigem(entP).stream().filter(o -> o instanceof Tabela).map(o -> (Tabela)o).forEach(principal -> {
                        List<Campo> oldkeys = principal.getCampos().stream().filter(cam -> cam.isKey()).collect(Collectors.toList());
                        ArrayList<Tabela> secundarias = new ArrayList<Tabela>();
                        String prefx = Utilidades.IsUpper(principal.getTexto()) ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix") : Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix").toLowerCase() + principal.getTexto() + "_";
                        lst.stream().forEach(pre -> this.Links.getLigadosOrigem((FormaElementar)pre).stream().filter(o -> o instanceof Tabela).map(o -> (Tabela)o).forEach(s -> {
                            this.setOrigemLigacao(this.LinkTable((Tabela)principal, (Tabela)s, -1, 0), (Tabela)s);
                            this.ImportaCampoChave((Tabela)principal, (Tabela)s, prefx);
                            secundarias.add((Tabela)s);
                        }));
                        this.NormaliseImportacaoKeys((Tabela)principal, oldkeys, (List<Tabela>)secundarias, prefx);
                    });
                    break;
                }
                case 1: {
                    lst.stream().forEach(pre -> {
                        List<Tabela> secundarias = this.Links.getLigadosOrigem((FormaElementar)pre).stream().filter(o -> o instanceof Tabela).map(o -> (Tabela)o).collect(Collectors.toList());
                        this.Links.getLigadosOrigem(entP).stream().filter(o -> o instanceof Tabela).map(o -> (Tabela)o).forEach(principal -> {
                            List<Campo> oldkeys = principal.getCampos().stream().filter(cam -> cam.isKey()).collect(Collectors.toList());
                            secundarias.forEach(s -> {
                                this.CloneLigacoes((Tabela)s, (Tabela)principal);
                                this.ImportaCampo((Tabela)s, (Tabela)principal);
                                List<conversorLink.par> destEqPrinc = this.Links.Lista.stream().filter(p -> p.destino == s).collect(Collectors.toList());
                                destEqPrinc.forEach(dp -> this.Links.Lista.remove(dp));
                                destEqPrinc.forEach(dp -> this.Links.Add(dp.origem, (FormaElementar)principal));
                            });
                            String pretx = Utilidades.IsUpper(principal.getTexto()) ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix") : Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix").toLowerCase() + principal.getTexto() + "_";
                            this.NormaliseImportacaoKeys((Tabela)principal, oldkeys, secundarias, pretx);
                        });
                        secundarias.forEach(s -> {
                            this.destino.Remove((FormaElementar)s, true);
                            List<LogicoLinha> tmpLst1 = s.getListaDePontosLigados().stream().map(p -> (LogicoLinha)p.getDono()).collect(Collectors.toList());
                            tmpLst1.forEach(L -> this.destino.Remove((FormaElementar)L, true));
                        });
                    });
                }
            }
        }
        return true;
    }

    private void NormaliseImportacaoKeys(Tabela principal, List<Campo> oldkeys, List<Tabela> secundarias, String pretx) {
        List newkeys = principal.getCampos().stream().filter(cam -> cam.isKey() && oldkeys.indexOf(cam) == -1).collect(Collectors.toList());
        if (!newkeys.isEmpty()) {
            ArrayList tb_fks = new ArrayList();
            this.camposOrigem.keySet().stream().forEach(dest -> {
                Tabela tbl;
                Campo ori = this.camposOrigem.get(dest);
                if (oldkeys.indexOf(ori) > -1 && secundarias.indexOf(tbl = dest.getTabela()) == -1 && tb_fks.indexOf(tbl) == -1) {
                    tb_fks.add(tbl);
                }
            });
            if (!tb_fks.isEmpty()) {
                newkeys.stream().forEach(a -> tb_fks.forEach(Tab -> {
                    Campo c = Tab.Add("_");
                    String ax = this.removerCaracteresEspeciais(pretx + a.getTexto());
                    c.setTexto(ax);
                    c.setTipo(a.getTipo());
                    c.setFkey(true);
                    this.setCampoOrigem(c, (Campo)a);
                    c.setObservacao(a.getObservacao());
                    c.setDicionario(a.getDicionario());
                }));
            }
        }
    }

    private void renomeieFKs() {
        this.destino.getListaDeTabelas().stream().forEach(tt -> {
            ArrayList nm = new ArrayList();
            String pf = Utilidades.IsUpper(tt.getTexto()) ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix") : Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix").toLowerCase();
            tt.getCampos().stream().filter(C -> C.isFkey() && C.getCampoOrigem() != null).forEach(C -> {
                String ax = this.removerCaracteresEspeciais(pf + C.getTabelaOrigem().getTexto() + "_" + C.getCampoOrigem().getTexto());
                while (nm.indexOf(ax) > -1) {
                    ax = ax + "_";
                }
                nm.add(ax);
                C.setTexto(ax);
            });
            if (this.frutoAutoRelacionamento.indexOf(tt) > -1) {
                ArrayList ja = new ArrayList();
                tt.getCampos().stream().forEach(cmp -> {
                    if (ja.indexOf(cmp.getTexto()) > -1) {
                        cmp.setTexto(cmp.getTexto() + "_" + tt.getTexto());
                    } else {
                        ja.add(cmp.getTexto());
                    }
                });
            }
        });
    }

    private String removerCaracteresEspeciais(String original) {
        if (this.removerEspecial) {
            return Utilidades.textoParaCampo(original);
        }
        return original;
    }

    private void setCampoOrigem(Campo cmp_prin, Campo cmp_origem) {
        this.camposOrigem.put(cmp_prin, cmp_origem);
    }

    private Campo getCampoOrigem(Campo cmp_prin) {
        return this.camposOrigem.get(cmp_prin);
    }

    private void setOrigemLigacao(LogicoLinha linha, Tabela tab) {
        this.origemLigacao.put(linha, tab);
    }

    public boolean processeConstraints() {
        this.destino.getListaDeTabelas().forEach(tb -> tb.getCampos().stream().filter(cmp -> cmp.isKey()).forEach(cmp -> tb.direct_ProcesseIrKey((Campo)cmp)));
        this.destino.getListaDeTabelas().forEach(tb_fk -> {
            tb_fk.getCampos().stream().filter(cmp -> cmp.isFkey() && this.getCampoOrigem((Campo)cmp) != null).forEach(cmp -> {
                Campo cmp_ori = this.getCampoOrigem((Campo)cmp);
                Tabela tb_pk = cmp_ori.getTabela();
                Constraint constr_pk = tb_pk.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpPK).findFirst().orElse(null);
                Constraint constr_fk = tb_fk.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpFK).filter(c -> c.getConstraintOrigem() == constr_pk).findFirst().orElse(null);
                if (constr_fk == null) {
                    constr_fk = new Constraint((Tabela)tb_fk);
                    constr_fk.setTipo(Constraint.CONSTRAINT_TIPO.tpFK);
                }
                LogicoLinha lin = tb_fk.getListaDeLigacoes().stream().filter(L -> L.getOutraPonta((Forma)tb_fk) == tb_pk && this.origemLigacao.get((LogicoLinha)L) == tb_fk).map(L -> (LogicoLinha)L).findAny().orElse(null);
                constr_fk.Add(cmp_ori, (Campo)cmp, lin, constr_pk);
                this.condicaoIR(lin, (Tabela)tb_fk, constr_fk);
                constr_fk.Valide();
            });
            if (this.frutoAutoRelacionamento.indexOf(tb_fk) > -1) {
                this.ProcesseFrutoAutoRel((Tabela)tb_fk);
            }
        });
        return this.processeConstraintsDirect();
    }

    private void condicaoIR(LogicoLinha linha, Tabela tab_fk, Constraint IR) {
        PreCardinalidade.TiposCard cardB;
        PreCardinalidade.TiposCard cardA;
        if (linha == null || tab_fk == null || IR == null) {
            return;
        }
        String CASCADE = "CASCADE";
        String SETNULL = "SET NULL";
        String NOACTION = "NO ACTION";
        String RESTRICT = "RESTRICT";
        if (linha.getFormaPontaB() == tab_fk) {
            cardA = linha.getCardA().getCard();
            cardB = linha.getCardB().getCard();
        } else {
            cardA = linha.getCardB().getCard();
            cardB = linha.getCardA().getCard();
        }
        if (cardA == PreCardinalidade.TiposCard.C01) {
            if (cardB == PreCardinalidade.TiposCard.C0N || cardB == PreCardinalidade.TiposCard.C01) {
                IR.setDdlOnDelete("SET NULL");
            } else {
                IR.setDdlOnDelete("CASCADE");
            }
        } else if (cardA == PreCardinalidade.TiposCard.C11) {
            if (cardB == PreCardinalidade.TiposCard.C0N || cardB == PreCardinalidade.TiposCard.C01) {
                IR.setDdlOnDelete("CASCADE");
            } else {
                IR.setDdlOnDelete("RESTRICT");
            }
        } else {
            IR.setDdlOnDelete("NO ACTION");
        }
    }

    private boolean processeConstraintsDirect() {
        this.directFK.keySet().stream().forEach(fk -> {
            Tabela t_pk = this.directPK.get(fk);
            Constraint constr_pk = t_pk.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpPK).findFirst().orElse(null);
            if (constr_pk != null) {
                Tabela t_fk = fk.getTabela();
                String pf = Utilidades.IsUpper(t_fk.getTexto()) ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix") : Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix").toLowerCase();
                t_pk.getCampos().stream().filter(cm -> cm.isKey() && fk.getCamposDeOrigem().indexOf(cm) < 0).forEach(C -> {
                    Campo c = this.ImportaCampoIgnoreConstrais(t_fk, (Campo)C, pf + t_pk.getTexto() + "_");
                    c.SetFkey(true);
                    fk.Add((Campo)C, c);
                });
                fk.LigacaoDireta(constr_pk, this.directFK.get(fk));
                this.condicaoIR(this.directFK.get(fk), t_fk, (Constraint)fk);
            }
            fk.Valide();
        });
        return true;
    }

    private void ProcesseFrutoAutoRel(Tabela tb_fk) {
        ArrayList ascons = new ArrayList(tb_fk.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpFK).collect(Collectors.toList()));
        ascons.stream().forEach(constr_fk -> {
            ArrayList<Campo> tmp = new ArrayList<Campo>();
            ArrayList<Campo> replicado = new ArrayList<Campo>();
            for (int i = 0; i < constr_fk.getCamposDeOrigem().size(); ++i) {
                Campo co = constr_fk.getCamposDeOrigem().get(i);
                if (tmp.indexOf(co) > -1) {
                    replicado.add(constr_fk.getCamposDeDestino().get(i));
                    continue;
                }
                tmp.add(co);
            }
            if (!replicado.isEmpty()) {
                Constraint nova_fk = new Constraint(tb_fk);
                nova_fk.setTipo(Constraint.CONSTRAINT_TIPO.tpFK);
                LogicoLinha lin = constr_fk.getLigacao();
                if (lin != null) {
                    int Card2 = lin.getCardB().CardToInt();
                    if (lin.getFormaPontaB() != tb_fk) {
                        Card2 = lin.getCardA().CardToInt();
                    }
                    lin = this.LinkTable(constr_fk.getConstraintOrigem().getTabela(), tb_fk, 0, Card2);
                    this.setOrigemLigacao(lin, tb_fk);
                }
                LogicoLinha lig = lin;
                replicado.stream().forEach(rp -> {
                    Campo cmp_ori = constr_fk.getOrigem((Campo)rp);
                    constr_fk.RemoveFromDestino((Campo)rp);
                    nova_fk.Add(cmp_ori, (Campo)rp, lig, constr_fk.getConstraintOrigem());
                });
                this.condicaoIR(lin, tb_fk, nova_fk);
                nova_fk.Valide();
            }
        });
    }
}

