#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

class QTimeLine;
class QResizeEvent;
class MyCircle;
class QGraphicsItemAnimation;
class QListWidgetItem;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void resizeEvent(QResizeEvent *event);

private Q_SLOTS:
    void on_psbStart_clicked();
    void on_psbStop_clicked();
    void on_psbSnapshot_clicked();
    void on_listWidget_itemClicked(QListWidgetItem *item);

    void startTimer();

private:
    Ui::MainWindow *ui;
    MyCircle *m_circle;
    QTimeLine *m_timer;
    QGraphicsItemAnimation *m_animation;

    int m_side;
};

#endif // MAINWINDOW_H
