public abstract class Atividade implements Comparavel, java.io.Serializable{
    private String id;
    private String descricao;
    private Atividade[] pre;
    private Atividade[] pos;
    
    public Atividade(String id, String descricao){
        this.setId(id);
        this.setDescricao(descricao);
        this.pre = new Atividade[0];
        this.pos = new Atividade[0];
    }    
    
    public void addPre(Atividade atividade){
        this.pre = this.addAtividade(atividade, this.pre);
    };    

    public void addPos(Atividade atividade){
        this.pos = this.addAtividade(atividade, this.pos);
    };  
    
    public int comparar(Comparavel comparavel){
        Atividade a = (Atividade)comparavel;
        return this.getDuracao() - a.getDuracao();
    };
    
 //   public int comparar(Atividade atividade){
 //       return this.getDuracao() - atividade.getDuracao();
 //   }    
 
//    public int comparar(Atividade atividade){
//        return this.getId().compareToIgnoreCase(atividade.getId());
//    }   
    
    protected Atividade[] addAtividade(Atividade atividade, Atividade[] atividades){
        Atividade[] novo = new Atividade[atividades.length + 1];
        for(int i = 0; i < atividades.length; i++)
          novo[i] = atividades[i];
        novo[novo.length - 1] = atividade;
        return novo;
    };    
 
    public String getId() {
        return id;
    }

    private void setId(String id) {
        this.id = id;
    }

    public String getDescricao() {
        return descricao;
    }

    private void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public abstract int getDuracao();
    
    public abstract boolean isConcluida();
    
    public int getTempoMelhorCaso(){
        int tempoMelhorCaso = 0;
        for(Atividade a : this.pre) 
          if(a.getTempoMelhorCaso() + a.getDuracao() > tempoMelhorCaso)
            tempoMelhorCaso = a.getTempoMelhorCaso() + a.getDuracao();
        return tempoMelhorCaso;     
    };    
    
    
    public boolean isInicio(){
        return (this.pre.length == 0); 
    };    

    public boolean isFinal(){
        return (this.pos.length == 0); 
    };   
    
    
    public String toString(){
        return this.getId() + "-" + this.getDescricao() + "[" + this.getDuracao() + " u.t.]";
    }    
    
    
}
